<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/* * *****************arrears.php**********************************
 * @product name    : Global Multi School Management System Express
 * @type            : Class
 * @class name      : arrears
 * @description     : Manage all arrears type/head/title as per accounting term.  
 * @author          : Codetroopers Team 	
 * @url             : https://themeforest.net/user/codetroopers      
 * @support         : yousuf361@gmail.com	
 * @copyright       : Codetroopers Team	 	
 * ********************************************************** */

class Arrears extends MY_Controller {

    public $data = array();
    
    
    function __construct() {
        parent::__construct();
         $this->load->model('Arrears_Model', 'arrears', true); 
         
         // need to check school subscription status
        if($this->session->userdata('role_id') != SUPER_ADMIN){                 
            if(!check_saas_status($this->session->userdata('school_id'), 'is_enable_accounting')){                        
              redirect('dashboard/index');
            }
        }
    }

    
    
     /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "arrears List" user interface                 
     *                     
     * @param           : null
     * @return          : null 
     * ********************************************************** */
    public function index($school_id = null) {
        
        check_permission(VIEW);        
        $this->data['arrears'] = $this->arrears->get_arrears_list($school_id); 
        
        $this->data['filter_school_id'] = $school_id;
        $this->data['schools'] = $this->schools;
        
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('manage_arrears'). ' | ' . SMS);
        $this->layout->view('arrears/index', $this->data);            
       
    }

    
     /*****************Function add**********************************
     * @type            : Function
     * @function name   : add
     * @description     : Load "Add new arrears" user interface                 
     *                    and store "arrears" into database 
     * @param           : null
     * @return          : null 
     * ********************************************************** */
    public function add() {

        check_permission(ADD);
        
        if ($_POST) {
            $this->_prepare_arrears_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_arrears_data();

                $insert_id = $this->arrears->insert('arrears', $data);
                if ($insert_id) {
                    
                    create_log('arrears has been created : '.$data['title']);
                    
                    success($this->lang->line('insert_success'));
                    redirect('accounting/arrears/index/'.$data['school_id']);
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('accounting/arrears/add');
                }
            } else {
                error($this->lang->line('insert_failed'));
                $this->data['post'] = $_POST;
            }
        }

        $this->data['arrears'] = $this->arrears->get_arrears_list(); 
        $this->data['schools'] = $this->schools;
        
        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('add'). ' | ' . SMS);
        $this->layout->view('arrears/index', $this->data);
    }

    
     /*****************Function edit**********************************
     * @type            : Function
     * @function name   : edit
     * @description     : Load Update "arrears" user interface                 
     *                    with populated "arrears" value 
     *                    and update "arrears" database    
     * @param           : $id integer value
     * @return          : null 
     * ********************************************************** */
    public function edit($id = null) {       
       
        check_permission(EDIT);
        
          
        if(!is_numeric($id)){
            error($this->lang->line('unexpected_error'));
            redirect('accounting/arrears/index');   
        }
        
        if ($_POST) {
            $this->_prepare_arrears_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_arrears_data();
                $updated = $this->arrears->update('arrears', $data, array('id' => $this->input->post('id')));

                if ($updated) {
                    
                    create_log('arrears has been created : '.$data['title']);                    
                    success($this->lang->line('update_success'));
                    redirect('accounting/arrears/index/'.$data['school_id']); 
                    
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('accounting/arrears/edit/' . $this->input->post('id'));
                }
            } else {
                error($this->lang->line('update_failed'));
                $this->data['arrears'] = $this->arrears->get_single('arrears', array('id' => $this->input->post('id')));
            }
        }
        
        if ($id) {
            $this->data['arrears'] = $this->arrears->get_single('arrears', array('id' => $id));

            if (!$this->data['arrears']) {
                 redirect('accounting/arrears/index');
            }
        }
        
        $this->data['arrears'] = $this->arrears->get_arrears_list($this->data['arrears']->school_id); 
        $this->data['school_id'] = $this->data['arrears']->school_id;
        $this->data['filter_school_id'] = $this->data['arrears']->school_id;
        $this->data['schools'] = $this->schools;
        
        $this->data['edit'] = TRUE;       
        $this->layout->title($this->lang->line('edit'). ' | ' . SMS);
        $this->layout->view('arrears/index', $this->data);
    }

    
    
    /*****************Function _prepare_arrears_validation**********************************
     * @type            : Function
     * @function name   : _prepare_arrears_validation
     * @description     : Process "arrears" user input data validation                 
     *                       
     * @param           : null
     * @return          : null 
     * ********************************************************** */
    private function _prepare_arrears_validation() {
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
        
        $this->form_validation->set_rules('school_id', $this->lang->line('school_name'), 'trim|required');   
        $this->form_validation->set_rules('title', $this->lang->line('title'), 'trim|required|callback_title');   
        $this->form_validation->set_rules('arrears_type', $this->lang->line('arrears_type'), 'trim|required');   
        $this->form_validation->set_rules('amount', $this->lang->line('amount'), 'trim|required');   
    }
    
    
    
        
    /*****************Function title**********************************
     * @type            : Function
     * @function name   : title
     * @description     : Unique check for "arrears title" data/value                  
     *                       
     * @param           : null
     * @return          : boolean true/false 
     * ********************************************************** */ 
   public function title()
   {             
      if($this->input->post('id') == '')
      {   
          $title = $this->arrears->duplicate_check($this->input->post('school_id'), $this->input->post('title')); 
          if($title){
                $this->form_validation->set_message('title', $this->lang->line('already_exist'));         
                return FALSE;
          } else {
              return TRUE;
          }          
      }else if($this->input->post('id') != ''){   
         $title = $this->arrears->duplicate_check($this->input->post('school_id'), $this->input->post('title'), $this->input->post('id')); 
          if($title){
                $this->form_validation->set_message('title', $this->lang->line('already_exist'));         
                return FALSE;
          } else {
              return TRUE;
          }
      }   
   }

   
     /*****************Function _get_posted_arrears_data**********************************
     * @type            : Function
     * @function name   : _get_posted_arrears_data
     * @description     : Prepare "arrears" user input data to save into database                  
     *                       
     * @param           : null
     * @return          : $data array(); value 
     * ********************************************************** */
    private function _get_posted_arrears_data() {

        $items = array();
        $items[] = 'school_id';
        $items[] = 'title';
        $items[] = 'arrears_type';
        $items[] = 'amount';
        $items[] = 'note';
        $data = elements($items, $_POST);  
    
        if ($this->input->post('id')) {
            $data['modified_at'] = date('Y-m-d H:i:s');
            $data['modified_by'] = logged_in_user_id();
        } else {
            $data['status'] = 1;
            $data['created_at'] = date('Y-m-d H:i:s');
            $data['created_by'] = logged_in_user_id();                       
        }

        return $data;
    }

    
    
    /*****************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "arrears" from database                  
     *                       
     * @param           : $id integer value
     * @return          : null 
     * ********************************************************** */
    public function delete($id = null) {
        
        check_permission(DELETE);
        
        if(!is_numeric($id)){
            error($this->lang->line('unexpected_error'));
            redirect('accounting/arrears/index');   
        }
        
        $arrears = $this->arrears->get_single('arrears', array('id' => $id));
        
        if ($this->arrears->delete('arrears', array('id' => $id))) {

            create_log('Has been deleted a arrears : '.$arrears->title);            
            success($this->lang->line('delete_success'));
            
        } else {
            error($this->lang->line('delete_failed'));
        }
        
        redirect('accounting/arrears/index/'.$arrears->school_id);
    }

}
