<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="x_panel">
            <div class="x_title">
                <h3 class="head-title"><i class="fa fa-check-square-o"></i><small> <?php echo $this->lang->line('student_attendance'); ?></small></h3>
                <ul class="nav navbar-right panel_toolbox">
                    <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a></li>                    
                </ul>
                <div class="clearfix"></div>
            </div>

              <div class="x_content quick-link">
                 <?php $this->load->view('quick-link'); ?>  
            </div>
            <div class="x_content">
    <?php echo form_open_multipart(site_url('attendance/student/index'), array('name' => 'student', 'id' => 'student', 'class' => 'form-horizontal form-label-left'), ''); ?>
    <div class="row">
        <?php $this->load->view('layout/school_list_filter'); ?>
        <div class="col-md-2 col-sm-2 col-xs-12">
            <div class="item form-group">
                <div><?php echo $this->lang->line('class'); ?> <span class="required">*</span></div>
                <?php $teacher_access_data = get_teacher_access_data('student'); ?>
                <select class="form-control col-md-7 col-xs-12" name="class_id" id="class_id" required="required" onchange="get_section_by_class(this.value, '');">
                    <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                    <?php foreach ($classes as $obj) { ?>
                        <?php if (isset($classes) && !empty($classes)) { ?>
                            <?php if ($this->session->userdata('role_id') == TEACHER && !in_array($obj->id, $teacher_access_data)) { continue; } ?>
                            <option value="<?php echo $obj->id; ?>" <?php if (isset($class_id) && $class_id == $obj->id) { echo 'selected="selected"'; } ?>><?php echo $obj->name; ?></option>
                        <?php } ?>
                    <?php } ?>
                </select>
                <div class="help-block"><?php echo form_error('class_id'); ?></div>
            </div>
        </div>
        <div class="col-md-2 col-sm-2 col-xs-12">
            <div class="item form-group">
                <div><?php echo $this->lang->line('section'); ?></div>
                <select class="form-control col-md-7 col-xs-12" name="section_id" id="section_id">
                    <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                </select>
                <div class="help-block"><?php echo form_error('section_id'); ?></div>
            </div>
        </div>
         <div class="col-md-2 col-sm-2 col-xs-12">
                        <div class="item form-group"> 
                            <div><?php echo $this->lang->line('exam'); ?>  <span class="required">*</span></div>
                            <?php $exams = get_exams(); ?>
						 <select  class="form-control col-md-7 col-xs-12" name="exam_id" id="exam_id"  required="required">
							<option value="">Select an exam</option>
							<?php foreach ($exams as $exam) : ?>
								<option value="<?php echo $exam->id; ?>"><?php echo $exam->title; ?></option>
							<?php endforeach; ?>
						</select>
							 <div class="help-block"><?php echo form_error('exam_id'); ?></div>
                        </div>
                    </div>
        
         <div class="col-md-2 col-sm-2 col-xs-12">
            <div class="item form-group">
                <div><?php echo $this->lang->line('date'); ?> <span class="required">*</span></div>
                <input class="form-control col-md-7 col-xs-12" name="date" id="date" value="<?php if (isset($date)) { echo $date; } ?>" placeholder="<?php echo $this->lang->line('date'); ?>" required type="text" autocomplete="off">
                <div class="help-block"><?php echo form_error('date'); ?></div>
            </div>
        </div>
        <div class="col-md-1 col-sm-1 col-xs-6">
            <div class="form-group"><br/>
                <button id="send" type="submit" class="btn btn-success"><?php echo $this->lang->line('find'); ?></button>
            </div>
        </div>
    </div>
    <?php echo form_close(); ?>
</div>
        <?php  if (isset($students) && !empty($students)) { ?>
            <div class="x_content">             
                <div class="row">
                    <div class="col-sm-4  col-sm-offset-4 layout-box">
                        <p>
                            <h4><?php echo $this->lang->line('student_attendance'); ?></h4>
                            <?php echo $this->lang->line('day'); ?> : <?php echo date('l', strtotime($date)); ?><br/>
                            <?php echo $this->lang->line('date'); ?> : <?php echo date('jS F Y', strtotime($date)); ?>
                        </p>
                    </div>
                </div>            
            </div>
             <?php } ?>
            
            <div class="x_content">
                <table id="datatable-responsive" class="table table-striped table-bordered dt-responsive nowrap" cellspacing="0" width="100%">
                    <thead>
                        <tr>
                            <th><?php echo $this->lang->line('sl_no'); ?></th>
                            <th><?php echo $this->lang->line('photo'); ?></th>
                            <th><?php echo $this->lang->line('name'); ?></th>
                            <th><?php echo $this->lang->line('email'); ?></th>
                            <th><?php echo $this->lang->line('phone'); ?></th>
                            <th><?php echo $this->lang->line('roll_no'); ?></th>
                            <th><input type="checkbox" value="P" name="present" id="fn_present" class="fn_all_attendnce"/> <?php echo $this->lang->line('present_all'); ?></th>                                            
                            <th><input type="checkbox" value="L" name="late" id="fn_late"  class="fn_all_attendnce"/> <?php echo $this->lang->line('late_all'); ?></th>                                            
                            <th><input type="checkbox" value="A" name="absent" id="fn_absent"  class="fn_all_attendnce"/> <?php echo $this->lang->line('absent_all'); ?></th>                                            
                        </tr>
                    </thead>
                    <tbody id="fn_attendance">   
                        <?php
                        $count = 1;
                        if (isset($students) && !empty($students)) {
                            ?>
                            <?php foreach ($students as $obj) { ?>
                            <?php  $attendance = get_student_attendance($obj->id, $school_id, $academic_year_id, $class_id, $section_id, $year, $month, $day ); ?>
                                <tr>
                                    <td><?php echo $count++;  ?></td>
                                    <td>
                                        <?php if ($obj->photo != '') { ?>
                                            <img src="<?php echo UPLOAD_PATH; ?>/student-photo/<?php echo $obj->photo; ?>" alt="" width="60" /> 
                                        <?php } else { ?>
                                            <img src="<?php echo IMG_URL; ?>/default-user.png" alt="" width="60" /> 
                                        <?php } ?>
                                    </td>  
                                    <td><?php echo ucfirst($obj->name); ?></td>
                                    <td><?php echo $obj->email; ?></td>
                                    <td><?php echo $obj->phone; ?></td>
                                    <td><?php echo $obj->roll_no; ?></td>
                                    <td><input type="radio" value="P" itemid="<?php echo $obj->id; ?>" name="student_<?php echo $obj->id; ?>" class="present fn_single_attendnce" <?php if($attendance == 'P'){ echo 'checked="checked"'; } ?> /></td>
                                    <td><input type="radio" value="L" itemid="<?php echo $obj->id; ?>"  name="student_<?php echo $obj->id; ?>" class="late fn_single_attendnce" <?php if($attendance == 'L'){ echo 'checked="checked"'; } ?>/></td>
                                    <td><input type="radio" value="A" itemid="<?php echo $obj->id; ?>" name="student_<?php echo $obj->id; ?>" class="absent fn_single_attendnce" <?php if($attendance == 'A'){ echo 'checked="checked"'; } ?>/></td>
                                </tr>
                            <?php } ?>
                        <?php }else{ ?>
                                <tr>
                                    <td colspan="9" align="center"><?php echo $this->lang->line('no_data_found'); ?></td>
                                </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div> 
            
        </div>
    </div>
</div>
 <!-- bootstrap-datetimepicker -->
<link href="<?php echo VENDOR_URL; ?>datepicker/datepicker.css" rel="stylesheet">
 <script src="<?php echo VENDOR_URL; ?>datepicker/datepicker.js"></script>
 
 <!-- Super admin js START  -->
 <script type="text/javascript">
         
    $("document").ready(function() {
         <?php if(isset($school_id) && !empty($school_id) && $this->session->userdata('role_id') != TEACHER){ ?>
            $(".fn_school_id").trigger('change');
         <?php } ?>
    });
     
    $('.fn_school_id').on('change', function(){
      
        var school_id = $(this).val();        
        var class_id = '';
        
        <?php if(isset($school_id) && !empty($school_id)){ ?>
            class_id =  '<?php echo $class_id; ?>';
         <?php } ?> 
        
        if(!school_id){
           toastr.error('<?php echo $this->lang->line("select_school"); ?>');
           return false;
        }
       
       $.ajax({       
            type   : "POST",
            url    : "<?php echo site_url('ajax/get_class_by_school'); ?>",
            data   : { school_id:school_id, class_id:class_id},               
            async  : false,
            success: function(response){                                                   
               if(response)
               { 
                   $('#class_id').html(response); 
               }
            }
        });
    }); 

    <?php if(isset($class_id) && isset($section_id)){ ?>
        get_section_by_class('<?php echo $class_id; ?>', '<?php echo $section_id; ?>');
    <?php } ?>
    
    function get_section_by_class(class_id, section_id){       
        
        
        var school_id = $('#school_id').val();        
        
       if(!school_id){
           toastr.error('<?php echo $this->lang->line("select_school"); ?>');
           return false;
        }
        
        $.ajax({       
            type   : "POST",
            url    : "<?php echo site_url('ajax/get_section_by_class'); ?>",
            data   : {school_id:school_id,  class_id : class_id , section_id: section_id},               
            async  : false,
            success: function(response){                                                   
               if(response)
               {
                  $('#section_id').html(response);
               }
            }
        }); 
    }
 </script>
  
<!-- Super admin js end -->
 <script type="text/javascript">
    $('#date').datepicker();
   
 
  
  $(document).ready(function(){
  
       $('#fn_present').click(function(){
           
           if($(this).prop('checked')) {   
               $('input:checkbox').removeAttr('checked');
               $(this).prop('checked', true);
               $('.present').prop('checked', true);
           }else{
               $('.present').prop('checked', false);
           }           
       });
       
       
       $('#fn_late').click(function(){
           
           if($(this).prop('checked')) {   
               $('input:checkbox').removeAttr('checked');
               $(this).prop('checked', true);
               $('.late').prop('checked', true);
           }else{
              $('.late').prop('checked', false); 
           }           
       });
       
       $('#fn_absent').click(function(){
           
           if($(this).prop('checked')) {   
               $('input:checkbox').removeAttr('checked');
               $(this).prop('checked', true);
               $('.absent').prop('checked', true);
           }else{
               $('.absent').prop('checked', false);
           }           
       });
       
       
       $('.fn_single_attendnce').click(function(){
           
          var status     = $(this).prop('checked') ? $(this).val() : '';
          var student_id = $(this).prop('checked') ? $(this).attr('itemid') : '';
          var school_id   = $('#school_id').val();
          var class_id   = $('#class_id').val();
          var section_id = $('#section_id').val();
          var date       = $('#date').val();
          var obj        = $(this);
          
          $.ajax({       
            type   : "POST",
            url    : "<?php echo site_url('attendance/student/update_single_attendance'); ?>",
            data   : {school_id:school_id,  status : status , student_id: student_id, class_id:class_id, section_id:section_id, date:date},               
            async  : false,
            success: function(response){ 
                if(response == 'ay'){
                    
                    toastr.error('<?php echo $this->lang->line('set_academic_year_for_school'); ?>'); 
                    $(obj).prop('checked', false);
                    
                }else if(response == 1){
                    toastr.success('<?php echo $this->lang->line('update_success'); ?>'); 
                }else{
                    toastr.error('<?php echo $this->lang->line('update_failed'); ?>'); 
                    $(obj).prop('checked', false);
                }             
            }
        }); 
                      
       });
       
         $('.fn_all_attendnce').click(function(){
           
          var status     = $(this).prop('checked') ? $(this).val() : '';         
          var school_id   = $('#school_id').val();
          var class_id   = $('#class_id').val();
          var section_id = $('#section_id').val();
          var date       = $('#date').val();
          var obj        = $(this);
          
          $.ajax({       
            type   : "POST",
            url    : "<?php echo site_url('attendance/student/update_all_attendance'); ?>",
            data   : { school_id:school_id, status : status , class_id:class_id, section_id:section_id, date:date},               
            async  : false,
            success: function(response){ 
                if(response == 'ay'){
                    
                    toastr.error('<?php echo $this->lang->line('set_academic_year_for_school'); ?>'); 
                    $('.fn_single_attendnce').prop('checked', false);
                    $(obj).prop('checked', false);
                    
                }else if(response == 1){
                    toastr.success('<?php echo $this->lang->line('update_success'); ?>'); 
                }else{
                    toastr.error('<?php echo $this->lang->line('update_failed'); ?>'); 
                    $('.fn_single_attendnce').prop('checked', false);
                    $(obj).prop('checked', false);
                }           
            }
        }); 
                      
       });
  });
   $("#student").validate();    
</script>

<script>

    // Preserve and restore the selected exam ID
    window.addEventListener('DOMContentLoaded', function () {
        var examIdSelect = document.getElementById('exam_id');
        var storedExamId = localStorage.getItem('selectedExamId');
        if (storedExamId) {
            examIdSelect.value = storedExamId;
        }
        examIdSelect.addEventListener('change', function () {
            localStorage.setItem('selectedExamId', this.value);
        });
    });
	
</script>

