<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/* * *****************Mark.php**********************************
 * @product name    : Global Multi School Management System Express
 * @type            : Class
 * @class name      : Mark
 * @description     : Manage exam mark for student whose are attend in the exam.  
 * @author          : Codetroopers Team 	
 * @url             : https://themeforest.net/user/codetroopers      
 * @support         : yousuf361@gmail.com	
 * @copyright       : Codetroopers Team	 	
 * ********************************************************** */

class Mark extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Mark_Model', 'mark', true);   
        
        // need to check school subscription status
        if($this->session->userdata('role_id') != SUPER_ADMIN){                 
            if(!check_saas_status($this->session->userdata('school_id'), 'is_enable_exam_mark')){                        
              redirect('dashboard/index');
            }
        }
    }

    
    /*****************Function index**********************************
    * @type            : Function
    * @function name   : index
    * @description     : Load "Exam Mark List" user interface                 
    *                    with filter option  
    * @param           : null
    * @return          : null 
    * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        if ($_POST) {

            $school_id = $this->input->post('school_id');
            $exam_id = $this->input->post('exam_id');
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
			 $teacher_id = $this->input->post('teacher_id');
            $subject_id = $this->input->post('subject_id');

            $school = $this->mark->get_school_by_id($school_id);
            if(!$school->academic_year_id){
                error($this->lang->line('set_academic_year_for_school'));
                redirect('exam/mark/index');
            }
            
            $this->data['students'] = $this->mark->get_student_list($school_id, $exam_id, $class_id, $section_id, $subject_id, $school->academic_year_id);

            $condition = array(
                'school_id' => $school_id,
                'exam_id' => $exam_id,
                'class_id' => $class_id,
                'academic_year_id' => $school->academic_year_id,
                'subject_id' => $subject_id,
				//'teacher_id' => $teacher_id
            );
            
            if($section_id){
                $condition['section_id'] = $section_id;
            }

            @$data = $condition;
            
            if (!empty($this->data['students'])) {

                foreach ($this->data['students'] as $obj) {

                    $condition['student_id'] = $obj->student_id;
                    $mark = $this->mark->get_single('marks', $condition);
                    $subject_sing = $this->mark->get_single('subjects', array('id' => $subject_id));

                    if (empty($mark)) {
                        
                        @$data['section_id'] = $obj->section_id;
                        @$data['student_id'] = $obj->student_id;
                        @$data['status'] = 1;
                        @$data['rel_subject_id'] = $subject_sing->relation_id;
                        @$data['created_at'] = date('Y-m-d H:i:s');
                        @$data['created_by'] = logged_in_user_id();
                        $this->mark->insert('marks', @$data);
                    }
                }
            }

            $this->data['grades'] = $this->mark->get_list('grades', array('status' => 1, 'school_id'=>$school_id), '', '', '', 'id', 'ASC');
            
            $this->data['school_id'] = $school_id;
            $this->data['exam_id'] = $exam_id;
            $this->data['class_id'] = $class_id;
            $this->data['section_id'] = $section_id;
            $this->data['subject_id'] = $subject_id;
            $this->data['academic_year_id'] = $school->academic_year_id;
                        
            $class = $this->mark->get_single('classes', array('id'=>$class_id));
            create_log('Has been process exam mark for class: '. $class->name);
            
        }
        
        
        $condition = array();
        $condition['status'] = 1;  
        
        if($this->session->userdata('role_id') != SUPER_ADMIN){
            $school = $this->mark->get_school_by_id($this->session->userdata('school_id'));
            $condition['school_id'] = $this->session->userdata('school_id');
            $this->data['classes'] = $this->mark->get_list('classes', $condition, '','', '', 'id', 'ASC');
            $condition['academic_year_id'] = $school->academic_year_id;
            $this->data['exams'] = $this->mark->get_list('exams', $condition, '', '', '', 'id', 'ASC');
        }  

        $this->layout->title($this->lang->line('manage_mark') . ' | ' . SMS);
        $this->layout->view('mark/index', $this->data);
    }

    
    /*****************Function add**********************************
    * @type            : Function
    * @function name   : add
    * @description     : Process to store "Exam Mark" into database                
    *                     
    * @param           : null
    * @return          : null 
     * ********************************************************** */
    public function add() {

        check_permission(ADD);

        if ($_POST) {

            $school_id = $this->input->post('school_id');
            $exam_id = $this->input->post('exam_id');
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
            $subject_id = $this->input->post('subject_id');
            $relation_id = $this->input->post('relation_id');

            $school = $this->mark->get_school_by_id($school_id);
            if(!$school->academic_year_id){
                error($this->lang->line('set_academic_year_for_school'));
                redirect('exam/mark/index');
            }
            
            $condition = array(
                'school_id' => $school_id,
                'exam_id' => $exam_id,
                'class_id' => $class_id,
                'academic_year_id' => $school->academic_year_id,
                'subject_id' => $subject_id
            );
            
            if($section_id){
                $condition['section_id'] = $section_id;
            }            

            @$data = $condition;

            if (!empty($_POST['students'])) {

                foreach ($_POST['students'] as $key => $value) {

                    $condition['student_id'] = $value;
                    
                    @$data['ca3_mark'] = $_POST['ca3_mark'][$value];
                    @$data['ca3_obtain'] = $_POST['ca3_obtain'][$value];
                    @$data['ca4_mark'] = $_POST['ca4_mark'][$value];
                    @$data['ca4_obtain'] = $_POST['ca4_obtain'][$value];
                    
                    @$data['ex1_mark'] = $_POST['ex1_mark'][$value];
                    @$data['ex1_obtain'] = $_POST['ex1_obtain'][$value];
                    
                     @$data['ex2_mark'] = $_POST['ex2_mark'][$value];
                    @$data['ex2_obtain'] = $_POST['ex2_obtain'][$value];
                    
                     @$data['ex3_mark'] = $_POST['ex3_mark'][$value];
                    @$data['ex3_obtain'] = $_POST['ex3_obtain'][$value];
                    
                     @$data['proj_mark'] = $_POST['proj_mark'][$value];
                    @$data['proj_obtain'] = $_POST['proj_obtain'][$value];
                    
                    @$data['written_mark'] = $_POST['written_mark'][$value];
                    @$data['written_obtain'] = $_POST['written_obtain'][$value];
                    
                    @$data['tutorial_mark'] = $_POST['tutorial_mark'][$value];
                    @$data['tutorial_obtain'] = $_POST['tutorial_obtain'][$value];
                    
                    @$data['practical_mark'] = $_POST['practical_mark'][$value];
                    @$data['practical_obtain'] = $_POST['practical_obtain'][$value];
                    
					 @$data['ca1_temp1_mark'] = $_POST['ca1_temp1_mark'][$value];
                    @$data['ca1_temp1_obtain'] = $_POST['ca1_temp1_obtain'][$value];
                    
                    @$data['ca2_temp1_mark'] = $_POST['ca2_temp1_mark'][$value];
                    @$data['ca2_temp1_obtain'] = $_POST['ca2_temp1_obtain'][$value];
                    
                    @$data['ca3_temp1_mark'] = $_POST['ca3_temp1_mark'][$value];
                    @$data['ca3_temp1_obtain'] = $_POST['ca3_temp1_obtain'][$value];
                     
                     @$data['ca4_temp1_mark'] = $_POST['ca4_temp1_mark'][$value];
                    @$data['ca4_temp1_obtain'] = $_POST['ca4_temp1_obtain'][$value];
                    @$data['exam_temp1_mark'] = $_POST['exam_temp1_mark'][$value];
                    @$data['exam_temp1_obtain'] = $_POST['exam_temp1_obtain'][$value];
					 @$data['temp1_mid_term_total_mark'] = $_POST['temp1_mid_term_total_mark'][$value];
                    @$data['temp1_mid_term_total_obtain'] = $_POST['temp1_mid_term_total_obtain'][$value];
					
					
					
					
					@$data['ca1_temp2_mark'] = $_POST['ca1_temp2_mark'][$value];
                    @$data['ca1_temp2_obtain'] = $_POST['ca1_temp2_obtain'][$value];
                    
                    @$data['ca2_temp2_mark'] = $_POST['ca2_temp2_mark'][$value];
                    @$data['ca2_temp2_obtain'] = $_POST['ca2_temp2_obtain'][$value];
                    
                    @$data['ca3_temp2_mark'] = $_POST['ca3_temp2_mark'][$value];
                    @$data['ca3_temp2_obtain'] = $_POST['ca3_temp2_obtain'][$value];
                     
                     @$data['ca4_temp2_mark'] = $_POST['ca4_temp2_mark'][$value];
                    @$data['ca4_temp2_obtain'] = $_POST['ca4_temp2_obtain'][$value];
                    @$data['exam_temp2_mark'] = $_POST['exam_temp2_mark'][$value];
                    @$data['exam_temp2_obtain'] = $_POST['exam_temp2_obtain'][$value];
					 @$data['temp2_mid_term_total_mark'] = $_POST['temp2_mid_term_total_mark'][$value];
                    @$data['temp2_mid_term_total_obtain'] = $_POST['temp2_mid_term_total_obtain'][$value];
					
					
					
					
					 @$data['ca1_temp4_mark'] = $_POST['ca1_temp4_mark'][$value];
                    @$data['ca1_temp4_obtain'] = $_POST['ca1_temp4_obtain'][$value];
                    
                    @$data['ca2_temp4_mark'] = $_POST['ca2_temp4_mark'][$value];
                    @$data['ca2_temp4_obtain'] = $_POST['ca2_temp4_obtain'][$value];
                    
                    @$data['ca3_temp4_mark'] = $_POST['ca3_temp4_mark'][$value];
                    @$data['ca3_temp4_obtain'] = $_POST['ca3_temp4_obtain'][$value];
                     
                     @$data['ca4_temp4_mark'] = $_POST['ca4_temp4_mark'][$value];
                    @$data['ca4_temp4_obtain'] = $_POST['ca4_temp4_obtain'][$value];
                    @$data['exam_temp4_mark'] = $_POST['exam_temp4_mark'][$value];
                    @$data['exam_temp4_obtain'] = $_POST['exam_temp4_obtain'][$value];
					 @$data['temp4_mid_term_total_mark'] = $_POST['temp4_mid_term_total_mark'][$value];
                    @$data['temp4_mid_term_total_obtain'] = $_POST['temp4_mid_term_total_obtain'][$value];
					
					
					
					
					 @$data['ca1_temp5_mark'] = $_POST['ca1_temp5_mark'][$value];
                    @$data['ca1_temp5_obtain'] = $_POST['ca1_temp5_obtain'][$value];
                    
                    @$data['ca2_temp5_mark'] = $_POST['ca2_temp5_mark'][$value];
                    @$data['ca2_temp5_obtain'] = $_POST['ca2_temp5_obtain'][$value];
                    
                    @$data['ca3_temp5_mark'] = $_POST['ca3_temp5_mark'][$value];
                    @$data['ca3_temp5_obtain'] = $_POST['ca3_temp5_obtain'][$value];
                     
                     @$data['ca4_temp5_mark'] = $_POST['ca4_temp5_mark'][$value];
                    @$data['ca4_temp5_obtain'] = $_POST['ca4_temp5_obtain'][$value];
                    @$data['exam_temp5_mark'] = $_POST['exam_temp5_mark'][$value];
                    @$data['exam_temp5_obtain'] = $_POST['exam_temp5_obtain'][$value];
					 @$data['temp5_mid_term_total_mark'] = $_POST['temp5_mid_term_total_mark'][$value];
                    @$data['temp5_mid_term_total_obtain'] = $_POST['temp5_mid_term_total_obtain'][$value];
					
					
					
					@$data['ca1_temp6_mark'] = $_POST['ca1_temp6_mark'][$value];
                    @$data['ca1_temp6_obtain'] = $_POST['ca1_temp6_obtain'][$value];
                    
                    @$data['ca2_temp6_mark'] = $_POST['ca2_temp6_mark'][$value];
                    @$data['ca2_temp6_obtain'] = $_POST['ca2_temp6_obtain'][$value];
                    
                    @$data['ca3_temp6_mark'] = $_POST['ca3_temp6_mark'][$value];
                    @$data['ca3_temp6_obtain'] = $_POST['ca3_temp6_obtain'][$value];
                     
                     @$data['ca4_temp6_mark'] = $_POST['ca4_temp6_mark'][$value];
                    @$data['ca4_temp6_obtain'] = $_POST['ca4_temp6_obtain'][$value];
                    @$data['exam_temp6_mark'] = $_POST['exam_temp6_mark'][$value];
                    @$data['exam_temp6_obtain'] = $_POST['exam_temp6_obtain'][$value];
					 @$data['temp6_mid_term_total_mark'] = $_POST['temp6_mid_term_total_mark'][$value];
                    @$data['temp6_mid_term_total_obtain'] = $_POST['temp6_mid_term_total_obtain'][$value];
					
					
					@$data['ca1_temp7_mark'] = $_POST['ca1_temp7_mark'][$value];
                    @$data['ca1_temp7_obtain'] = $_POST['ca1_temp7_obtain'][$value];
                    
                    @$data['ca2_temp7_mark'] = $_POST['ca2_temp7_mark'][$value];
                    @$data['ca2_temp7_obtain'] = $_POST['ca2_temp7_obtain'][$value];
                    
                    @$data['ca3_temp7_mark'] = $_POST['ca3_temp7_mark'][$value];
                    @$data['ca3_temp7_obtain'] = $_POST['ca3_temp7_obtain'][$value];
                     
                     @$data['ca4_temp7_mark'] = $_POST['ca4_temp7_mark'][$value];
                    @$data['ca4_temp7_obtain'] = $_POST['ca4_temp7_obtain'][$value];
                    @$data['exam_temp7_mark'] = $_POST['exam_temp7_mark'][$value];
                    @$data['exam_temp7_obtain'] = $_POST['exam_temp7_obtain'][$value];
					 @$data['temp7_mid_term_total_mark'] = $_POST['temp7_mid_term_total_mark'][$value];
                    @$data['temp7_mid_term_total_obtain'] = $_POST['temp7_mid_term_total_obtain'][$value];
					
					
					
					@$data['ca1_jss_mark'] = $_POST['ca1_jss_mark'][$value];
                    @$data['ca1_jss_obtain'] = $_POST['ca1_jss_obtain'][$value];
					
					@$data['ca2_jss_mark'] = $_POST['ca2_jss_mark'][$value];
                    @$data['ca2_jss_obtain'] = $_POST['ca2_jss_obtain'][$value];
					
					@$data['ca_total_mark'] = $_POST['ca_total_mark'][$value];
                    @$data['ca_total_obtain'] = $_POST['ca_total_obtain'][$value];
					
					@$data['ex1_jss_mark'] = $_POST['ex1_jss_mark'][$value];
                    @$data['ex1_jss_obtain'] = $_POST['ex1_jss_obtain'][$value];
					
					@$data['ex2_jss_mark'] = $_POST['ex2_jss_mark'][$value];
                    @$data['ex2_jss_obtain'] = $_POST['ex2_jss_obtain'][$value];
					
					@$data['ex3_jss_mark'] = $_POST['ex3_jss_mark'][$value];
                    @$data['ex3_jss_obtain'] = $_POST['ex3_jss_obtain'][$value];
					
					@$data['tha_total_mark'] = $_POST['tha_total_mark'][$value];
                    @$data['tha_total_obtain'] = $_POST['tha_total_obtain'][$value];
					
					@$data['debate_jss_mark'] = $_POST['debate_jss_mark'][$value];
                    @$data['debate_jss_obtain'] = $_POST['debate_jss_obtain'][$value];
					
					@$data['proj_jss_mark'] = $_POST['proj_jss_mark'][$value];
                    @$data['proj_jss_obtain'] = $_POST['proj_jss_obtain'][$value];
					
					@$data['quiz_jss_mark'] = $_POST['quiz_jss_mark'][$value];
                    @$data['quiz_jss_obtain'] = $_POST['quiz_jss_obtain'][$value];
					
					@$data['ce_total_mark'] = $_POST['ce_total_mark'][$value];
                    @$data['ce_total_obtain'] = $_POST['ce_total_obtain'][$value];
					
					@$data['affective_jss_mark'] = $_POST['affective_jss_mark'][$value];
                    @$data['affective_jss_obtain'] = $_POST['affective_jss_obtain'][$value];
					
					@$data['psychomotor_jss_mark'] = $_POST['psychomotor_jss_mark'][$value];
                    @$data['psychomotor_jss_obtain'] = $_POST['psychomotor_jss_obtain'][$value];
														
                    @$data['viva_mark'] = $_POST['viva_mark'][$value];
                    @$data['viva_obtain'] = $_POST['viva_obtain'][$value];
                    
                    @$data['exam_total_mark'] = $_POST['exam_total_mark'][$value];
                    @$data['obtain_total_mark'] = $_POST['obtain_total_mark'][$value];
                    
                    @$data['grade_id'] = $_POST['grade_id'][$value];                    
                    @$data['remark'] = $_POST['remark'][$value]; 
					
					
					 @$data['mid_term_total_mark'] = $_POST['mid_term_total_mark'][$value];
                    @$data['mid_term_total_obtain'] = $_POST['mid_term_total_obtain'][$value];
                    @$data['status'] = 1;
                    @$data['created_at'] = date('Y-m-d H:i:s');
                    @$data['created_by'] = logged_in_user_id();

                    //Final Update is done here
                    $this->mark->update('marks', @$data, $condition);

                    //Added by D-Ultimate  ---- For the Sub Subject Updating
                    if ($relation_id != 0) {
                        
                        //Means its a sub subject, we do the average and update the main subject
                        $query = "AVG(ca3_obtain) AS ca3_obtain, 
                        AVG(ca4_obtain) AS ca4_obtain,
                        AVG(ex1_obtain) AS ex1_obtain,
                        AVG(ex2_obtain) AS ex2_obtain,
                        AVG(proj_obtain) AS proj_obtain,
                        AVG(ex3_obtain) AS ex3_obtain, 
                        AVG(tutorial_obtain) AS tutorial_obtain,
                        AVG(practical_obtain) AS practical_obtain,
                        AVG(written_obtain) AS written_obtain,
						AVG(ca2_temp1_obtain) AS ca2_temp1_obtain,
                        AVG(ca3_temp1_obtain) AS ca3_temp1_obtain,
                        AVG(ca1_temp1_obtain) AS ca1_temp1_obtain,
                       	AVG(temp1_mid_term_total_obtain) AS temp1_mid_term_total_obtain,
						 AVG(ca2_temp2_obtain) AS ca2_temp2_obtain,
                        AVG(ca3_temp2_obtain) AS ca3_temp2_obtain,
                        AVG(ca1_temp2_obtain) AS ca1_temp2_obtain,
                       	AVG(temp2_mid_term_total_obtain) AS temp2_mid_term_total_obtain,
						 AVG(ca2_temp4_obtain) AS ca2_temp4_obtain,
                        AVG(ca3_temp4_obtain) AS ca3_temp4_obtain,
                        AVG(ca1_temp4_obtain) AS ca1_temp4_obtain,
                       	AVG(temp4_mid_term_total_obtain) AS temp4_mid_term_total_obtain,
						 AVG(ca2_temp5_obtain) AS ca2_temp5_obtain,
                        AVG(ca3_temp5_obtain) AS ca3_temp5_obtain,
                        AVG(ca1_temp5_obtain) AS ca1_temp5_obtain,
                       	AVG(temp5_mid_term_total_obtain) AS temp5_mid_term_total_obtain,
						 AVG(ca2_temp6_obtain) AS ca2_temp6_obtain,
                        AVG(ca3_temp6_obtain) AS ca3_temp6_obtain,
                        AVG(ca1_temp6_obtain) AS ca1_temp6_obtain,
                       	AVG(temp6_mid_term_total_obtain) AS temp6_mid_term_total_obtain,
						 AVG(ca2_temp7_obtain) AS ca2_temp7_obtain,
                        AVG(ca3_temp7_obtain) AS ca3_temp7_obtain,
                        AVG(ca1_temp7_obtain) AS ca1_temp7_obtain,
                       	AVG(temp7_mid_term_total_obtain) AS temp7_mid_term_total_obtain,
						 
                        AVG(ca1_jss_obtain) AS ca1_jss_obtain,
                        AVG(ca2_jss_obtain) AS ca2_jss_obtain,
                        AVG(ca_total_obtain) AS ca_total_obtain,
                        AVG(ex1_jss_obtain) AS ex1_jss_obtain,
                        AVG(ex2_jss_obtain) AS ex2_jss_obtain,
                        AVG(ex3_jss_obtain) AS ex3_jss_obtain,
                        AVG(tha_total_obtain) AS tha_total_obtain,
                        AVG(debate_jss_obtain) AS debate_jss_obtain,
                        AVG(proj_jss_obtain) AS proj_jss_obtain,
                        AVG(quiz_jss_obtain) AS quiz_jss_obtain,
                        AVG(ce_total_obtain) AS ce_total_obtain, 
                        AVG(affective_jss_obtain) AS affective_jss_obtain,
                        AVG(psychomotor_jss_obtain) AS psychomotor_jss_obtain,
                        AVG(viva_obtain) AS viva_obtain,
                        AVG(obtain_total_mark) AS obtain_total_mark,
						AVG(mid_term_total_obtain) AS mid_term_total_obtain";
                    
                        $this->db->select($query);
                        $this->db->from('marks');
                        $this->db->where('student_id', $value);
                        $this->db->where('rel_subject_id', $relation_id);
                        $this->db->where('class_id', $class_id);
                        $this->db->where('exam_id', $exam_id);
                        $this->db->where('school_id', $school_id);
                        $this->db->where('academic_year_id', $school->academic_year_id);
                        $returnedValues = $this->db->get()->row();

                      

                    }
                    //Added by D-Ultimate  ---- For the Sub Subject Updating
                }
            }
            
           $class = $this->mark->get_single('classes', array('id'=>$class_id));
           create_log('Has been process exam mark and save for class: '. $class->name);
            
           success($this->lang->line('insert_success'));
           redirect('exam/mark/index');
        }

       $this->layout->title($this->lang->line('add')  . ' | ' . SMS);
       $this->layout->view('mark/index', $this->data);
    }

}
