<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="x_panel">
            <div class="x_title">
                <h3 class="head-title"><i class="fa fa-dollar"></i><small> <?php echo $this->lang->line('manage_salary_grade'); ?></small></h3>
                <ul class="nav navbar-right panel_toolbox">
                    <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a></li>                    
                </ul>
                <div class="clearfix"></div>
            </div>
            <div class="x_content quick-link">
                <?php $this->load->view('quick-link'); ?>                 
            </div>
            <div class="x_content">
                <div class="" data-example-id="togglable-tabs">
                    
                    <ul  class="nav nav-tabs bordered">
                        <li class="<?php if(isset($list)){ echo 'active'; }?>"><a href="#tab_grade_list"   role="tab" data-toggle="tab" aria-expanded="true"><i class="fa fa-list-ol"></i> <?php echo $this->lang->line('list'); ?></a> </li>
                        <?php if(has_permission(ADD, 'payroll', 'grade')){ ?>
                            <?php if(isset($edit)){ ?>
                                <li  class="<?php if(isset($add)){ echo 'active'; }?>"><a href="<?php echo site_url('payroll/grade/add'); ?>"  aria-expanded="false"><i class="fa fa-plus-square-o"></i> <?php echo $this->lang->line('add'); ?></a> </li>                          
                             <?php }else{ ?>
                                <li  class="<?php if(isset($add)){ echo 'active'; }?>"><a href="#tab_add_grade"  role="tab"  data-toggle="tab" aria-expanded="false"><i class="fa fa-plus-square-o"></i> <?php echo $this->lang->line('add'); ?></a> </li>                          
                             <?php } ?>
                        <?php } ?> 
                        <?php if(isset($edit)){ ?>
                            <li  class="active"><a href="#tab_edit_grade"  role="tab"  data-toggle="tab" aria-expanded="false"><i class="fa fa-pencil-square-o"></i> <?php echo $this->lang->line('edit'); ?></a> </li>                          
                        <?php } ?>
                        
                        <li class="li-class-list">
                       <?php if($this->session->userdata('role_id') == SUPER_ADMIN){  ?>                                 
                            <select  class="form-control col-md-7 col-xs-12" onchange="get_grade_by_school(this.value);">
                                    <option value="<?php echo site_url('payroll/grade/index'); ?>">--<?php echo $this->lang->line('select_school'); ?>--</option> 
                                <?php foreach($schools as $obj ){ ?>
                                    <option value="<?php echo site_url('payroll/grade/index/'.$obj->id); ?>" <?php if(isset($filter_school_id) && $filter_school_id == $obj->id){ echo 'selected="selected"';} ?> > <?php echo $obj->school_name; ?></option>
                                <?php } ?>   
                            </select>
                        <?php } ?>  
                        </li>       
                            
                    </ul>
                    <br/>
                    
                    <div class="tab-content">
                        <div  class="tab-pane fade in <?php if(isset($list)){ echo 'active'; }?>" id="tab_grade_list" >
                            <div class="x_content">
                            <table id="datatable-responsive" class="table table-striped table-bordered dt-responsive nowrap" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <?php if($this->session->userdata('role_id') == SUPER_ADMIN){ ?>
                                            <th><?php echo $this->lang->line('school'); ?></th>
                                        <?php } ?>
                                        <th><?php echo $this->lang->line('grade_name'); ?></th>
                                        <th><?php echo $this->lang->line('basic_salary'); ?></th>
                                        <th><?php echo $this->lang->line('hourly_rate'); ?></th>
                                        <th><?php echo $this->lang->line('gross_salary'); ?></th>
                                        <th><?php echo $this->lang->line('net_salary'); ?></th>
                                        <th><?php echo $this->lang->line('action'); ?></th>                                            
                                    </tr>
                                </thead>
                                <tbody>   
                                    <?php $count = 1; if(isset($grades) && !empty($grades)){ ?>
                                        <?php foreach($grades as $obj){ ?>
                                        <tr>
                                            <td><?php echo $count++; ?></td>
                                            <?php if($this->session->userdata('role_id') == SUPER_ADMIN){ ?>
                                                <td><?php echo $obj->school_name; ?></td>
                                            <?php } ?>
                                            <td><?php echo $obj->grade_name; ?></td>
                                            <td><?php echo $obj->basic_salary; ?></td>
                                            <td><?php echo $obj->hourly_rate; ?></td>
                                            <td><?php echo $obj->gross_salary; ?></td>
                                            <td><?php echo $obj->net_salary; ?></td>
                                            <td>
                                                <?php if(has_permission(EDIT, 'payroll', 'grade')){ ?>
                                                    <a href="<?php echo site_url('payroll/grade/edit/'.$obj->id); ?>" class="btn btn-success btn-xs"><i class="fa fa-pencil-square-o"></i> <?php echo $this->lang->line('edit'); ?> </a>
                                                <?php } ?>
                                                <?php if(has_permission(VIEW, 'payroll', 'grade')){ ?>
                                                    <a  onclick="get_grade_modal(<?php echo $obj->id; ?>);"  data-toggle="modal" data-target=".bs-grade-modal-lg"  class="btn btn-success btn-xs"><i class="fa fa-eye"></i> <?php echo $this->lang->line('view'); ?> </a>
                                                <?php } ?>
                                                <?php if(has_permission(DELETE, 'payroll', 'grade')){ ?>
                                                    <a href="<?php echo site_url('payroll/grade/delete/'.$obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');" class="btn btn-danger btn-xs"><i class="fa fa-trash-o"></i> <?php echo $this->lang->line('delete'); ?> </a>
                                                <?php } ?>
                                            </td>
                                        </tr>
                                        <?php } ?>
                                    <?php } ?>
                                </tbody>
                            </table>
                            </div>
                        </div>

                        <div  class="tab-pane fade in <?php if(isset($add)){ echo 'active'; }?>" id="tab_add_grade">
                            <div class="x_content"> 
                               <?php echo form_open(site_url('payroll/grade/add'), array('name' => 'add', 'id' => 'add', 'class'=>'form-horizontal form-label-left'), ''); ?>
                               
                                 
                                <div class="row">
                                    
                                    <?php $this->load->view('layout/school_list_filter'); ?> 
                                    
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="grade_name"><?php echo $this->lang->line('grade_name'); ?> <span class="required">*</span></label>
                                            <input  class="form-control col-md-7 col-xs-12"  name="grade_name"  id="add_grade_name" value="<?php echo isset($post['grade_name']) ?  $post['grade_name'] : ''; ?>" placeholder="<?php echo $this->lang->line('grade_name'); ?>" required type="text" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('grade_name'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="basic_salary"><?php echo $this->lang->line('basic_salary'); ?> <span class="required">*</span></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="basic_salary"  id="add_basic_salary" value="<?php echo isset($post['basic_salary']) ?  $post['basic_salary'] : ''; ?>" placeholder="<?php echo $this->lang->line('basic_salary'); ?>" required type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('basic_salary'); ?></div>
                                        </div>
                                    </div>
                                    </div>
                                    
                                    <div class="row">
                                <div class="col-md-12 col-sm-12 col-xs-12" style="background:#CCC">
                                        <div class="item form-group">
                                            <label for="deduction"><?php echo $this->lang->line('add_allowance'); ?> </label>
                                         </div>
                                    </div>
                                    </div>
                                   
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="house_rent"><?php echo $this->lang->line('house_rent'); ?> </label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="house_rent"  id="add_house_rent" value="<?php echo isset($post['house_rent']) ?  $post['house_rent'] : ''; ?>" placeholder="<?php echo $this->lang->line('house_rent'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('house_rent'); ?></div>
                                        </div>
                                    </div>
                               
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="transport"><?php echo $this->lang->line('transport_allowance'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="transport"  id="add_transport" value="<?php echo isset($post['transport']) ?  $post['transport'] : ''; ?>" placeholder="<?php echo $this->lang->line('transport_allowance'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('transport'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="medical"><?php echo $this->lang->line('medical_allowance'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="medical"  id="add_medical" value="<?php echo isset($post['medical']) ?  $post['medical'] : ''; ?>" placeholder="<?php echo $this->lang->line('medical_allowance'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('medical'); ?></div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="leave_allowance"><?php echo $this->lang->line('leave_allowance'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="leave_allowance"  id="add_leave_allowance" value="<?php echo isset($post['leave_allowance']) ?  $post['leave_allowance'] : ''; ?>" placeholder="<?php echo $this->lang->line('leave_allowance'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('leave_allowance'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                    <div class="item form-group">
                                            <label for="extra_resp"><?php echo $this->lang->line('extra_resp'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="extra_resp"  id="add_extra_resp" value="<?php echo isset($post['extra_resp']) ?  $post['extra_resp'] : ''; ?>" placeholder="<?php echo $this->lang->line('extra_resp'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('extra_resp'); ?></div>
                                        </div>
                                    </div>
                                   
                                    
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                    <div class="item form-group">
                                            <label for="other_allowance"><?php echo $this->lang->line('other_allowance'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="other_allowance"  id="add_other_allowance" value="<?php echo isset($post['other_allowance']) ?  $post['other_allowance'] : ''; ?>" placeholder="<?php echo $this->lang->line('other_allowance'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('other_allowance'); ?></div>
                                        </div>
                                    </div>
                                                                         
                                      <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="over_time_hourly_rate"><?php echo $this->lang->line('over_time_hourly_rate'); ?> </label>
                                            <input  class="form-control col-md-7 col-xs-12"  name="over_time_hourly_rate"  id="add_over_time_hourly_rate" value="<?php echo isset($post['over_time_hourly_rate']) ?  $post['over_time_hourly_rate'] : ''; ?>" placeholder="<?php echo $this->lang->line('over_time_hourly_rate'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('over_time_hourly_rate'); ?></div>
                                        </div>
                                    </div>
                                    
                                      <div class="row">
                                <div class="col-md-12 col-sm-12 col-xs-12" style="background:#CCC">
                                        <div class="item form-group">
                                            <label for="deduction"><?php echo $this->lang->line('add_deduction'); ?> </label>
                                         </div>
                                    </div>
                                    </div>
                                 
                                     
                                     <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="pension_fund"><?php echo $this->lang->line('pension_fund'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="pension_fund"  id="add_pension_fund" value="<?php echo isset($post['pension_fund']) ?  $post['pension_fund'] : ''; ?>" placeholder="<?php echo $this->lang->line('pension_fund'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('pension_fund'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="payee"><?php echo $this->lang->line('payee'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="payee"  id="add_payee" value="<?php echo isset($post['payee']) ?  $post['payee'] : ''; ?>" placeholder="<?php echo $this->lang->line('payee'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('payee'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="coorperative"><?php echo $this->lang->line('coorperative'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="coorperative"  id="add_coorperative" value="<?php echo isset($post['coorperative']) ?  $post['coorperative'] : ''; ?>" placeholder="<?php echo $this->lang->line('coorperative'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('coorperative'); ?></div>
                                        </div>
                                    </div>
                              <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="rsa"><?php echo $this->lang->line('rsa'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="rsa"  id="add_rsa" value="<?php echo isset($post['rsa']) ?  $post['rsa'] : ''; ?>" placeholder="<?php echo $this->lang->line('rsa'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('rsa'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="welfare_scheme"><?php echo $this->lang->line('welfare_scheme'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="welfare_scheme"  id="add_welfare_scheme" value="<?php echo isset($post['welfare_scheme']) ?  $post['welfare_scheme'] : ''; ?>" placeholder="<?php echo $this->lang->line('welfare_scheme'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('welfare_scheme'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="children_fee"><?php echo $this->lang->line('children_fee'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="children_fee"  id="add_children_fee" value="<?php echo isset($post['children_fee']) ?  $post['children_fee'] : ''; ?>" placeholder="<?php echo $this->lang->line('children_fee'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('children_fee'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="rent"><?php echo $this->lang->line('rent'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="rent"  id="add_rent" value="<?php echo isset($post['rent']) ?  $post['rent'] : ''; ?>" placeholder="<?php echo $this->lang->line('rent'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('rent'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="utility_bill"><?php echo $this->lang->line('utility_bill'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="utility_bill"  id="add_utility_bill" value="<?php echo isset($post['utility_bill']) ?  $post['utility_bill'] : ''; ?>" placeholder="<?php echo $this->lang->line('utility_bill'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('utility_bill'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="sanction"><?php echo $this->lang->line('sanction'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="sanction"  id="add_sanction" value="<?php echo isset($post['sanction']) ?  $post['sanction'] : ''; ?>" placeholder="<?php echo $this->lang->line('sanction'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('sanction'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="salary_advance"><?php echo $this->lang->line('salary_advance'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="salary_advance"  id="add_salary_advance" value="<?php echo isset($post['salary_advance']) ?  $post['salary_advance'] : ''; ?>" placeholder="<?php echo $this->lang->line('salary_advance'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('salary_advance'); ?></div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="tax_deduction"><?php echo $this->lang->line('tax_deduction'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="tax_deduction"  id="add_tax_deduction" value="<?php echo isset($post['tax_deduction']) ?  $post['tax_deduction'] : ''; ?>" placeholder="<?php echo $this->lang->line('tax_deduction'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('tax_deduction'); ?></div>
                                        </div>
                                    </div>
                                  
                                   <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="other_deduction"><?php echo $this->lang->line('other_deduction'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="other_deduction"  id="add_other_deduction" value="<?php echo isset($post['other_deduction']) ?  $post['other_deduction'] : ''; ?>" placeholder="<?php echo $this->lang->line('other_deduction'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('other_deduction'); ?></div>
                                        </div>
                                    </div>
                                    
                               <div class="row">
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="hourly_rate"><?php echo $this->lang->line('hourly_rate'); ?> <span class="required">*</span></label>
                                            <input  class="form-control col-md-7 col-xs-12"  name="hourly_rate"  id="add_hourly_rate" value="<?php echo isset($post['hourly_rate']) ?  $post['hourly_rate'] : ''; ?>" placeholder="<?php echo $this->lang->line('hourly_rate'); ?>" required type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('hourly_rate'); ?></div>
                                        </div>
                                    </div>
                                    </div>
                                  <div class="row">
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="total_allowance"><?php echo $this->lang->line('total_allowance'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="total_allowance"  id="add_total_allowance" value="<?php echo isset($post['total_allowance']) ?  $post['total_allowance'] : ''; ?>" placeholder="<?php echo $this->lang->line('total_allowance'); ?>" type="number" readonly autocomplete="off">
                                            <div class="help-block"><?php echo form_error('total_allowance'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="total_deduction"><?php echo $this->lang->line('total_deduction'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="total_deduction"  id="add_total_deduction" value="<?php echo isset($post['total_deduction']) ?  $post['total_deduction'] : ''; ?>" placeholder="<?php echo $this->lang->line('total_deduction'); ?>" type="number" readonly autocomplete="off">
                                            <div class="help-block"><?php echo form_error('total_deduction'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="gross_salary"><?php echo $this->lang->line('gross_salary'); ?>  </label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="gross_salary"  id="add_gross_salary" value="<?php echo isset($post['gross_salary']) ?  $post['gross_salary'] : ''; ?>" placeholder="<?php echo $this->lang->line('gross_salary'); ?>" type="number" readonly autocomplete="off">
                                            <div class="help-block"><?php echo form_error('gross_salary'); ?></div>
                                        </div>
                                    </div>
                                  <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="net_salary"><?php echo $this->lang->line('net_salary'); ?>  </label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_add_claculate"  name="net_salary"  id="add_net_salary" value="<?php echo isset($post['net_salary']) ?  $post['net_salary'] : ''; ?>" placeholder="<?php echo $this->lang->line('net_salary'); ?>" type="number" readonly autocomplete="off">
                                            <div class="help-block"><?php echo form_error('net_salary'); ?></div>
                                        </div>
                                    </div>
                                    </div>  
                                <div class="row">   
                                 
                                    <div class="col-md-6 col-sm-6 col-xs-12">
                                        <div class="item form-group">
                                            <label for="note"><?php echo $this->lang->line('note'); ?>  </label>
                                            <textarea  class="form-control col-md-7 col-xs-12 textarea-4column"  name="note"  id="note" placeholder="<?php echo $this->lang->line('note'); ?>"><?php echo isset($post['note']) ?  $post['note'] : ''; ?></textarea>
                                            <div class="help-block"><?php echo form_error('note'); ?></div>
                                        </div>
                                    </div>
                                </div>
                               
                                <div class="ln_solid"></div>
                                <div class="form-group">
                                    <div class="col-md-6 col-md-offset-3">
                                        <a href="<?php echo site_url('payroll/grade/index'); ?>" class="btn btn-primary"><?php echo $this->lang->line('cancel'); ?></a>
                                        <button id="send" type="submit" class="btn btn-success"><?php echo $this->lang->line('submit'); ?></button>
                                    </div>
                                </div>
                                <?php echo form_close(); ?>
                            </div>
                        </div>  
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        

                        <?php if(isset($edit)){ ?>
                        <div class="tab-pane fade in active" id="tab_edit_grade">
                            <div class="x_content"> 
                               <?php echo form_open(site_url('payroll/grade/edit/'.$grade->id), array('name' => 'edit', 'id' => 'edit', 'class'=>'form-horizontal form-label-left'), ''); ?>
                                                                                                
                                <div class="row">
                                    
                                    <?php $this->load->view('layout/school_list_edit_form'); ?>
                                    
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="grade_name"><?php echo $this->lang->line('grade_name'); ?> <span class="required">*</span></label>
                                            <input  class="form-control col-md-7 col-xs-12"  name="grade_name"  id="edit_grade_name" value="<?php echo isset($grade->grade_name) ?  $grade->grade_name : ''; ?>" placeholder="<?php echo $this->lang->line('grade_name'); ?>" required type="text"  autocomplete="off">
                                            <div class="help-block"><?php echo form_error('grade_name'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="basic_salary"><?php echo $this->lang->line('basic_salary'); ?> <span class="required">*</span></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="basic_salary"  id="edit_basic_salary" value="<?php echo isset($grade->basic_salary) ?  $grade->basic_salary : ''; ?>" placeholder="<?php echo $this->lang->line('basic_salary'); ?>" required type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('basic_salary'); ?></div>
                                        </div>
                                    </div>
                                    </div>
                                    
                                    
                                    
                                     <div class="row">
                                <div class="col-md-12 col-sm-12 col-xs-12" style="background:#CCC">
                                        <div class="item form-group">
                                            <label for="deduction"><?php echo $this->lang->line('edit_allowance'); ?> </label>
                                         </div>
                                    </div>
                                    </div>
                                    
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="house_rent"><?php echo $this->lang->line('house_rent'); ?> </label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="house_rent"  id="edit_house_rent" value="<?php echo isset($grade->house_rent) ?  $grade->house_rent : ''; ?>" placeholder="<?php echo $this->lang->line('house_rent'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('house_rent'); ?></div>
                                        </div>
                                    </div>
                                
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="transport"><?php echo $this->lang->line('transport_allowance'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="transport"  id="edit_transport" value="<?php echo isset($grade->transport) ?  $grade->transport : ''; ?>" placeholder="<?php echo $this->lang->line('transport_allowance'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('transport'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="medical"><?php echo $this->lang->line('medical_allowance'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="medical"  id="edit_medical" value="<?php echo isset($grade->medical) ?  $grade->medical : ''; ?>" placeholder="<?php echo $this->lang->line('medical_allowance'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('medical'); ?></div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="leave_allowance"><?php echo $this->lang->line('leave_allowance'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="leave_allowance"  id="edit_leave_allowance" value="<?php echo isset($grade->leave_allowance) ?  $grade->leave_allowance : ''; ?>" placeholder="<?php echo $this->lang->line('leave_allowance'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('leave_allowance'); ?></div>
                                        </div>
                                    </div>
                                    </div>    
                                <div class="row">
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="extra_resp"><?php echo $this->lang->line('extra_resp'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="extra_resp"  id="edit_extra_resp" value="<?php echo isset($grade->extra_resp) ?  $grade->extra_resp : ''; ?>" placeholder="<?php echo $this->lang->line('extra_resp_allowance'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('extra_resp'); ?></div>
                                        </div>
                                    </div>
                                    
                                     <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="other_allowance"><?php echo $this->lang->line('other_allowance'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="other_allowance"  id="edit_other_allowance" value="<?php echo isset($grade->other_allowance) ?  $grade->other_allowance : ''; ?>" placeholder="<?php echo $this->lang->line('other_allowance'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('other_allowance'); ?></div>
                                        </div>
                                    </div>
                                      <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="over_time_hourly_rate"><?php echo $this->lang->line('over_time_hourly_rate'); ?> </label>
                                            <input  class="form-control col-md-7 col-xs-12"  name="over_time_hourly_rate"  id="edit_over_time_hourly_rate" value="<?php echo isset($grade->over_time_hourly_rate) ?  $grade->over_time_hourly_rate : ''; ?>" placeholder="<?php echo $this->lang->line('over_time_hourly_rate'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('over_time_hourly_rate'); ?></div>
                                        </div>
                                    </div>
                                    </div>
                                     <div class="row">
                                <div class="col-md-12 col-sm-12 col-xs-12" style="background:#CCC">
                                        <div class="item form-group">
                                            <label for="deduction"><?php echo $this->lang->line('edit_deduction'); ?> </label>
                                         </div>
                                    </div>
                                    </div>
                                    
                                    
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="pension_fund"><?php echo $this->lang->line('pension_fund'); ?> </label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="pension_fund"  id="edit_pension_fund" value="<?php echo isset($grade->pension_fund) ?  $grade->pension_fund : ''; ?>" placeholder="<?php echo $this->lang->line('pension_fund'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('pension_fund'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="payee"><?php echo $this->lang->line('payee'); ?> </label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="payee"  id="edit_payee" value="<?php echo isset($grade->payee) ?  $grade->payee : ''; ?>" placeholder="<?php echo $this->lang->line('payee'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('payee'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="coorperative"><?php echo $this->lang->line('coorperative'); ?> </label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="coorperative"  id="edit_coorperative" value="<?php echo isset($grade->coorperative) ?  $grade->coorperative : ''; ?>" placeholder="<?php echo $this->lang->line('coorperative'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('coorperative'); ?></div>
                                        </div>
                                    </div>
                                   
									<div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="rsa"><?php echo $this->lang->line('rsa'); ?> </label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="rsa"  id="edit_rsa" value="<?php echo isset($grade->rsa) ?  $grade->rsa : ''; ?>" placeholder="<?php echo $this->lang->line('rsa'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('rsa'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="welfare_scheme"><?php echo $this->lang->line('welfare_scheme'); ?> </label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="welfare_scheme"  id="edit_welfare_scheme" value="<?php echo isset($grade->welfare_scheme) ?  $grade->welfare_scheme : ''; ?>" placeholder="<?php echo $this->lang->line('welfare_scheme'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('welfare_scheme'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="children_fee"><?php echo $this->lang->line('children_fee'); ?> </label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="children_fee"  id="edit_children_fee" value="<?php echo isset($grade->children_fee) ?  $grade->children_fee : ''; ?>" placeholder="<?php echo $this->lang->line('children_fee'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('children_fee'); ?></div>
                                        </div>
                                    </div>
                                  <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="rent"><?php echo $this->lang->line('rent'); ?> </label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="rent"  id="edit_rent" value="<?php echo isset($grade->rent) ?  $grade->rent : ''; ?>" placeholder="<?php echo $this->lang->line('rent'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('rent'); ?></div>
                                        </div>
                                    </div>
                                  
                                        <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="utility_bill"><?php echo $this->lang->line('utility_bill'); ?> </label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="utility_bill"  id="edit_utility_bill" value="<?php echo isset($grade->utility_bill) ?  $grade->utility_bill : ''; ?>" placeholder="<?php echo $this->lang->line('utility_bill'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('utility_bill'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="sanction"><?php echo $this->lang->line('sanction'); ?> </label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="sanction"  id="edit_sanction" value="<?php echo isset($grade->sanction) ?  $grade->sanction : ''; ?>" placeholder="<?php echo $this->lang->line('sanction'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('sanction'); ?></div>
                                        </div>
                                    </div>
                                    
                                <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="salary_advance"><?php echo $this->lang->line('salary_advance'); ?> </label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="salary_advance"  id="edit_salary_advance" value="<?php echo isset($grade->salary_advance) ?  $grade->salary_advance : ''; ?>" placeholder="<?php echo $this->lang->line('salary_advance'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('salary_advance'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="tax_deduction"><?php echo $this->lang->line('tax_deduction'); ?> </label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="tax_deduction"  id="edit_tax_deduction" value="<?php echo isset($grade->tax_deduction) ?  $grade->tax_deduction : ''; ?>" placeholder="<?php echo $this->lang->line('tax_deduction'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('tax_deduction'); ?></div>
                                        </div>
                                    </div>
                                     </div>
                                     <div class="row">
								 <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="other_deduction"><?php echo $this->lang->line('other_deduction'); ?> </label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="other_deduction"  id="edit_other_deduction" value="<?php echo isset($grade->other_deduction) ?  $grade->other_deduction : ''; ?>" placeholder="<?php echo $this->lang->line('other_deduction'); ?>" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('other_deduction'); ?></div>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="hourly_rate"><?php echo $this->lang->line('hourly_rate'); ?> <span class="required">*</span></label>
                                            <input  class="form-control col-md-7 col-xs-12"  name="hourly_rate"  id="edit_hourly_rate" value="<?php echo isset($grade->hourly_rate) ?  $grade->hourly_rate : ''; ?>" placeholder="<?php echo $this->lang->line('hourly_rate'); ?>" required type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('hourly_rate'); ?></div>
                                        </div>
                                    </div>
                                  </div>
                                     <div class="row">   
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="total_allowance"><?php echo $this->lang->line('total_allowance'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="total_allowance"  id="edit_total_allowance" value="<?php echo isset($grade->total_allowance) ?  $grade->total_allowance : ''; ?>" placeholder="<?php echo $this->lang->line('total_allowance'); ?>"  readonly="readonly" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('total_allowance'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="total_deduction"><?php echo $this->lang->line('total_deduction'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="total_deduction"  id="edit_total_deduction" value="<?php echo isset($grade->total_deduction) ?  $grade->total_deduction : ''; ?>" placeholder="<?php echo $this->lang->line('total_deduction'); ?>"  readonly="readonly" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('total_deduction'); ?></div>
                                        </div>
                                    </div>
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="gross_salary"><?php echo $this->lang->line('gross_salary'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="gross_salary"  id="edit_gross_salary" value="<?php echo isset($grade->gross_salary) ?  $grade->gross_salary : ''; ?>" placeholder="<?php echo $this->lang->line('gross_salary'); ?>" readonly type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('gross_salary'); ?></div>
                                        </div>
                                    </div>
                                
                                    <div class="col-md-3 col-sm-3 col-xs-12">
                                        <div class="item form-group">
                                            <label for="net_salary"><?php echo $this->lang->line('net_salary'); ?></label>
                                            <input  class="form-control col-md-7 col-xs-12 fn_edit_claculate"  name="net_salary"  id="edit_net_salary" value="<?php echo isset($grade->net_salary) ?  $grade->net_salary : ''; ?>" placeholder="<?php echo $this->lang->line('net_salary'); ?>"  readonly="readonly" type="number" autocomplete="off">
                                            <div class="help-block"><?php echo form_error('net_salary'); ?></div>
                                        </div>
                                    </div>
                                     </div>
                                
                                <div class="row">   
                                    <div class="col-md-6 col-sm-6 col-xs-12">
                                        <div class="item form-group">
                                            <label for="note"><?php echo $this->lang->line('note'); ?></label>
                                            <textarea  class="form-control col-md-7 col-xs-12 textarea-4column"  name="note"  id="note" placeholder="<?php echo $this->lang->line('note'); ?>"><?php echo isset($grade->note) ?  $grade->note : ''; ?></textarea>
                                            <div class="help-block"><?php echo form_error('note'); ?></div>
                                        </div>
                                    </div>
                                </div>
                            
                                   
                                                             
                                <div class="ln_solid"></div>
                                <div class="form-group">
                                    <div class="col-md-6 col-md-offset-3">
                                        <input type="hidden" value="<?php echo isset($grade) ? $grade->id : $id; ?>" name="id" />
                                        <a  href="<?php echo site_url('payroll/grade/index'); ?>" class="btn btn-primary"><?php echo $this->lang->line('cancel'); ?></a>
                                        <button id="send" type="submit" class="btn btn-success"><?php echo $this->lang->line('update'); ?></button>
                                    </div>
                                </div>
                                <?php echo form_close(); ?>
                            </div>
                        </div>  
                        <?php } ?>                    
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade bs-grade-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span></button>
          <h4 class="modal-title"><?php echo $this->lang->line('detail_information'); ?></h4>
        </div>
        <div class="modal-body fn_grade_data">
            
        </div>       
      </div>
    </div>
</div>
<script type="text/javascript">
         
    function get_grade_modal(grade_id){
         
        $('.fn_grade_data').html('<p style="padding: 20px;"><p style="padding: 20px;text-align:center;"><img src="<?php echo IMG_URL; ?>loading.gif" /></p>');
        $.ajax({       
          type   : "POST",
          url    : "<?php echo site_url('payroll/grade/get_single_grade'); ?>",
          data   : {grade_id : grade_id},  
          success: function(response){                                                   
             if(response)
             {
                $('.fn_grade_data').html(response);
             }
          }
       });
    }
</script>


<!-- datatable with buttons -->
 <script type="text/javascript">
        $(document).ready(function() {
          $('#datatable-responsive').DataTable( {
              dom: 'Bfrtip',
              iDisplayLength: 25,
              buttons: [
                  'copyHtml5',
                  'excelHtml5',
                  'csvHtml5',
                  'pdfHtml5',
                  'pageLength'
              ],
              search: true,              
              responsive: true
          });
        });
        
    $("#add").validate();     
    $("#edit").validate();   
    
    
    $('.fn_add_claculate').on('keyup', function(){
        
        var basic_salary = $('#add_basic_salary').val() ? parseFloat($('#add_basic_salary').val()) : 0;
        var house_rent = $('#add_house_rent').val() ? parseFloat($('#add_house_rent').val()) : 0;
        var transport = $('#add_transport').val() ? parseFloat($('#add_transport').val()): 0;
        var medical = $('#add_medical').val() ? parseFloat($('#add_medical').val()) : 0;
        var leave_allowance = $('#add_leave_allowance').val() ? parseFloat($('#add_leave_allowance').val()) : 0;
          
            var extra_resp = $('#add_extra_resp').val() ? parseFloat($('#add_extra_resp').val()) : 0;
           // var bonus = $('#add_bonus').val() ? parseFloat($('#add_bonus').val()) : 0;
           // var extra_resp = $('#add_extra_resp').val() ? parseFloat($('#add_extra_resp').val()) : 0;
            var other_allowance = $('#add_other_allowance').val() ? parseFloat($('#add_other_allowance').val()) : 0;
           // var provident_fund = $('#add_provident_fund').val() ? parseFloat($('#add_provident_fund').val()) : 0;
            var pension_fund = $('#add_pension_fund').val() ? parseFloat($('#add_pension_fund').val()) : 0;
             var payee = $('#add_payee').val() ? parseFloat($('#add_payee').val()) : 0;
             
             var coorperative = $('#add_coorperative').val() ? parseFloat($('#add_coorperative').val()) : 0;
     		 var rsa = $('#add_rsa').val() ? parseFloat($('#add_rsa').val()) : 0;
       		 var welfare_scheme = $('#add_welfare_scheme').val() ? parseFloat($('#add_welfare_scheme').val()) : 0;
       		 var children_fee = $('#add_children_fee').val() ? parseFloat($('#add_children_fee').val()) : 0;
         	 var rent = $('#add_rent').val() ? parseFloat($('#add_rent').val()) : 0;
          	 var utility_bill = $('#add_utility_bill').val() ? parseFloat($('#add_utility_bill').val()) : 0;
           	 var sanction = $('#add_sanction').val() ? parseFloat($('#add_sanction').val()) : 0;
             var salary_advance = $('#add_salary_advance').val() ? parseFloat($('#add_salary_advance').val()) : 0;

             var tax_deduction = $('#add_tax_deduction').val() ? parseFloat($('#add_tax_deduction').val()) : 0;
             var other_deduction = $('#add_other_deduction').val() ? parseFloat($('#add_other_deduction').val()) : 0;
           
       $('#add_total_allowance').val(house_rent+transport+medical+leave_allowance+extra_resp+other_allowance);       
        var total_allowance = $('#add_total_allowance').val() ? parseFloat($('#add_total_allowance').val()) : 0;
        
        $('#add_total_deduction').val(pension_fund+payee+coorperative+rsa+welfare_scheme+children_fee+rent+utility_bill+sanction+salary_advance+other_deduction+tax_deduction);
        var total_deduction = $('#add_total_deduction').val() ? parseFloat($('#add_total_deduction').val()) : 0;
         
        
        $('#add_gross_salary').val(basic_salary+total_allowance);
        $('#add_net_salary').val((basic_salary+total_allowance)-total_deduction);
        
    });
    
    $('.fn_edit_claculate').on('keyup', function(){
        
        var basic_salary = $('#edit_basic_salary').val() ? parseFloat($('#edit_basic_salary').val()) : 0;
        var house_rent = $('#edit_house_rent').val() ? parseFloat($('#edit_house_rent').val()) : 0;
        var transport = $('#edit_transport').val() ? parseFloat($('#edit_transport').val()): 0;
        var medical = $('#edit_medical').val() ? parseFloat($('#edit_medical').val()) : 0;
		var leave_allowance = $('#edit_leave_allowance').val() ? parseFloat($('#edit_leave_allowance').val()) : 0;
          
            var extra_resp = $('#edit_extra_resp').val() ? parseFloat($('#edit_extra_resp').val()) : 0;
           // var bonus = $('#edit_bonus').val() ? parseFloat($('#edit_bonus').val()) : 0;
            var extra_resp = $('#edit_extra_resp').val() ? parseFloat($('#edit_extra_resp').val()) : 0;
            var other_allowance = $('#edit_other_allowance').val() ? parseFloat($('#edit_other_allowance').val()) : 0;
           // var provident_fund = $('#edit_provident_fund').val() ? parseFloat($('#edit_provident_fund').val()) : 0;
            var pension_fund = $('#edit_pension_fund').val() ? parseFloat($('#edit_pension_fund').val()) : 0;
             var payee = $('#edit_payee').val() ? parseFloat($('#edit_payee').val()) : 0;
             
             var coorperative = $('#edit_coorperative').val() ? parseFloat($('#edit_coorperative').val()) : 0;
     		 var rsa = $('#edit_rsa').val() ? parseFloat($('#edit_rsa').val()) : 0;
       		 var welfare_scheme = $('#edit_welfare_scheme').val() ? parseFloat($('#edit_welfare_scheme').val()) : 0;
       		 var children_fee = $('#edit_children_fee').val() ? parseFloat($('#edit_children_fee').val()) : 0;
         	 var rent = $('#edit_rent').val() ? parseFloat($('#edit_rent').val()) : 0;
          	 var utility_bill = $('#edit_utility_bill').val() ? parseFloat($('#edit_utility_bill').val()) : 0;
           	 var sanction = $('#edit_sanction').val() ? parseFloat($('#edit_sanction').val()) : 0;
             var salary_advance = $('#edit_salary_advance').val() ? parseFloat($('#edit_salary_advance').val()) : 0;
             var tax_deduction = $('#edit_tax_deduction').val() ? parseFloat($('#edit_tax_deduction').val()) : 0;
			 
			 var tax_deduction = $('#edit_tax_deduction').val() ? parseFloat($('#edit_tax_deduction').val()) : 0;
             var other_deduction = $('#edit_other_deduction').val() ? parseFloat($('#edit_other_deduction').val()) : 0;
             
        $('#edit_total_allowance').val(house_rent+transport+medical+leave_allowance+extra_resp+other_allowance);       
        var total_allowance = $('#edit_total_allowance').val() ? parseFloat($('#edit_total_allowance').val()) : 0;
        
        $('#edit_total_deduction').val(pension_fund+payee+coorperative+rsa+welfare_scheme+children_fee+rent+utility_bill+sanction+salary_advance+other_deduction+tax_deduction);
        var total_deduction = $('#edit_total_deduction').val() ? parseFloat($('#edit_total_deduction').val()) : 0;
     
        
        $('#edit_gross_salary').val(basic_salary+total_allowance);
        $('#edit_net_salary').val((basic_salary+total_allowance)-total_deduction);
        
    });
    
    function get_grade_by_school(url){          
        if(url){
            window.location.href = url; 
        }
    }  
    
</script>