<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

if (!function_exists('_d')) {

    function _d($data, $exit = TRUE) {
        print '<pre>';
        print_r($data);
        print '</pre>';
        if ($exit)
            exit;
    }
}

if (!function_exists('logged_in_user_id')) {

    function logged_in_user_id() {
        $logged_in_id = 0;
        $CI = & get_instance();
        if ($CI->session->userdata('id') && $CI->session->userdata('role_id')):
            $logged_in_id = $CI->session->userdata('id');
        endif;
        return $logged_in_id;
    }

}

if (!function_exists('logged_in_role_id')) {

    function logged_in_role_id() {
        $logged_in_role_id = 0;
        $CI = & get_instance();
        if ($CI->session->userdata('role_id')):
            $logged_in_role_id = $CI->session->userdata('role_id');
        endif;
        return $logged_in_role_id;
    }

}

if (!function_exists('logged_in_user_type')) {

    function logged_in_user_type() {
        $logged_in_type = 0;
        $CI = & get_instance();
        if ($CI->session->userdata('user_type')):
            $logged_in_id = $CI->session->userdata('user_type');
        endif;
        return $logged_in_type;
    }

}




if (!function_exists('success')) {

    function success($message) {
        $CI = & get_instance();
        $CI->session->set_userdata('success', $message);
        return true;
    }
}

if (!function_exists('error')) {

    function error($message) {
        $CI = & get_instance();
        $CI->session->set_userdata('error', $message);
        return true;
    }

}

if (!function_exists('warning')) {

    function warning($message) {
        $CI = & get_instance();
        $CI->session->set_userdata('warning', $message);
        return true;
    }

}

if (!function_exists('info')) {

    function info($message) {
        $CI = & get_instance();
        $CI->session->set_userdata('info', $message);
        return true;
    }

}

if (!function_exists('get_slug')) {

    function get_slug($slug) {
        if (!$slug) {
            return;
        }

        $char = array("!", "â€™", "'", ":", ",", "_", "`", "~", "@", "#", "$", "%", "^", "&", "*", "(", ")", "+", "=", "{", "}", "[", "]", "/", ";", '"', '<', '>', '?', "'\'",);
        $slug = str_replace($char, "", $slug);
        return $str = strtolower(str_replace(' ', "-", $slug));
    }

}

if (!function_exists('get_status')) {

    function get_status($status) {
        $ci = & get_instance();
        if ($status == 1) {
            return $ci->lang->line('active');
        } elseif ($status == 2) {
            return $ci->lang->line('in_active');
        } elseif ($status == 3) {
            return $ci->lang->line('trash');
        }
    }

}


if (!function_exists('verify_email_format')) {

    function verify_email_format($email) {
        $email = trim($email);
        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            return '';
        } else {
            return $email;
        }
    }

}


if (!function_exists('get_classes')) {

    function get_classes($school_id = null) {
        $ci = & get_instance();
        $ci->db->select('C.*');
        $ci->db->from('classes AS C');
        if($school_id){
            $ci->db->where('C.school_id', $school_id);
        }
         return $ci->db->get()->result();
    }

}

if (!function_exists('get_vehicles')) {

    function get_vehicle_by_ids($ids) {
        $str = '';
        if ($ids) {
            $ci = & get_instance();
            $sql = "SELECT * FROM `vehicles` WHERE `id` IN($ids)";
            $result = $ci->db->query($sql)->result();
            if (!empty($result)) {
                foreach ($result as $obj) {
                    $str .= $obj->number . ',';
                }
            }
        }
        return rtrim($str, ',');
    }

}

if (!function_exists('get_routines_by_day')) {

    function get_routines_by_day($day, $class_id = null, $section_id =null) {
        $ci = & get_instance();
        
        $ci->db->select('R.*, S.name AS subject, T.name AS teacher, C.name AS class_name');
        $ci->db->from('routines AS R');
        $ci->db->join('subjects AS S', 'S.id = R.subject_id', 'left');
        $ci->db->join('teachers AS T', 'T.id = R.teacher_id', 'left');
        $ci->db->join('classes AS C', 'C.id = R.class_id', 'left');
        $ci->db->where('R.day', $day);
               
        if(logged_in_role_id() == TEACHER){
            $ci->db->where('R.teacher_id', $ci->session->userdata('profile_id'));
        }else{
            $ci->db->where('R.class_id', $class_id);
            $ci->db->where('R.section_id', $section_id);
        }
        
        $ci->db->order_by("R.id", "ASC");
       return $ci->db->get()->result();
       
        
    }

}


if (!function_exists('get_student_attendance')) {

    function get_student_attendance($student_id, $school_id, $academic_year_id, $class_id, $section_id, $year, $month, $day) {
        $ci = & get_instance();
        $field = 'day_' . abs($day);
        $ci->db->select('SA.' . $field);
		$ci->db->select('SA.' . $field);
        $ci->db->from('student_attendances AS SA');
        $ci->db->where('SA.student_id', $student_id);
        $ci->db->where('SA.academic_year_id', $academic_year_id);
        $ci->db->where('SA.school_id', $school_id);
        $ci->db->where('SA.class_id', $class_id);
        
        if($section_id){
            $ci->db->where('SA.section_id', $section_id);
        }
        
        $ci->db->where('SA.year', $year);
        $ci->db->where('SA.month', $month);
        return @$ci->db->get()->row()->$field;
    }

}



if (!function_exists('get_teacher_attendance')) {

    function get_teacher_attendance($teacher_id, $school_id, $academic_year_id, $year, $month, $day) {
        $ci = & get_instance();
        $field = 'day_' . abs($day);
        $ci->db->select('TA.' . $field);
        $ci->db->from('teacher_attendances AS TA');
        $ci->db->where('TA.teacher_id', $teacher_id);
        $ci->db->where('TA.school_id', $school_id);
        $ci->db->where('TA.academic_year_id', $academic_year_id);
        $ci->db->where('TA.year', $year);
        $ci->db->where('TA.month', $month);
       return $ci->db->get()->row()->$field;
      // echo $ci->db->last_query();
    }

}

if (!function_exists('get_employee_attendance')) {

    function get_employee_attendance($teacher_id, $school_id, $academic_year_id, $year, $month, $day) {
        $ci = & get_instance();
        $field = 'day_' . abs($day);
        $ci->db->select('EA.' . $field);
        $ci->db->from('employee_attendances AS EA');
        $ci->db->where('EA.school_id', $school_id);
        $ci->db->where('EA.employee_id', $teacher_id);
        $ci->db->where('EA.academic_year_id', $academic_year_id);
        $ci->db->where('EA.year', $year);
        $ci->db->where('EA.month', $month);
        return @$ci->db->get()->row()->$field;
    }

}

//TO USE EXAM ATTENDANCES USE THIS FUNCTION
if (!function_exists('get_exam_attendance')) {

    function get_exam_attendance($school_id, $student_id, $academic_year_id, $exam_id, $class_id, $section_id, $subject_id) {
        $ci = & get_instance();
        $ci->db->select('EA.is_attend');
        $ci->db->from('exam_attendances AS EA');
        $ci->db->where('EA.school_id', $school_id);
        $ci->db->where('EA.academic_year_id', $academic_year_id);
        $ci->db->where('EA.exam_id', $exam_id);
        $ci->db->where('EA.class_id', $class_id);
        if($section_id){
            $ci->db->where('EA.section_id', $section_id);
        }
        $ci->db->where('EA.student_id', $student_id);
        $ci->db->where('EA.subject_id', $subject_id);
        return @$ci->db->get()->row()->is_attend;
        
    }

}

//TO BY PASS EXAM ATTENDANCES USE THIS FUNCTION
if (!function_exists('get_exam_attendances')) {
 function get_exam_attendances($school_id, $student_id, $academic_year_id, $exam_id, $class_id, $section_id, $subject_id) {
        $ci = & get_instance();
        $ci->db->select('S.status');
		 $ci->db->from('students AS S');
        $ci->db->join('subjects AS ES', 'ES.school_id = S.school_id', 'left');
		 $ci->db->join('exams AS EX', 'EX.school_id = S.school_id', 'left');
		$ci->db->where('ES.school_id', $school_id);
        //$ci->db->where('ES.academic_year_id', $academic_year_id);
        $ci->db->where('EX.id', $exam_id);
        $ci->db->where('ES.class_id', $class_id);
        $ci->db->where('ES.id', $subject_id);
        return @$ci->db->get()->row()->status;
        
    }

}

if (!function_exists('get_exam_mark')) {

    function get_exam_mark($school_id, $student_id, $academic_year_id, $exam_id, $class_id, $section_id, $subject_id) {
        $ci = & get_instance();
        $ci->db->select('M.*');
        $ci->db->from('marks AS M');
        $ci->db->where('M.academic_year_id', $academic_year_id);
        $ci->db->where('M.school_id', $school_id);
        $ci->db->where('M.exam_id', $exam_id);
        $ci->db->where('M.class_id', $class_id);
        if($section_id){
            $ci->db->where('M.section_id', $section_id);
        }
        $ci->db->where('M.student_id', $student_id);
        $ci->db->where('M.subject_id', $subject_id);
        return $ci->db->get()->row();
    }

}



if (!function_exists('get_exam_total_mark')) {

    function get_exam_total_mark($school_id, $exam_id, $student_id, $academic_year_id, $class_id, $section_id = null) {
        
        $ci = & get_instance();
        $ci->db->select('COUNT(M.id) AS total_subject, SUM(G.point) AS total_point, SUM(M.exam_total_mark) AS exam_mark, SUM(M.mid_term_total_mark) AS mid_term_mark, SUM(M.mid_term_total_obtain) AS mid_term_obtain, SUM(M.obtain_total_mark) AS obtain_mark');
        $ci->db->from('marks AS M');
        $ci->db->join('grades AS G', 'G.id = M.grade_id', 'left');      
        $ci->db->where('M.school_id', $school_id);
        $ci->db->where('M.class_id', $class_id);
        $ci->db->where('M.exam_id', $exam_id);
		 $ci->db->where('M.exam_id', $exam_id);
		 $ci->db->where_not_in('M.obtain_total_mark', '0');
        if ($section_id) {
            $ci->db->where('M.section_id', $section_id);
        }
        
        //Added by D-Ultimate
        $ci->db->where('M.rel_subject_id', 0);
        
        $ci->db->where('M.student_id', $student_id);
        $ci->db->where('M.academic_year_id', $academic_year_id);
        return $ci->db->get()->row();
    }
}


if (!function_exists('get_exam_total_mark_subject')) {

    function get_exam_total_mark_subject($school_id, $student_id, $exam_id, $academic_year_id, $class_id, $section_id = null) {
        
        $ci = & get_instance();
        $ci->db->select('COUNT(M.id) AS total_subject, SUM(G.point) AS total_point, SUM(M.exam_total_mark) AS exam_mark_subject, SUM(M.mid_term_total_mark) AS mid_term_mark, SUM(M.mid_term_total_obtain) AS mid_term_obtain, SUM(M.obtain_total_mark) AS obtain_mark_subject');
        $ci->db->from('marks AS M');
        $ci->db->join('grades AS G', 'G.id = M.grade_id', 'left');      
        $ci->db->where('M.school_id', $school_id);
        $ci->db->where('M.class_id', $class_id);
        //$ci->db->where('M.exam_id', $exam_id);
		$ci->db->where('M.exam_id', $exam_id);
		 //$ci->db->where('M.subject_id', $subject_id);
		 $ci->db->where_not_in('M.obtain_total_mark', '0');
        if ($section_id) {
            $ci->db->where('M.section_id', $section_id);
        }
        
        //Added by D-Ultimate
        $ci->db->where('M.rel_subject_id', 0);
        
        $ci->db->where('M.student_id', $student_id);
        $ci->db->where('M.academic_year_id', $academic_year_id);
        return $ci->db->get()->row();
    }
}










if (!function_exists('get_exam_result')) {

    function get_exam_result($school_id, $exam_id, $student_id, $academic_year_id, $class_id, $section_id = null) {
        $ci = & get_instance();
        $ci->db->select('ER.*, G.name');
        $ci->db->from('exam_results AS ER');  
        $ci->db->join('grades AS G', 'G.id = ER.grade_id', 'left');  
		 $ci->db->join('exams AS EX', 'EX.id = ER.exam_id', 'left');  
        $ci->db->where('ER.school_id', $school_id);
        $ci->db->where('ER.exam_id', $exam_id);
        $ci->db->where('ER.class_id', $class_id);
        
        if ($section_id) {
            $ci->db->where('ER.section_id', $section_id);
        }
		//$ci->db->where_not_in('EX.exam_result_status', 'unpublish');
        $ci->db->where('EX.exam_result_status', 'publish'); 
        $ci->db->where('ER.student_id', $student_id);
        $ci->db->where('ER.academic_year_id', $academic_year_id);
        return $ci->db->get()->row();
    }
}


if (!function_exists('get_exam_final_result22')) {

    function get_exam_final_result22($school_id, $student_id, $academic_year_id, $class_id, $section_id = null) {
        $ci = & get_instance();
        $ci->db->select('FR.*');
        $ci->db->from('final_results AS FR');
        $ci->db->where('FR.class_id', $class_id);
        if ($section_id) {
            $ci->db->where('FR.section_id', $section_id);
        }
        $ci->db->where('FR.school_id', $school_id);
        $ci->db->where('FR.student_id', $student_id);
        $ci->db->where('FR.academic_year_id', $academic_year_id);
        return $ci->db->get()->row();
    }
}

if (!function_exists('get_exam_final_result')) {

    function get_exam_final_result($school_id, $student_id, $academic_year_id, $class_id, $section_id = null) {
        $ci = & get_instance();

        // Step 1: Get all results for the class/section ordered by total marks
        $ci->db->select('FR.*');
        $ci->db->from('final_results AS FR');
        $ci->db->where('FR.class_id', $class_id);
        if ($section_id) {
            $ci->db->where('FR.section_id', $section_id);
        }
        $ci->db->where('FR.school_id', $school_id);
        $ci->db->where('FR.academic_year_id', $academic_year_id);
        $ci->db->order_by('FR.total_obtain_mark', 'DESC');
        $all_results = $ci->db->get()->result();

        // Step 2: Assign ranks with tie handling
        $position = null;
        $rank = 0;           // current rank
        $counter = 0;        // number of students processed
        $last_score = null;  // last score seen

        foreach ($all_results as $result) {
            $counter++;

            // Only increase rank when score changes
            if ($last_score === null || $result->total_obtain_mark < $last_score) {
                $rank = $counter;
                $last_score = $result->total_obtain_mark;
            }

            // If this is the target student, save position
            if ($result->student_id == $student_id) {
                $position = $rank;
                $student_result = $result;
                $student_result->position = $position;
                return $student_result;
            }
        }

        return null; // student not found
    }
}

if (!function_exists('get_exam_term_result')) {
    function get_exam_term_result($school_id, $student_id, $academic_year_id, $exam_id, $class_id, $section_id = null) {
        $ci = & get_instance();
        $ci->db->select('ER.*');
        $ci->db->from('exam_results AS ER');
        $ci->db->where('ER.class_id', $class_id);
        if ($section_id) {
            $ci->db->where('ER.section_id', $section_id);
        }
        $ci->db->where('ER.school_id', $school_id);
        $ci->db->where('ER.student_id', $student_id);
        $ci->db->where('ER.exam_id', $exam_id);
        $ci->db->where('ER.academic_year_id', $academic_year_id);
        $result = $ci->db->get()->row();
        return $result ? $result : (object)array();
    }
}




function get_exam_day_present22($exam_id) {
    $ci =& get_instance();
    $ci->load->database();
    $ci->db->select('day_present');
    $ci->db->where('exam_id', $exam_id);
    $query = $ci->db->get('exam_results');
    $result = $query->row_array();
    return $result['day_present'];
}


function get_exam_details($exam_id) {
    $CI =& get_instance();
    $CI->load->database();

    $CI->db->select('next_term_date, mid_term_date, days_in_term, student_average, total_obtain_mark');
    $CI->db->from('exams');
	$CI->db->join('exam_results AS ER', 'ER.exam_id = exams.id', 'left');
    $CI->db->where('exams.id', $exam_id);

    $query = $CI->db->get();
    $result = $query->row_array();

    return $result;
}



function get_exam_day_present($exam_id) {
    $CI =& get_instance();
    $CI->load->database();

    $CI->db->select('day_present, form_teacher_remark');
    $CI->db->from('exam_results AS ER');
	$CI->db->join('exams AS E', 'E.id = ER.exam_id', 'left');  
    $CI->db->where('exam_id', $exam_id);

    $query = $CI->db->get();
    $result = $query->row_array();

    return $result;
}



//CALCULATING POSITION IN CLASS PER TERM
if (!function_exists('get_student_position_broadsheet')) {

    function get_student_position_broadsheet($school_id, $academic_year_id, $exam_id, $class_id, $student_id, $section_id = null) {
        
        $cond = "";
        $condition = " academic_year_id = $academic_year_id ";
        $condition .= " AND school_id = $school_id";
        $condition .= " AND class_id = $class_id"; 
		$condition .= " AND exam_id = $exam_id";        
        if($section_id){
           $condition .= " AND section_id = $section_id";
        }
        
        $cond = $condition;
        $condition .= " AND student_id = $student_id";
        
       
        
        $ci = & get_instance();              
        $sql = "SELECT id, student_average, FIND_IN_SET( (student_average), 
                ( SELECT GROUP_CONCAT( (student_average) ORDER BY student_average DESC )
                FROM exam_results WHERE $cond  )) AS position 
                FROM exam_results 
                WHERE $condition";
        
        $result =  $ci->db->query($sql)->row(); 
      
        $position = '';
        if(!empty($result)){
            $position = $result->position;
        }
                       
        if($position == 1){
            return $position.'st';
        }
        
        elseif($position == 21){
           return $position.'st'; 
        }
        
         elseif($position == 31){
           return $position.'st'; 
        }
        
         elseif($position == 41){
           return $position.'st'; 
        }
         elseif($position == 51){
           return $position.'st'; 
        }
         elseif($position == 61){
           return $position.'st'; 
        }
         elseif($position == 71){
           return $position.'st'; 
        }
         elseif($position == 91){
           return $position.'st'; 
        }
         elseif($position == 2){
           return $position.'nd'; 
        }
        
        elseif($position == 22){
           return $position.'nd'; 
        }
         elseif($position == 32){
           return $position.'nd'; 
        }
         elseif($position == 42){
           return $position.'nd'; 
        }
         elseif($position == 52){
           return $position.'nd'; 
        }
         elseif($position == 62){
           return $position.'nd'; 
        }
         elseif($position == 72){
           return $position.'nd'; 
        }
         elseif($position == 82){
           return $position.'nd'; 
        }
         elseif($position == 92){
           return $position.'nd'; 
        }
         elseif($position == 3){
           return $position.'rd'; 
        }
        
        elseif($position == 23){
           return $position.'rd'; 
        }
         elseif($position == 33){
            return $position.'rd'; 
        }
         elseif($position == 43){
           return $position.'rd'; 
        }
         elseif($position == 53){
           return $position.'rd'; 
        }
         elseif($position == 63){
           return $position.'rd'; 
        }
         elseif($position == 73){
           return $position.'rd'; 
        }
         elseif($position == 83){
           return $position.'rd'; 
        }
         elseif($position == 93){
           return $position.'rd'; 
        }elseif($position > 3 ){
            return $position.'th';         
        }else{
            return '--'; 
        }
    }

}




if (!function_exists('get_student_position')) {

    function get_student_position($school_id, $academic_year_id, $class_id, $student_id, $section_id = null) {
        
        $cond = "";
        $condition = " academic_year_id = $academic_year_id ";
        $condition .= " AND school_id = $school_id";
        $condition .= " AND class_id = $class_id";        
        if($section_id){
           $condition .= " AND section_id = $section_id";
        }
        
        $cond = $condition;
        $condition .= " AND student_id = $student_id";
        
       
        
        $ci = & get_instance();              
        $sql = "SELECT id, total_obtain_mark, FIND_IN_SET( (total_obtain_mark), 
                ( SELECT GROUP_CONCAT( (total_obtain_mark) ORDER BY total_obtain_mark DESC )
                FROM final_results WHERE $cond  )) AS position 
                FROM final_results 
                WHERE $condition";
        
        $result =  $ci->db->query($sql)->row(); 
      
        $position = '';
        if(!empty($result)){
            $position = $result->position;
        }
                       
        if($position == 1){
            return $position.'st';
        }
        
        elseif($position == 21){
           return $position.'st'; 
        }
        
         elseif($position == 31){
           return $position.'st'; 
        }
        
         elseif($position == 41){
           return $position.'st'; 
        }
         elseif($position == 51){
           return $position.'st'; 
        }
         elseif($position == 61){
           return $position.'st'; 
        }
         elseif($position == 71){
           return $position.'st'; 
        }
         elseif($position == 91){
           return $position.'st'; 
        }
         elseif($position == 2){
           return $position.'nd'; 
        }
        
        elseif($position == 22){
           return $position.'nd'; 
        }
         elseif($position == 32){
           return $position.'nd'; 
        }
         elseif($position == 42){
           return $position.'nd'; 
        }
         elseif($position == 52){
           return $position.'nd'; 
        }
         elseif($position == 62){
           return $position.'nd'; 
        }
         elseif($position == 72){
           return $position.'nd'; 
        }
         elseif($position == 82){
           return $position.'nd'; 
        }
         elseif($position == 92){
           return $position.'nd'; 
        }
         elseif($position == 3){
           return $position.'rd'; 
        }
        
        elseif($position == 23){
           return $position.'rd'; 
        }
         elseif($position == 33){
            return $position.'rd'; 
        }
         elseif($position == 43){
           return $position.'rd'; 
        }
         elseif($position == 53){
           return $position.'rd'; 
        }
         elseif($position == 63){
           return $position.'rd'; 
        }
         elseif($position == 73){
           return $position.'rd'; 
        }
         elseif($position == 83){
           return $position.'rd'; 
        }
         elseif($position == 93){
           return $position.'rd'; 
        }elseif($position > 3 ){
            return $position.'th';         
        }else{
            return '--'; 
        }
    }

}



if (!function_exists('get_lowet_height_mark')) {

    function get_lowet_height_mark($school_id, $exam_id, $class_id, $section_id, $subject_id) {
        $ci = & get_instance();
        $ci->db->select('MIN(M.obtain_total_mark) AS lowest, MAX(M.obtain_total_mark) AS height');
		 $ci->db->select('MIN(M.mid_term_total_obtain) AS mid_lowest, MAX(M.mid_term_total_obtain) AS mid_height');
		 $ci->db->select('SUM(M.obtain_total_mark) AS average');
		 $ci->db->select('SUM(M.mid_term_total_obtain) AS mid_average');
        $ci->db->from('marks AS M');       
        $ci->db->where('M.school_id', $school_id);
       // $ci->db->where('M.academic_year_id', $academic_year_id);
        $ci->db->where('M.exam_id', $exam_id);
        $ci->db->where('M.class_id', $class_id);
        $ci->db->where('M.section_id', $section_id);
        $ci->db->where('M.subject_id', $subject_id);  
        return  $ci->db->get()->row();
     // echo $ci->db->last_query();
    }
}






if (!function_exists('get_lowet_height_mark_midterm')) {

    function get_lowet_height_mark_midterm($school_id, $exam_id, $class_id, $section_id, $subject_id) {
        $ci = & get_instance();
       $ci->db->select('MIN((M.written_obtain+M.tutorial_obtain+M.practical_obtain)) AS mid_lowest, MAX((M.written_obtain+M.tutorial_obtain+M.practical_obtain)) AS mid_height');
		$ci->db->select('SUM((M.written_obtain+M.tutorial_obtain+M.practical_obtain)) AS mid_average');
        $ci->db->from('marks AS M');       
        $ci->db->where('M.school_id', $school_id);
       // $ci->db->where('M.academic_year_id', $academic_year_id);
        $ci->db->where('M.exam_id', $exam_id);
        $ci->db->where('M.class_id', $class_id);
        $ci->db->where('M.section_id', $section_id);
        $ci->db->where('M.subject_id', $subject_id);  
        return  $ci->db->get()->row();
     // echo $ci->db->last_query();
    }
}










if (!function_exists('get_position_in_subject')) {

    function get_position_in_subject($school_id, $exam_id, $class_id, $section_id, $subject_id, $mark) {
        
        
        $ci = & get_instance();
        $sec = "";
        if($section_id){
           $sec = " AND section_id = $section_id"; 
        }
        
        $sql = "SELECT id, obtain_total_mark, FIND_IN_SET( obtain_total_mark,(
                SELECT GROUP_CONCAT( obtain_total_mark  ORDER BY obtain_total_mark DESC ) 
                FROM marks WHERE  
                school_id = $school_id
               
                AND exam_id = $exam_id
                AND class_id = $class_id
                $sec
                AND subject_id = $subject_id))
                AS subjectposition 
                FROM marks
                WHERE school_id = $school_id
                 
                   AND exam_id = $exam_id
                   AND class_id = $class_id 
                   $sec 
                   AND subject_id = $subject_id 
                   AND  obtain_total_mark = $mark"; 
        
       @$subjectposition =  $ci->db->query($sql)->row()->subjectposition; 
        
        if($mark == 0){
            return '--'; 
        }
        
         if($subjectposition == 1){
            return $subjectposition.'st';
        }
        
        elseif($subjectposition == 21){
           return $subjectposition.'st'; 
        }
        
         elseif($subjectposition == 31){
           return $subjectposition.'st'; 
        }
        
         elseif($subjectposition == 41){
           return $subjectposition.'st'; 
        }
         elseif($subjectposition == 51){
           return $subjectposition.'st'; 
        }
         elseif($subjectposition == 61){
           return $subjectposition.'st'; 
        }
         elseif($subjectposition == 71){
           return $subjectposition.'st'; 
        }
         elseif($subjectposition == 91){
           return $subjectposition.'st'; 
        }
         elseif($subjectposition == 2){
           return $subjectposition.'nd'; 
        }
        elseif($subjectposition == 22){
           return $subjectposition.'nd'; 
        }
         elseif($subjectposition == 32){
           return $subjectposition.'nd'; 
        }
         elseif($subjectposition == 42){
           return $subjectposition.'nd'; 
        }
         elseif($subjectposition == 52){
           return $subjectposition.'nd'; 
        }
         elseif($subjectposition == 62){
           return $subjectposition.'nd'; 
        }
         elseif($subjectposition == 72){
           return $subjectposition.'nd'; 
        }
         elseif($subjectposition == 82){
           return $subjectposition.'nd'; 
        }
         elseif($subjectposition == 92){
           return $subjectposition.'nd'; 
        }
         elseif($subjectposition == 3){
           return $subjectposition.'rd'; 
        }
        
        elseif($subjectposition == 23){
           return $subjectposition.'rd'; 
        }
         elseif($subjectposition == 33){
            return $subjectposition.'rd'; 
        }
         elseif($subjectposition == 43){
           return $subjectposition.'rd'; 
        }
         elseif($subjectposition == 53){
           return $subjectposition.'rd'; 
        }
         elseif($subjectposition == 63){
           return $subjectposition.'rd'; 
        }
         elseif($subjectposition == 73){
           return $subjectposition.'rd'; 
        }
         elseif($subjectposition == 83){
           return $subjectposition.'rd'; 
        }
         elseif($subjectposition == 93){
           return $subjectposition.'rd'; 
        }elseif($subjectposition > 3 ){
            return $subjectposition.'th';         
        }else{
            return '--'; 
        }
    }

}



if (!function_exists('get_position_in_subject_class')) {

    function get_position_in_subject_class($school_id, $class_id, $subject_id, $mark) {
        
        
        $ci = & get_instance();
        $sec = "";
        if($class_id){
           $sec = " AND class_id = $class_id"; 
        }
        
        $sql = "SELECT id, obtain_total_mark, FIND_IN_SET( obtain_total_mark,(
                SELECT GROUP_CONCAT( obtain_total_mark  ORDER BY obtain_total_mark DESC ) 
                FROM marks WHERE  
                school_id = $school_id
               
                AND exam_id = $exam_id
                AND class_id = $class_id
                $sec
                AND subject_id = $subject_id))
                AS subjectposition 
                FROM marks
                WHERE school_id = $school_id
                  
                   AND exam_id = $exam_id
                   AND class_id = $class_id 
                   $sec 
                   AND subject_id = $subject_id 
                   AND  obtain_total_mark = $mark"; 
        
        $subjectposition =  $ci->db->query($sql)->row()->subjectposition; 
        
        if($mark == 0){
            return '--'; 
        }
        
         if($subjectposition == 1){
            return $subjectposition.'st';
        }
        
        elseif($subjectposition == 21){
           return $subjectposition.'st'; 
        }
        
         elseif($subjectposition == 31){
           return $subjectposition.'st'; 
        }
        
         elseif($subjectposition == 41){
           return $subjectposition.'st'; 
        }
         elseif($subjectposition == 51){
           return $subjectposition.'st'; 
        }
         elseif($subjectposition == 61){
           return $subjectposition.'st'; 
        }
         elseif($subjectposition == 71){
           return $subjectposition.'st'; 
        }
         elseif($subjectposition == 91){
           return $subjectposition.'st'; 
        }
         elseif($subjectposition == 2){
           return $subjectposition.'nd'; 
        }
        elseif($subjectposition == 22){
           return $subjectposition.'nd'; 
        }
         elseif($subjectposition == 32){
           return $subjectposition.'nd'; 
        }
         elseif($subjectposition == 42){
           return $subjectposition.'nd'; 
        }
         elseif($subjectposition == 52){
           return $subjectposition.'nd'; 
        }
         elseif($subjectposition == 62){
           return $subjectposition.'nd'; 
        }
         elseif($subjectposition == 72){
           return $subjectposition.'nd'; 
        }
         elseif($subjectposition == 82){
           return $subjectposition.'nd'; 
        }
         elseif($subjectposition == 92){
           return $subjectposition.'nd'; 
        }
         elseif($subjectposition == 3){
           return $subjectposition.'rd'; 
        }
        
        elseif($subjectposition == 23){
           return $subjectposition.'rd'; 
        }
         elseif($subjectposition == 33){
            return $subjectposition.'rd'; 
        }
         elseif($subjectposition == 43){
           return $subjectposition.'rd'; 
        }
         elseif($subjectposition == 53){
           return $subjectposition.'rd'; 
        }
         elseif($subjectposition == 63){
           return $subjectposition.'rd'; 
        }
         elseif($subjectposition == 73){
           return $subjectposition.'rd'; 
        }
         elseif($subjectposition == 83){
           return $subjectposition.'rd'; 
        }
         elseif($subjectposition == 93){
           return $subjectposition.'rd'; 
        }elseif($subjectposition > 3 ){
            return $subjectposition.'th';         
        }else{
            return '--'; 
        }
    }

}













if (!function_exists('get_subject_list')) {

    function get_subject_list($school_id, $academic_year_id, $exam_id, $class_id, $section_id = null, $student_id = null) {
        $ci = & get_instance();
        $ci->db->select('M.*, S.has_subs, S.name AS subject, G.point, G.name' );
        $ci->db->from('marks AS M');
        $ci->db->join('subjects AS S', 'S.id = M.subject_id', 'left');
        $ci->db->join('grades AS G', 'G.id = M.grade_id', 'left');
        $ci->db->where('M.school_id', $school_id);
        $ci->db->where('M.academic_year_id', $academic_year_id);
        $ci->db->where('M.class_id', $class_id);
        $ci->db->where('S.relation_id', '0');
		$ci->db->order_by("S.id", "ASC");
        if($section_id){
            $ci->db->where('M.section_id', $section_id);
        }
        $ci->db->where('M.student_id', $student_id);
        $ci->db->where('M.exam_id', $exam_id);
        $ci->db->where_not_in('M.obtain_total_mark', '0');
        return  $ci->db->get()->result();     
    }

}

if (!function_exists('get_subject_list_report')) {

    function get_subject_list_report($school_id, $academic_year_id, $exam_id, $class_id, $section_id = null, $student_id = null) {
        $ci = & get_instance();
        $ci->db->select('M.*, S.has_subs, S.id AS sidd, S.name AS subject, G.point, G.name');
        $ci->db->from('marks AS M');
        $ci->db->join('subjects AS S', 'S.id = M.subject_id', 'left');
        $ci->db->join('grades AS G', 'G.id = M.grade_id', 'left');
        $ci->db->where('M.school_id', $school_id);
        $ci->db->where('M.academic_year_id', $academic_year_id);
        $ci->db->where('M.class_id', $class_id);
        //$ci->db->where('S.relation_id', '0');
        if($section_id){
            $ci->db->where('M.section_id', $section_id);
        }
        $ci->db->where('M.student_id', $student_id);
        $ci->db->where('M.exam_id', $exam_id);
        $ci->db->where_not_in('M.obtain_total_mark', '0');
        return  $ci->db->get()->result();     
    }

}



if (!function_exists('get_subject_list_two')) {

    function get_subject_list_two($school_id, $academic_year_id, $exam_id, $class_id, $section_id = null, $student_id = null) {
        $ci = & get_instance();
        $ci->db->select('M.*, S.has_subs, S.id AS sidd, S.name AS subject, G.point, G.name');
        $ci->db->from('marks AS M');
        $ci->db->join('subjects AS S', 'S.id = M.subject_id', 'left');
        $ci->db->join('grades AS G', 'G.id = M.grade_id', 'left');
        $ci->db->where('M.school_id', $school_id);
        $ci->db->where('M.academic_year_id', $academic_year_id);
        $ci->db->where('M.class_id', $class_id);
        $ci->db->where('S.relation_id', '0');
        if($section_id){
            $ci->db->where('M.section_id', $section_id);
        }
        $ci->db->where('M.student_id', $student_id);
        $ci->db->where('M.exam_id', $exam_id);
        $ci->db->where_not_in('M.obtain_total_mark', '0');
        return  $ci->db->get()->result();     
    }

}



if (!function_exists('get_exam_wise_markt')) {

    function get_exam_wise_markt($school_id, $exam_id, $class_id, $section_id = null, $student_id = null) {
        $ci = & get_instance();
        
        $select = 'SUM(M.written_mark) AS written_mark,
                   SUM(M.written_obtain) AS written_obtain,
                   SUM(M.tutorial_mark) AS tutorial_mark,
                   SUM(M.tutorial_obtain) AS tutorial_obtain,
                    SUM(M.practical_mark) AS practical_mark,
                   SUM(M.practical_obtain) AS practical_obtain,
                  
                   
                   SUM(M.ex1_mark) AS ex1_mark,
                   SUM(M.ex1_obtain) AS ex1_obtain,
                    SUM(M.ex2_mark) AS ex2_mark,
                   SUM(M.ex2_obtain) AS ex2_obtain,
                    SUM(M.ex3_mark) AS ex3_mark,
                   SUM(M.ex3_obtain) AS ex3_obtain,
                   SUM(M.ca4_mark) AS ca4_mark,
                   SUM(M.ca4_obtain) AS ca4_obtain,
                  SUM(M.proj_mark) AS proj_mark,
                   SUM(M.proj_obtain) AS proj_obtain,
				   
				    SUM(M.tha_total_mark) AS tha_total_mark,
                   SUM(M.tha_total_obtain) AS tha_total_obtain,
				   
				    SUM(M.ca_total_mark) AS ca_total_mark,
                   SUM(M.ca_total_obtain) AS ca_total_obtain,
				   
				    SUM(M.ce_total_mark) AS ce_total_mark,
                   SUM(M.ce_total_obtain) AS ce_total_obtain,
				   
				    SUM(M.affective_jss_mark) AS affective_jss_mark,
                   SUM(M.affective_jss_obtain) AS affective_jss_obtain,
                   
				   SUM(M.psychomotor_jss_mark) AS psychomotor_jss_mark,
                   SUM(M.psychomotor_jss_obtain) AS psychomotor_jss_obtain,
				   
                   
                   
                   SUM(M.viva_mark) AS viva_mark,
                   SUM(M.viva_obtain) AS viva_obtain,
				    SUM(M.mid_term_total_mark) AS mid_term_total_mark,
                   SUM(M.mid_term_total_obtain) AS mid_term_total_obtain,
				   SUM(M.exam_total_mark) AS exam_total_mark,
                   SUM(M.obtain_total_mark) AS obtain_total_mark,
				   
				   SUM(ETE.total_obtain_mark) AS cbt_obtain,
                  
				   
                   COUNT(M.id) AS total_subject,
                   SUM(G.point) AS point               
                   ';
        
        $ci->db->select($select);
        $ci->db->from('marks AS M');        
        $ci->db->join('grades AS G', 'G.id = M.grade_id', 'left'); 
		$ci->db->join(' exam_taken_exams AS ETE', 'ETE.subject_id = M.subject_id', 'left'); 

	    $ci->db->where('M.school_id', $school_id);
       
        $ci->db->where('M.class_id', $class_id);
		$ci->db->where_not_in('M.obtain_total_mark', '0');
		
		
        //Added by D-Ultimate
        $ci->db->where('M.rel_subject_id', 0);
        if($section_id){
            $ci->db->where('M.section_id', $section_id);
        }
        $ci->db->where('M.student_id', $student_id);
        $ci->db->where('M.exam_id', $exam_id);  
		
				
        return $ci->db->get()->row();  
        // $ci->db->last_query();
    }
}


if (!function_exists('get_position_in_exam')) {
    

    function get_position_in_exam($school_id, $academic_year_id, $exam_id, $class_id, $section_id = null, $total_obtain_mark = null) {
                
        $ci = & get_instance();
        
        $sec = "";
        if($section_id){
           $sec = " AND section_id = $section_id"; 
        }
        
        $sql = "SELECT id, total_obtain_mark, FIND_IN_SET(total_obtain_mark,(
                SELECT GROUP_CONCAT( total_obtain_mark  ORDER BY total_obtain_mark DESC ) 
                FROM exam_results WHERE 
                school_id = $school_id 
                AND academic_year_id = $academic_year_id 
                AND exam_id = $exam_id 
                AND class_id = $class_id 
                $sec ))
                AS position 
                FROM exam_results
                WHERE school_id = $school_id 
                AND academic_year_id = $academic_year_id
                AND exam_id = $exam_id 
                AND class_id = $class_id 
                $sec 
                AND total_obtain_mark = $total_obtain_mark"; 
        
        $position =  @$ci->db->query($sql)->row()->position; 
        
        if($total_obtain_mark== 0){
            return '--'; 
        }
        
         if($position == 1){
            return $position.'st';
        }
        
        elseif($position == 21){
           return $position.'st'; 
        }
        
         elseif($position == 31){
           return $position.'st'; 
        }
        
         elseif($position == 41){
           return $position.'st'; 
        }
         elseif($position == 51){
           return $position.'st'; 
        }
         elseif($position == 61){
           return $position.'st'; 
        }
         elseif($position == 71){
           return $position.'st'; 
        }
         elseif($position == 91){
           return $position.'st'; 
        }
         elseif($position == 2){
           return $position.'nd'; 
        }
        elseif($position == 22){
           return $position.'nd'; 
        }
         elseif($position == 32){
           return $position.'nd'; 
        }
         elseif($position == 42){
           return $position.'nd'; 
        }
         elseif($position == 52){
           return $position.'nd'; 
        }
         elseif($position == 62){
           return $position.'nd'; 
        }
         elseif($position == 72){
           return $position.'nd'; 
        }
         elseif($position == 82){
           return $position.'nd'; 
        }
         elseif($position == 92){
           return $position.'nd'; 
        }
         elseif($position == 3){
           return $position.'rd'; 
        }
        
        elseif($position == 23){
           return $position.'rd'; 
        }
         elseif($position == 33){
            return $position.'rd'; 
        }
         elseif($position == 43){
           return $position.'rd'; 
        }
         elseif($position == 53){
           return $position.'rd'; 
        }
         elseif($position == 63){
           return $position.'rd'; 
        }
         elseif($position == 73){
           return $position.'rd'; 
        }
         elseif($position == 83){
           return $position.'rd'; 
        }
         elseif($position == 93){
           return $position.'rd'; 
        }elseif($position > 3 ){
            return $position.'th';         
        }else{
            return '--'; 
        }
    }

}
// MODIFIED BY VEMATECH


if (!function_exists('get_average_exam_result_position')) {
    

    function get_average_exam_result_position($school_id, $academic_year_id, $exam_id, $class_id, $section_id = null, $student_average = null) {
                
        $ci = & get_instance();
        
        $sec = "";
        if($section_id){
           $sec = " AND section_id = $section_id"; 
        }
        
        $sql = "SELECT id, student_average, FIND_IN_SET(student_average,(
                SELECT GROUP_CONCAT(student_average  ORDER BY student_average DESC ) 
                FROM exam_results WHERE 
                school_id = $school_id 
                AND academic_year_id = $academic_year_id 
                AND exam_id = $exam_id 
                AND class_id = $class_id 
                $sec ))
                AS position 
                FROM exam_results
                WHERE school_id = $school_id 
                AND academic_year_id = $academic_year_id
                AND exam_id = $exam_id 
                AND class_id = $class_id 
                $sec 
                AND student_average = $student_average"; 
        
        $position =  @$ci->db->query($sql)->row()->position; 
        
        if($student_average== 0){
            return '--'; 
        }
        
         if($position == 1){
            return $position.'st';
        }
        
        elseif($position == 21){
           return $position.'st'; 
        }
        
         elseif($position == 31){
           return $position.'st'; 
        }
        
         elseif($position == 41){
           return $position.'st'; 
        }
         elseif($position == 51){
           return $position.'st'; 
        }
         elseif($position == 61){
           return $position.'st'; 
        }
         elseif($position == 71){
           return $position.'st'; 
        }
         elseif($position == 91){
           return $position.'st'; 
        }
         elseif($position == 2){
           return $position.'nd'; 
        }
        elseif($position == 22){
           return $position.'nd'; 
        }
         elseif($position == 32){
           return $position.'nd'; 
        }
         elseif($position == 42){
           return $position.'nd'; 
        }
         elseif($position == 52){
           return $position.'nd'; 
        }
         elseif($position == 62){
           return $position.'nd'; 
        }
         elseif($position == 72){
           return $position.'nd'; 
        }
         elseif($position == 82){
           return $position.'nd'; 
        }
         elseif($position == 92){
           return $position.'nd'; 
        }
         elseif($position == 3){
           return $position.'rd'; 
        }
        
        elseif($position == 23){
           return $position.'rd'; 
        }
         elseif($position == 33){
            return $position.'rd'; 
        }
         elseif($position == 43){
           return $position.'rd'; 
        }
         elseif($position == 53){
           return $position.'rd'; 
        }
         elseif($position == 63){
           return $position.'rd'; 
        }
         elseif($position == 73){
           return $position.'rd'; 
        }
         elseif($position == 83){
           return $position.'rd'; 
        }
         elseif($position == 93){
           return $position.'rd'; 
        }elseif($position > 3 ){
            return $position.'th';         
        }else{
            return '--'; 
        }
    }

}

if (!function_exists('get_position_average_in_class')) {
    

    function get_position_average_in_class($school_id, $academic_year_id, $exam_id, $class_id = null, $student_average = null) {
                
        $ci = & get_instance();
        
        $sec = "";
        if($class_id){
           $sec = " AND class_id = $class_id"; 
        }
        
        $sql = "SELECT id, student_average, FIND_IN_SET(student_average,(
                SELECT GROUP_CONCAT(student_average  ORDER BY student_average DESC ) 
                FROM exam_results WHERE 
                school_id = $school_id 
                AND academic_year_id = $academic_year_id 
                AND exam_id = $exam_id 
                AND class_id = $class_id 
                $sec ))
                AS position 
                FROM exam_results
                WHERE school_id = $school_id 
                AND academic_year_id = $academic_year_id
                AND exam_id = $exam_id 
                AND class_id = $class_id 
                $sec 
                AND student_average = $student_average"; 
        
        $position =  @$ci->db->query($sql)->row()->position; 
        
        if($student_average== 0){
            return '--'; 
        }
        
         if($position == 1){
            return $position.'st';
        }
        
        elseif($position == 21){
           return $position.'st'; 
        }
        
         elseif($position == 31){
           return $position.'st'; 
        }
        
         elseif($position == 41){
           return $position.'st'; 
        }
         elseif($position == 51){
           return $position.'st'; 
        }
         elseif($position == 61){
           return $position.'st'; 
        }
         elseif($position == 71){
           return $position.'st'; 
        }
         elseif($position == 91){
           return $position.'st'; 
        }
         elseif($position == 2){
           return $position.'nd'; 
        }
        elseif($position == 22){
           return $position.'nd'; 
        }
         elseif($position == 32){
           return $position.'nd'; 
        }
         elseif($position == 42){
           return $position.'nd'; 
        }
         elseif($position == 52){
           return $position.'nd'; 
        }
         elseif($position == 62){
           return $position.'nd'; 
        }
         elseif($position == 72){
           return $position.'nd'; 
        }
         elseif($position == 82){
           return $position.'nd'; 
        }
         elseif($position == 92){
           return $position.'nd'; 
        }
         elseif($position == 3){
           return $position.'rd'; 
        }
        
        elseif($position == 23){
           return $position.'rd'; 
        }
         elseif($position == 33){
            return $position.'rd'; 
        }
         elseif($position == 43){
           return $position.'rd'; 
        }
         elseif($position == 53){
           return $position.'rd'; 
        }
         elseif($position == 63){
           return $position.'rd'; 
        }
         elseif($position == 73){
           return $position.'rd'; 
        }
         elseif($position == 83){
           return $position.'rd'; 
        }
         elseif($position == 93){
           return $position.'rd'; 
        }
       elseif($position > 3 ){
            return $position.'th';         
        }else{
            return '--'; 
        }
    }

}



if (!function_exists('get_student_ave_final_position')) {

    function get_student_ave_final_position($school_id, $academic_year_id, $class_id, $student_id, $section_id = null) {
        
        $cond = "";
        $condition = " academic_year_id = $academic_year_id ";
        $condition .= " AND school_id = $school_id";
        $condition .= " AND class_id = $class_id";        
        if($section_id){
           $condition .= " AND section_id = $section_id";
        }
        
        $cond = $condition;
        $condition .= " AND student_id = $student_id";
        
       
        
        $ci = & get_instance();              
        $sql = "SELECT id, total_obtain_mark/total_mark*100, FIND_IN_SET( (total_obtain_mark/total_mark*100), 
                ( SELECT GROUP_CONCAT( (total_obtain_mark/total_mark*100) ORDER BY total_obtain_mark/total_mark*100 DESC )
                FROM final_results WHERE $cond  )) AS position 
                FROM final_results 
                WHERE $condition";
        
        $result =  $ci->db->query($sql)->row(); 
      
        $position = '';
        if(!empty($result)){
            $position = $result->position;
        }
                       
         if($position == 1){
            return $position.'st';
        }
        
        elseif($position == 21){
           return $position.'st'; 
        }
        
         elseif($position == 31){
           return $position.'st'; 
        }
        
         elseif($position == 41){
           return $position.'st'; 
        }
         elseif($position == 51){
           return $position.'st'; 
        }
         elseif($position == 61){
           return $position.'st'; 
        }
         elseif($position == 71){
           return $position.'st'; 
        }
         elseif($position == 91){
           return $position.'st'; 
        }
         elseif($position == 2){
           return $position.'nd'; 
        }
        elseif($position == 22){
           return $position.'nd'; 
        }
         elseif($position == 32){
           return $position.'nd'; 
        }
         elseif($position == 42){
           return $position.'nd'; 
        }
         elseif($position == 52){
           return $position.'nd'; 
        }
         elseif($position == 62){
           return $position.'nd'; 
        }
         elseif($position == 72){
           return $position.'nd'; 
        }
         elseif($position == 82){
           return $position.'nd'; 
        }
         elseif($position == 92){
           return $position.'nd'; 
        }
         elseif($position == 3){
           return $position.'rd'; 
        }
        
        elseif($position == 23){
           return $position.'rd'; 
        }
         elseif($position == 33){
            return $position.'rd'; 
        }
         elseif($position == 43){
           return $position.'rd'; 
        }
         elseif($position == 53){
           return $position.'rd'; 
        }
         elseif($position == 63){
           return $position.'rd'; 
        }
         elseif($position == 73){
           return $position.'rd'; 
        }
         elseif($position == 83){
           return $position.'rd'; 
        }
         elseif($position == 93){
           return $position.'rd'; 
        }elseif($position > 3 ){
            return $position.'th';         
        }else{
            return '--'; 
        }
    }

}


//CALCULATING CLASS SECTION AVERAGE FROM MARKS TABLE
//ADDED BY AGBOLASE

if (!function_exists('get_student_section_average')) {

    function get_student_section_average($school_id, $exam_id, $class_id, $section_id = null, $student_id = null) {
        $ci = & get_instance();
      	$ci->db->select('SUM(M.obtain_total_mark) AS section_average');
		$ci->db->select('SUM(M.exam_total_mark) AS section_Maverage');
        $ci->db->from('marks AS M');       
        $ci->db->where('M.school_id', $school_id);
        $ci->db->where('M.exam_id', $exam_id);
        $ci->db->where('M.class_id', $class_id);
		$ci->db->where_not_in('M.obtain_total_mark', '0');
        if($section_id){
        $ci->db->where('M.section_id', $section_id);
        }
       $ci->db->where('M.rel_subject_id', 0);
        //$ci->db->where('academic_year_id', $academic_year_id);
        return $ci->db->get()->row();
        
    }

}



if (!function_exists('get_lowet_height_result')) {

    function get_lowet_height_result($school_id, $academic_year_id, $exam_id, $class_id, $section_id = null, $student_id = null) {
        $ci = & get_instance();
        $ci->db->select('MIN(ER.total_obtain_mark) AS lowest, MAX(ER.total_obtain_mark) AS height');
		$ci->db->select('SUM(ER.total_obtain_mark)/SUM(ER.total_obtain_mark)*100 AS average');
		//$ci->db->select('SUM(ER.total_obtain_mark) AS Section_average');
		$ci->db->select('SUM(ER.total_mark) AS Maverage');
        $ci->db->from('exam_results AS ER');       
        $ci->db->where('ER.school_id', $school_id);
        $ci->db->where('ER.academic_year_id', $academic_year_id);
        $ci->db->where('ER.exam_id', $exam_id);
        $ci->db->where('ER.class_id', $class_id);
        if($section_id){
           $ci->db->where('ER.section_id', $section_id);
        }
        
        return  $ci->db->get()->row();
    }

}



if (!function_exists('get_final_result')) {
    
    function get_final_result($school_id, $academic_year_id, $class_id, $section_id, $student_id){
        
        $ci = & get_instance();
        $ci->db->select('FR.*, G.name AS grade');
        $ci->db->from('final_results AS FR');        
        $ci->db->join('grades AS G', 'G.id = FR.grade_id', 'left');
        $ci->db->where('FR.academic_year_id', $academic_year_id);
        $ci->db->where('FR.school_id', $school_id);
        $ci->db->where('FR.class_id', $class_id);
        if($section_id){
          $ci->db->where('FR.section_id', $section_id);
        }
        $ci->db->where('FR.student_id', $student_id);
        return $ci->db->get()->row();       
    }
}

if (!function_exists('get_exam_term_result')) {
    
    function get_exam_term_result($school_id, $academic_year_id, $exam_id, $class_id, $section_id, $student_id){
        
        $ci = & get_instance();
        $ci->db->select('ER.*, G.name AS grade');
        $ci->db->from('exam_results AS FR');        
        $ci->db->join('grades AS G', 'G.id = ER.grade_id', 'left');
        $ci->db->where('ER.academic_year_id', $academic_year_id);
        $ci->db->where('ER.school_id', $school_id);
        $ci->db->where('ER.class_id', $class_id);
		$ci->db->where('ER.exam_id', $exam_id);
        if($section_id){
          $ci->db->where('ER.section_id', $section_id);
        }
        $ci->db->where('ER.student_id', $student_id);
        return $ci->db->get()->row();       
    }
}


if (!function_exists('get_position_in_class')) {

    function get_position_in_class($school_id, $academic_year_id, $class_id, $student_id) {
       
        
        $condition = " school_id = $school_id";
        $condition .= " AND academic_year_id = $academic_year_id";
        $condition .= " AND class_id = $class_id";
        $condition .= " AND student_id = $student_id";       
        
        $ci = & get_instance();              
        $sql = "SELECT id, avg_grade_point, FIND_IN_SET( (avg_grade_point+total_obtain_mark), 
                ( SELECT GROUP_CONCAT( (avg_grade_point+total_obtain_mark) ORDER BY avg_grade_point DESC )
                FROM final_results ) ) AS position 
                FROM final_results 
                WHERE $condition";
        
        $position =  @$ci->db->query($sql)->row()->position; 
         
          if($position == 1){
            return $position.'st';
        }
        
        elseif($position == 21){
           return $position.'st'; 
        }
        
         elseif($position == 31){
           return $position.'st'; 
        }
        
         elseif($position == 41){
           return $position.'st'; 
        }
         elseif($position == 51){
           return $position.'st'; 
        }
         elseif($position == 61){
           return $position.'st'; 
        }
         elseif($position == 71){
           return $position.'st'; 
        }
         elseif($position == 91){
           return $position.'st'; 
        }
         elseif($position == 2){
           return $position.'nd'; 
        }
        elseif($position == 22){
           return $position.'nd'; 
        }
         elseif($position == 32){
           return $position.'nd'; 
        }
         elseif($position == 42){
           return $position.'nd'; 
        }
         elseif($position == 52){
           return $position.'nd'; 
        }
         elseif($position == 62){
           return $position.'nd'; 
        }
         elseif($position == 72){
           return $position.'nd'; 
        }
         elseif($position == 82){
           return $position.'nd'; 
        }
         elseif($position == 92){
           return $position.'nd'; 
        }
         elseif($position == 3){
           return $position.'rd'; 
        }
        
        elseif($position == 23){
           return $position.'rd'; 
        }
         elseif($position == 33){
            return $position.'rd'; 
        }
         elseif($position == 43){
           return $position.'rd'; 
        }
         elseif($position == 53){
           return $position.'rd'; 
        }
         elseif($position == 63){
           return $position.'rd'; 
        }
         elseif($position == 73){
           return $position.'rd'; 
        }
         elseif($position == 83){
           return $position.'rd'; 
        }
         elseif($position == 93){
           return $position.'rd'; 
        }elseif($position > 3 ){
            return $position.'th';         
        }else{
            return '--'; 
        }
    }

}




if (!function_exists('get_enrollment')) {

    function get_enrollment($student_id, $academic_year_id, $school_id = null) {
        $ci = & get_instance();
        $ci->db->select('E.*');
        $ci->db->from('enrollments AS E');
        $ci->db->where('E.student_id', $student_id);
        $ci->db->where('E.academic_year_id', $academic_year_id);
        if($school_id){
            $ci->db->where('E.school_id', $school_id);
        }
        return $ci->db->get()->row();
    }

}


if (!function_exists('get_user_by_role')) {

    function get_user_by_role($role_id, $user_id, $academic_year_id = null) {

        $ci = & get_instance();

        if ($role_id == SUPER_ADMIN) {
            
            $ci->db->select('SA.*, U.username, U.role_id');
            $ci->db->from('system_admin AS SA');
            $ci->db->join('users AS U', 'U.id = SA.user_id', 'left');
            $ci->db->where('SA.user_id', $user_id);
            return $ci->db->get()->row();

        }elseif ($role_id == STUDENT) {

            $ci->db->select('S.*, ST.type, G.name AS guardian, E.roll_no, E.section_id, E.class_id, U.role_id, U.username, R.name AS role, C.name AS class_name, SE.name AS section, D.title AS discount, D.amount');
            $ci->db->from('enrollments AS E');
            $ci->db->join('students AS S', 'S.id = E.student_id', 'left');
            $ci->db->join('guardians AS G', 'G.id = S.guardian_id', 'left');
            $ci->db->join('users AS U', 'U.id = S.user_id', 'left');
            $ci->db->join('roles AS R', 'R.id = U.role_id', 'left');
            $ci->db->join('classes AS C', 'C.id = E.class_id', 'left');
            $ci->db->join('sections AS SE', 'SE.id = E.section_id', 'left');
            $ci->db->join('discounts AS D', 'D.id = S.discount_id', 'left');
            $ci->db->join('student_types AS ST', 'ST.id = S.type_id', 'left');
            if($academic_year_id){
                $ci->db->where('E.academic_year_id', $academic_year_id);
            }
            $ci->db->where('S.user_id', $user_id);
            
            return $ci->db->get()->row();
            
        } elseif ($role_id == TEACHER) {
            
            $ci->db->select('T.*, D.title AS department, U.role_id, U.username, R.name AS role, SG.grade_name');
            $ci->db->from('teachers AS T');
            $ci->db->join('users AS U', 'U.id = T.user_id', 'left');
            $ci->db->join('roles AS R', 'R.id = U.role_id', 'left');
            $ci->db->join('departments AS D', 'D.id = T.department_id', 'left');
            $ci->db->join('salary_grades AS SG', 'SG.id = T.salary_grade_id', 'left');
            $ci->db->where('T.user_id', $user_id);
            return $ci->db->get()->row();
            
        } elseif ($role_id == GUARDIAN) {
            
            $ci->db->select('G.*, U.role_id, U.username, R.name AS role');
            $ci->db->from('guardians AS G');
            $ci->db->join('users AS U', 'U.id = G.user_id', 'left');
            $ci->db->join('roles AS R', 'R.id = U.role_id', 'left');
            $ci->db->where('G.user_id', $user_id);
            return $ci->db->get()->row();
                
        } else {
            
            $ci->db->select('E.*, U.role_id, U.username, R.name AS role, D.name AS designation, SG.grade_name');
            $ci->db->from('employees AS E');
            $ci->db->join('users AS U', 'U.id = E.user_id', 'left');
             $ci->db->join('roles AS R', 'R.id = U.role_id', 'left');
            $ci->db->join('designations AS D', 'D.id = E.designation_id', 'left');
            $ci->db->join('salary_grades AS SG', 'SG.id = E.salary_grade_id', 'left');
            $ci->db->where('E.user_id', $user_id);
            return $ci->db->get()->row();
        }

        $ci->db->last_query();
    }

}


if (!function_exists('get_user_by_id')) {

    function get_user_by_id($user_id) {

        $ci = & get_instance();

        $ci->db->select('U.id, U.role_id');
        $ci->db->from('users AS U');
        $ci->db->where('U.id', $user_id);
        $user = $ci->db->get()->row();

        if ($user->role_id == SUPER_ADMIN) {
            
            $ci->db->select('SA.*, U.username, U.role_id');
            $ci->db->from('system_admin AS SA');
            $ci->db->join('users AS U', 'U.id = SA.user_id', 'left');
            $ci->db->where('SA.user_id', $user_id);
            return $ci->db->get()->row();
            
        }else if ($user->role_id == STUDENT) {

            $ci->db->select('S.*, E.roll_no, U.username, U.role_id,  C.name AS class_name, SE.name AS section');
            $ci->db->from('enrollments AS E');
            $ci->db->join('students AS S', 'S.id = E.student_id', 'left');
            $ci->db->join('users AS U', 'U.id = S.user_id', 'left');
            $ci->db->join('classes AS C', 'C.id = E.class_id', 'left');
            $ci->db->join('sections AS SE', 'SE.id = E.section_id', 'left');
            $ci->db->where('S.user_id', $user_id);            
            return $ci->db->get()->row();
            
        } elseif ($user->role_id == TEACHER) {
            
            $ci->db->select('T.*, U.username, U.role_id');
            $ci->db->from('teachers AS T');
            $ci->db->join('users AS U', 'U.id = T.user_id', 'left');
            $ci->db->where('T.user_id', $user_id);
            return $ci->db->get()->row();
            
        } elseif ($user->role_id == GUARDIAN) {
            
            $ci->db->select('G.*, U.username, U.role_id');
            $ci->db->from('guardians AS G');
            $ci->db->join('users AS U', 'U.id = G.user_id', 'left');
            $ci->db->where('G.user_id', $user_id);
            return $ci->db->get()->row();        
            
        } else {
            
            $ci->db->select('E.*, U.username, U.role_id, D.name AS designation');
            $ci->db->from('employees AS E');
            $ci->db->join('users AS U', 'U.id = E.user_id', 'left');
            $ci->db->join('designations AS D', 'D.id = E.designation_id', 'left');
            $ci->db->where('E.user_id', $user_id);
            return  $ci->db->get()->row();
        }

        // $ci->db->last_query();
    }

}


if (!function_exists('get_total_used_leave')) {

    function get_total_used_leave($academic_year_id, $role_id, $type_id, $user_id) {
        $ci = & get_instance();
        
        $ci->db->select('sum(A.leave_day) AS total');
        $ci->db->from('leave_applications AS A');
        $ci->db->where('A.role_id', $role_id);
        $ci->db->where('A.type_id', $type_id);
        $ci->db->where('A.user_id', $user_id);
        $ci->db->where('A.academic_year_id', $academic_year_id);
        $ci->db->where('A.leave_status', 2);
        $result = $ci->db->get()->row();
      
        if(!empty($result)){
            return $result->total;
        }else{
            return 0;
        }
    }
}


if (!function_exists('get_blood_group')) {

    function get_blood_group() {
        $ci = & get_instance();
        return array(
            'a_positive' => $ci->lang->line('a_positive'),
            'a_negative' => $ci->lang->line('a_negative'),
            'b_positive' => $ci->lang->line('b_positive'),
            'b_negative' => $ci->lang->line('b_negative'),
            'o_positive' => $ci->lang->line('o_positive'),
            'o_negative' => $ci->lang->line('o_negative'),
            'ab_positive' => $ci->lang->line('ab_positive'),
            'ab_negative' => $ci->lang->line('ab_negative')
        );
    }

}


if (!function_exists('get_club')) {

    function get_club() {
        $ci = & get_instance();
        return array(
		'Boy Scouts ' => $ci->lang->line('boy_scouts'),
		'Coding Club' => $ci->lang->line('coding'),
		'Computer Club' => $ci->lang->line('computer'),
		'Dramatic Debate CLub' => $ci->lang->line('dramatic_debate'),
		'Environmental Society Club' => $ci->lang->line('environmental_society'),
		'Forex Club' => $ci->lang->line('forex'),
		'Geography Club' => $ci->lang->line('geography'),
		'Girls Guide' => $ci->lang->line('girls_guide'),
		'Mathematics Club' => $ci->lang->line('mathematics'),
		'Music Club' => $ci->lang->line('music'),
		'Press Club' => $ci->lang->line('press'),
		'Robotic Club' => $ci->lang->line('robotics'),
		'Supporters Club' => $ci->lang->line('supporters'),
		'Vocational Club' => $ci->lang->line('vocational'),
		'Young Farmer Club' => $ci->lang->line('young_farmer')

	  );
    }

}





if (!function_exists('get_subject_type')) {

    function get_subject_type() {
        $ci = & get_instance();
        return array(
            'mandatory' => $ci->lang->line('mandatory'),
            'optional' => $ci->lang->line('optional')
        );
    }

}

if (!function_exists('get_groups')) {

    function get_groups() {
        $ci = & get_instance();
        return array(
            'science' => $ci->lang->line('science'),
            'arts' => $ci->lang->line('arts'),
            'commerce' => $ci->lang->line('commerce')
        );
    }

}


if (!function_exists('get_week_days')) {

    function get_week_days() {
        $ci = & get_instance();
        return array(           
            'monday' => $ci->lang->line('monday'),
            'tuesday' => $ci->lang->line('tuesday'),
            'wednesday' => $ci->lang->line('wednesday'),
            'thursday' => $ci->lang->line('thursday'),
            'friday' => $ci->lang->line('friday'),
             'saturday' => $ci->lang->line('saturday'),
            'sunday' => $ci->lang->line('sunday')
        );
    }

}

if (!function_exists('get_months')) {

    function get_months() {
        $ci = & get_instance();
        return array(
            'january' => $ci->lang->line('january'),
            'february' => $ci->lang->line('february'),
            'march' => $ci->lang->line('march'),
            'april' => $ci->lang->line('april'),
            'may' => $ci->lang->line('may'),
            'june' => $ci->lang->line('june'),
            'july' => $ci->lang->line('july'),
            'august' => $ci->lang->line('august'),
            'september' => $ci->lang->line('september'),
            'october' => $ci->lang->line('october'),
            'november' => $ci->lang->line('november'),
            'december' => $ci->lang->line('december')
        );
    }

}

if (!function_exists('get_terms')) {

    function get_terms() {
        $ci = & get_instance();
        return array(
            '1' => '1',
			'2' => '2',
			'3' => '3'
        );
    }

}





if (!function_exists('get_hostel_types')) {

    function get_hostel_types() {
        $ci = & get_instance();
        return array(
            'boys' => $ci->lang->line('boys'),
            'girls' => $ci->lang->line('girls'),
            'combine' => $ci->lang->line('combine')
        );
    }
}

if (!function_exists('get_page_location')) {

    function get_page_location() {
        $ci = & get_instance();
        return array(
            'header' => $ci->lang->line('header'),
            'footer' => $ci->lang->line('footer'),
        );
    }
}

if (!function_exists('get_room_types')) {

    function get_room_types() {
        $ci = & get_instance();
        return array(
            'ac' => $ci->lang->line('ac'),
            'non_ac' => $ci->lang->line('non_ac')
        );
    }

}


if (!function_exists('get_genders')) {

    function get_genders() {
        $ci = & get_instance();
        return array(
            'male' => $ci->lang->line('male'),
            'female' => $ci->lang->line('female')
        );
    }

}


if (!function_exists('get_terms')) {

    function get_terms() {
        $ci = & get_instance();
        return array(
            'term 1' => "Term 1",
            'term 2' => "Term 2",
			'term 3' => "Term 3"
        );
    }

}



if (!function_exists('get_paid_types')) {

    function get_paid_status($status) {
        $ci = & get_instance();
        $data = array(
            'paid' => $ci->lang->line('paid'),
            'unpaid' => $ci->lang->line('unpaid'),
            'partial' => $ci->lang->line('partial')
        );
        return $data[$status];
    }

}
/*
if (!function_exists('get_relation_types')) {

    function get_relation_types() {
        $ci = & get_instance();
        return array(
            'father' => $ci->lang->line('father'),
            'mother' => $ci->lang->line('mother'),
            'sister' => $ci->lang->line('sister'),
            'brother' => $ci->lang->line('brother'),
            'uncle' => $ci->lang->line('uncle'),
            'maternal_uncle' => $ci->lang->line('maternal_uncle'),
            'other_relative' => $ci->lang->line('other_relative')
        );
    }
}
*/


if (!function_exists('get_video_types')) {

    function get_video_types() {
        $ci = & get_instance();
        return array(
            'youtube' => $ci->lang->line('youtube'),
            'vimeo' => $ci->lang->line('vimeo'),
            'ppt' => $ci->lang->line('physical_lecture')
			//'physical' => $ci->lang->line('physical_lecture');
			
        );
    }
}


if (!function_exists('get_subscription_plans')) {

    function get_subscription_plans() {
        $ci = & get_instance();
        return array(
            'basic_plan' => $ci->lang->line('basic_plan'),
            'standard_plan' => $ci->lang->line('standard_plan'),
            'premium_plan' => $ci->lang->line('premium_plan')
        );
    }
}


if (!function_exists('get_work_status')) {

    function get_work_status($status = null) {
        $ci = & get_instance();
        $data = array(
            'start' => $ci->lang->line('start'),
            'progress' => $ci->lang->line('progress'),
            'completed' => $ci->lang->line('completed'),
            'pause' => $ci->lang->line('pause'),
            'cancel' => $ci->lang->line('cancel'),
            'closed' => $ci->lang->line('closed')
        );
        if($status){
            return $data[$status];
        }else{
            return $data;
        }
    }
}


if (!function_exists('get_payment_methods')) {

    function get_payment_methods($school_id = null) {
        $ci = & get_instance();

        $methods = array('cash' => $ci->lang->line('cash'), 'cheque' => $ci->lang->line('cheque'), 'receipt' => $ci->lang->line('bank_receipt'), 'wallet' => $ci->lang->line('wallet'));
          
        if($ci->session->userdata('role_id') != SUPER_ADMIN){
            $school_id =  $ci->session->userdata('school_id');
        }
        
        $ci->db->select('PS.*');
        $ci->db->from('payment_settings AS PS');  
        if($school_id){
            $ci->db->where('PS.school_id', $school_id);
        }
        
        $data = $ci->db->get()->row();
        if(!empty($data)){ 
            if ($data->paypal_status == 1) {
                $methods['paypal'] = $ci->lang->line('paypal');
            }
            if ($data->payumoney_status == 1) {
                $methods['payumoney'] = $ci->lang->line('payumoney');
            }
            if ($data->stripe_status == 1) {
                $methods['stripe'] = $ci->lang->line('stripe');
            }
            if ($data->cca_status == 1) {
                $methods['ccavenue'] = $ci->lang->line('ccavenue');
            }
            if ($data->paytm_status == 1) {
                $methods['paytm'] = $ci->lang->line('paytm');
            }            
            if ($data->stack_status == 1) {
                $methods['paystack'] = $ci->lang->line('pay_stack');
            }
            if ($data->dbbl_status == 1) {
                $methods['dbbl'] = $ci->lang->line('dbbl');
            }            
            if ($data->jaz_status == 1) {
                $methods['jazzcash'] = $ci->lang->line('jazz_cash');
            }
            if ($data->ssl_status == 1) {
                $methods['sslcommerz'] = $ci->lang->line('ssl_commerz');
            }
            if ($data->mid_status == 1) {
                $methods['midtrans'] = $ci->lang->line('mid_trans');
            }
            if ($data->mojo_status == 1) {
                $methods['instamojo'] = $ci->lang->line('insta_mojo');
            }
            if ($data->flut_status == 1) {
                $methods['flutterwave'] = $ci->lang->line('flutter_wave');
            }
            if ($data->ipay_status == 1) {
                $methods['ipay'] = $ci->lang->line('ipay');
            }
            
            if ($data->pesa_status == 1) {
                //$methods['pesapal'] = $ci->lang->line('pesapal');
            }
            if ($data->bill_status == 1) {
                //$methods['billplz'] = $ci->lang->line('bill_plz');
            }
        }

        return $methods;
    }

}

if (!function_exists('get_sms_gateways')) {

    function get_sms_gateways( $school_id ) {
        
        $ci = & get_instance();
        $gateways = array();
       
        $ci->db->select('SS.*');
        $ci->db->from('sms_settings AS SS');
        $ci->db->where('SS.school_id', $school_id);
        $data = $ci->db->get()->row();

        if(!empty($data)){
            
            if ($data->clickatell_status) {
                $gateways['clicktell'] = $ci->lang->line('clicktell');
            }
            if ($data->twilio_status) {
                $gateways['twilio'] = $ci->lang->line('twilio');
            }
            if ($data->bulk_status) {
                $gateways['bulk'] = $ci->lang->line('bulk');
            }
            if ($data->msg91_status) {
                $gateways['msg91'] = $ci->lang->line('msg91');
            }
            if ($data->plivo_status) {
                $gateways['plivo'] = $ci->lang->line('plivo');
            }
            if ($data->textlocal_status) {
                $gateways['text_local'] = $ci->lang->line('text_local');
            }
            if ($data->smscountry_status) {
                $gateways['sms_country'] = $ci->lang->line('sms_country');
            }
            if ($data->betasms_status) {
                $gateways['beta_sms'] = $ci->lang->line('beta_sms');
            }
            if ($data->bulk_pk_status) {
                $gateways['bulk_pk'] = $ci->lang->line('bulk_pk');
            }
            if ($data->cluster_status) {
                $gateways['sms_custer'] = $ci->lang->line('sms_custer');
            }
            if ($data->alpha_status) {
                $gateways['alpha_net'] = $ci->lang->line('alpha_net');
            }
            if ($data->bdbulk_status) {
                $gateways['bd_bulk'] = $ci->lang->line('bd_bulk');
            }
            if ($data->mim_status) {
                $gateways['mim_sms'] = $ci->lang->line('mim_sms');
            }
            if ($data->bulk360_status) {
                $gateways['bulk_360'] = $ci->lang->line('bulk_360');
            }
            if ($data->smsto_status) {
                $gateways['sms_to'] = $ci->lang->line('sms_to');
            }
         }
        return $gateways;
    }

}


if (!function_exists('get_group_by_type')) {

    function get_group_by_type() {
        $ci = & get_instance();
        return array(
            'daily' => $ci->lang->line('daily'),
            'monthly' => $ci->lang->line('monthly'),
            'yearly' => $ci->lang->line('yearly')
        );
    }

}


if (!function_exists('get_template_tags')) {

    function get_template_tags($role_id) {
        $tags = array();
        $tags[] = '[name]';
        $tags[] = '[email]';
        $tags[] = '[phone]';

        if($role_id == SUPER_ADMIN){
            
            $tags[] = '[designation]';
            $tags[] = '[gender]';
            $tags[] = '[blood_group]';
            $tags[] = '[religion]';
            $tags[] = '[dob]';            
        }elseif ($role_id == STUDENT) {

            $tags[] = '[class_name]';
            $tags[] = '[section]';
            $tags[] = '[roll_no]';
            $tags[] = '[dob]';
            $tags[] = '[gender]';
            $tags[] = '[religion]';
            $tags[] = '[blood_group]';
            $tags[] = '[registration_no]';
            $tags[] = '[group]';
            $tags[] = '[created_at]';
            $tags[] = '[guardian]';
            
        } else if ($role_id == GUARDIAN) {
            $tags[] = '[profession]';
        } else if ($role_id == TEACHER) {
            $tags[] = '[department]';
            $tags[] = '[gender]';
            $tags[] = '[blood_group]';
            $tags[] = '[religion]';
            $tags[] = '[dob]';
            $tags[] = '[joining_date]';
        } else {
            $tags[] = '[designation]';
            $tags[] = '[gender]';
            $tags[] = '[blood_group]';
            $tags[] = '[religion]';
            $tags[] = '[dob]';
            $tags[] = '[joining_date]';
        }

        $tags[] = '[present_address]';
        $tags[] = '[permanent_address]';

        return $tags;
    }

}

if (!function_exists('get_formatted_body')) {

    function get_formatted_body($body, $role_id, $user_id) {

         $ci = & get_instance();
        $tags = get_template_tags($role_id);
        $user = get_user_by_role($role_id, $user_id);
             
        $arr = array('[', ']');
        foreach ($tags as $tag) {
            $field = str_replace($arr, '', $tag);
            
            if($field == 'blood_group'){                
                 $body = str_replace($tag, $ci->lang->line($user->{$field}), $body);              
            }elseif($field == 'gender'){                
                 $body = str_replace($tag, $ci->lang->line($user->{$field}), $body);              
            }elseif($field == 'group'){                
                 $body = str_replace($tag, $ci->lang->line($user->{$field}), $body);              
            }elseif($field == 'created_at'){                
                $body = str_replace($tag, date('M-d-Y', strtotime($user->created_at)), $body);                
            }else{
                $body = str_replace($tag, $user->{$field}, $body);
            } 
        }
        return $body;
    }
}

if (!function_exists('get_formatted_certificate_text')) {

    function get_formatted_certificate_text($body, $role_id, $user_id) {

        $tags = get_template_tags($role_id);
        $user = get_user_by_role($role_id, $user_id);
              
        $arr = array('[', ']');
        foreach ($tags as $tag) {
            $field = str_replace($arr, '', $tag);
            
            if($field == 'created_at'){                
                $body = str_replace($tag, '<span>'.date('M-d-Y', strtotime($user->created_at)).'</span>', $body);                
            }else{
                $body = str_replace($tag, '<span>'.$user->{$field}.'</span>', $body);
            }            
        }

        return $body;
    }
}



if (!function_exists('get_nice_time')) {

    function get_nice_time($date) {

        $ci = & get_instance();
        if (empty($date)) {
            return "2 months ago"; //"No date provided";
        }

        $periods = array("second", "minute", "hour", "day", "week", "month", "year", "decade");
        $lengths = array("60", "60", "24", "7", "4.35", "12", "10");

        $now = time();
        $unix_date = strtotime($date);

        // check validity of date
        if (empty($unix_date)) {
            return "2 months ago"; // "Bad date";
        }

        // is it future date or past date
        if ($now > $unix_date) {
            $difference = $now - $unix_date;
            $tense = "ago";
        } else {
            $difference = $unix_date - $now;
            $tense = "from now";
        }

        for ($j = 0; $difference >= $lengths[$j] && $j < count($lengths) - 1; $j++) {
            $difference /= $lengths[$j];
        }

        $difference = round($difference);

        if ($difference != 1) {
            $periods[$j] .= "s";
        }

        return "$difference $periods[$j] {$tense}";
    }

}



if (!function_exists('get_inbox_message')) {

    function get_inbox_message() {
        $ci = & get_instance();
        $ci->db->select('MR.*, M.*');
        $ci->db->from('message_relationships AS MR');
        $ci->db->join('messages AS M', 'M.id = MR.message_id', 'left');
        $ci->db->where('MR.status', 1);
        $ci->db->where('MR.is_read', 0);
        $ci->db->where('MR.owner_id', logged_in_user_id());
        $ci->db->where('MR.receiver_id', logged_in_user_id());
        return $ci->db->get()->result();
    }
}

if (!function_exists('get_hostel_by_school')) {

    function get_hostel_by_school($school_id) {
        $ci = & get_instance();
        $ci->db->select('H.*');
        $ci->db->from('hostels AS H');
        $ci->db->where('H.school_id', $school_id);
       return $ci->db->get()->result();
    }

}

if (!function_exists('get_gallery_images')) {

    function get_gallery_images($school_id, $gallery_id) {
        $ci = & get_instance();
        $ci->db->select('GI.*');
        $ci->db->from('gallery_images AS GI');
        $ci->db->where('GI.school_id', $school_id);
        $ci->db->where('GI.gallery_id', $gallery_id);
       return $ci->db->get()->result();
    }
}


if (!function_exists('get_fee_amount')) {

    function get_fee_amount($income_head_id, $class_id) {
        $ci = & get_instance();
        return $ci->db->get_where('fees_amount', array('class_id'=>$class_id, 'income_head_id'=>$income_head_id))->row();
    }
}

if (!function_exists('get_invoice_paid_amount')) {

    function get_invoice_paid_amount($invoice_id){
        $ci = & get_instance();
        $ci->db->select('I.*, SUM(T.amount) AS paid_amount');
        $ci->db->from('invoices AS I');        
        $ci->db->join('transactions AS T', 'T.invoice_id = I.id', 'left');
        $ci->db->where('I.id', $invoice_id); 
		return $ci->db->get()->row(); 
    }
}

if (!function_exists('get_new_invoice_paid_amount')) {

    function get_new_invoice_paid_amount($invoice_id){
        $ci = & get_instance();
        $ci->db->select('I.*, SUM(T.amount) AS new_paid_amount');
        $ci->db->from('invoices AS I');        
        $ci->db->join('transactions AS T', 'T.invoice_id = I.id', 'left');
        $ci->db->where('I.id', $invoice_id); 
		//@$ci->db->where('T.amount', $amount);        
        return $ci->db->get()->row(); 
    }
}

if (!function_exists('get_operation_by_module')) {

    function get_operation_by_module($module_id) {
        $ci = & get_instance();
        $ci->db->select('O.*');
        $ci->db->from('operations AS O');
        $ci->db->where('O.module_id', $module_id);
        return $ci->db->get()->result();
    }

}

if (!function_exists('get_permission_by_operation')) {

    function get_permission_by_operation($role_id, $operation_id) {
        $ci = & get_instance();
        $ci->db->select('P.*');
        $ci->db->from('privileges AS P');
        $ci->db->where('P.role_id', $role_id);
        $ci->db->where('P.operation_id', $operation_id);
        return $ci->db->get()->row();
    }
}

if (!function_exists('get_school_list')) {

    function get_school_list() {
        $ci = & get_instance();
        $ci->db->select('S.*');
        $ci->db->from('schools AS S');
        $ci->db->where('S.status', 1);
        return $ci->db->get()->result();
    }
}

if (!function_exists('get_lang')) {

    function get_lang() {
        $ci = & get_instance();
        $ci->lang->line('dashboard');
    }

}

if (!function_exists('get_live_class_types')) {

    function get_live_class_types() {
        $ci = & get_instance();
        return array(
            
            'jitsi' => 'Jitsi Meet',
            'zoom' => 'Zoom Meeting',
            'google' => 'Google Meet',
            
        );
    }
}


if (!function_exists('get_live_class_status')) {

    function get_live_class_status() {
        $ci = & get_instance();
        return array(
           // 'wating' => $ci->lang->line('wating'),
            'cancelled' => $ci->lang->line('cancelled'),
            'completed' => $ci->lang->line('completed'),
        );
    }
}



if (!function_exists('get_total_student_by_asignment')) {
    function get_total_student_by_section($class_id, $section_id, $academic_year_id) {
        
        $ci = & get_instance();     
        $ci->db->select('E.id');
        $ci->db->from('enrollments AS E');
        $ci->db->where('E.class_id', $class_id); 
        $ci->db->where('E.section_id', $section_id);
        $ci->db->where('E.academic_year_id', $academic_year_id);  
        $result = $ci->db->get()->result();     
        return count($result);        
    }
}

if (!function_exists('get_total_submission_by_asignment')) {
    function get_total_submission_by_asignment($asignment_id, $status = null) {
        
        $ci = & get_instance();     
        $ci->db->select('AS.id');
        $ci->db->from('assignment_submissions AS AS');       
        $ci->db->where('AS.assignment_id', $asignment_id); 
        if($status){
            $ci->db->where('AS.evaluation_status', $status); 
        }
        $result = $ci->db->get()->result();     
        return count($result);        
    }
}



if (!function_exists('get_default_lang_list')) {

    function get_default_lang_list($lang) {
        $lang_lists = array();
        $lang_lists['english'] = 'english';
        $lang_lists['bengali'] = 'bengali';
        $lang_lists['spanish'] = 'spanish';
        $lang_lists['arabic'] = 'arabic';
        $lang_lists['hindi'] = 'hindi';
        $lang_lists['urdu'] = 'urdu';
        $lang_lists['chinese'] = 'chinese';
        $lang_lists['japanese'] = 'japanese';
        $lang_lists['portuguese'] = 'portuguese';
        $lang_lists['russian'] = 'russian';
        $lang_lists['french'] = 'french';
        $lang_lists['korean'] = 'korean';
        $lang_lists['german'] = 'german';
        $lang_lists['italian'] = 'italian';
        $lang_lists['thai'] = 'thai';
        $lang_lists['hungarian'] = 'hungarian';
        $lang_lists['dutch'] = 'dutch';
        $lang_lists['latin'] = 'latin';
        $lang_lists['indonesian'] = 'indonesian';
        $lang_lists['turkish'] = 'turkish';
        $lang_lists['greek'] = 'greek';
        $lang_lists['persian'] = 'persian';
        $lang_lists['malay'] = 'malay';
        $lang_lists['telugu'] = 'telugu';
        $lang_lists['tamil'] = 'tamil';
        $lang_lists['gujarati'] = 'gujarati';
        $lang_lists['polish'] = 'polish';
        $lang_lists['ukrainian'] = 'ukrainian';
        $lang_lists['panjabi'] = 'panjabi';
        $lang_lists['romanian'] = 'romanian';
        $lang_lists['burmese'] = 'burmese';
        $lang_lists['yoruba'] = 'yoruba';
        $lang_lists['hausa'] = 'hausa';

        if (isset($lang_lists[$lang]) && !empty($lang_lists[$lang])) {
            return true;
        } else {
            return FALSE;
        }
    }

}


if (!function_exists('get_timezones')) {
    function get_timezones() {
        $timezones = array(           
            'Pacific/Midway' => "(GMT-11:00) Midway Island",
            'US/Samoa' => "(GMT-11:00) Samoa",
            'US/Hawaii' => "(GMT-10:00) Hawaii",
            'US/Alaska' => "(GMT-09:00) Alaska",
            'US/Pacific' => "(GMT-08:00) Pacific Time (US &amp; Canada)",
            'America/Tijuana' => "(GMT-08:00) Tijuana",
            'US/Arizona' => "(GMT-07:00) Arizona",
            'US/Mountain' => "(GMT-07:00) Mountain Time (US &amp; Canada)",
            'America/Chihuahua' => "(GMT-07:00) Chihuahua",
            'America/Mazatlan' => "(GMT-07:00) Mazatlan",
            'America/Mexico_City' => "(GMT-06:00) Mexico City",
            'America/Monterrey' => "(GMT-06:00) Monterrey",
            'Canada/Saskatchewan' => "(GMT-06:00) Saskatchewan",
            'US/Central' => "(GMT-06:00) Central Time (US &amp; Canada)",
            'US/Eastern' => "(GMT-05:00) Eastern Time (US &amp; Canada)",
            'US/East-Indiana' => "(GMT-05:00) Indiana (East)",
            'America/Bogota' => "(GMT-05:00) Bogota",
            'America/Lima' => "(GMT-05:00) Lima",
            'America/Caracas' => "(GMT-04:30) Caracas",
            'Canada/Atlantic' => "(GMT-04:00) Atlantic Time (Canada)",
            'America/La_Paz' => "(GMT-04:00) La Paz",
            'America/Santiago' => "(GMT-04:00) Santiago",
            'Canada/Newfoundland' => "(GMT-03:30) Newfoundland",
            'America/Buenos_Aires' => "(GMT-03:00) Buenos Aires",
            'Greenland' => "(GMT-03:00) Greenland",
            'Atlantic/Stanley' => "(GMT-02:00) Stanley",
            'Atlantic/Azores' => "(GMT-01:00) Azores",
            'Atlantic/Cape_Verde' => "(GMT-01:00) Cape Verde Is.",
            'Africa/Casablanca' => "(GMT) Casablanca",
            'Europe/Dublin' => "(GMT) Dublin",
            'Europe/Lisbon' => "(GMT) Lisbon",
            'Europe/London' => "(GMT) London",
            'Africa/Monrovia' => "(GMT) Monrovia",
            'Europe/Amsterdam' => "(GMT+01:00) Amsterdam",
            'Europe/Belgrade' => "(GMT+01:00) Belgrade",
            'Europe/Berlin' => "(GMT+01:00) Berlin",
            'Europe/Bratislava' => "(GMT+01:00) Bratislava",
            'Europe/Brussels' => "(GMT+01:00) Brussels",
            'Europe/Budapest' => "(GMT+01:00) Budapest",
            'Europe/Copenhagen' => "(GMT+01:00) Copenhagen",
            'Europe/Ljubljana' => "(GMT+01:00) Ljubljana",
            'Europe/Madrid' => "(GMT+01:00) Madrid",
			'Africa/Lagos' => "(GMT+01:00) Lagos",
            'Europe/Paris' => "(GMT+01:00) Paris",
            'Europe/Prague' => "(GMT+01:00) Prague",
            'Europe/Rome' => "(GMT+01:00) Rome",
            'Europe/Sarajevo' => "(GMT+01:00) Sarajevo",
            'Europe/Skopje' => "(GMT+01:00) Skopje",
            'Europe/Stockholm' => "(GMT+01:00) Stockholm",
            'Europe/Vienna' => "(GMT+01:00) Vienna",
            'Europe/Warsaw' => "(GMT+01:00) Warsaw",
            'Europe/Zagreb' => "(GMT+01:00) Zagreb",
            'Europe/Athens' => "(GMT+02:00) Athens",
            'Europe/Bucharest' => "(GMT+02:00) Bucharest",
            'Africa/Cairo' => "(GMT+02:00) Cairo",
            'Africa/Harare' => "(GMT+02:00) Harare",
            'Europe/Helsinki' => "(GMT+02:00) Helsinki",
            'Europe/Istanbul' => "(GMT+02:00) Istanbul",
            'Asia/Jerusalem' => "(GMT+02:00) Jerusalem",
            'Europe/Kiev' => "(GMT+02:00) Kyiv",
            'Europe/Minsk' => "(GMT+02:00) Minsk",
            'Europe/Riga' => "(GMT+02:00) Riga",
            'Europe/Sofia' => "(GMT+02:00) Sofia",
            'Europe/Tallinn' => "(GMT+02:00) Tallinn",
            'Europe/Vilnius' => "(GMT+02:00) Vilnius",
            'Asia/Baghdad' => "(GMT+03:00) Baghdad",
            'Asia/Kuwait' => "(GMT+03:00) Kuwait",
            'Africa/Nairobi' => "(GMT+03:00) Nairobi",
            'Asia/Riyadh' => "(GMT+03:00) Riyadh",

            'Asia/Tehran' => "(GMT+03:30) Tehran",
            'Europe/Moscow' => "(GMT+04:00) Moscow",
            'Asia/Baku' => "(GMT+04:00) Baku",
            'Europe/Volgograd' => "(GMT+04:00) Volgograd",
            'Asia/Muscat' => "(GMT+04:00) Muscat",
            'Asia/Tbilisi' => "(GMT+04:00) Tbilisi",
            'Asia/Yerevan' => "(GMT+04:00) Yerevan",
            'Asia/Kabul' => "(GMT+04:30) Kabul",
            'Asia/Karachi' => "(GMT+05:00) Karachi",
            'Asia/Tashkent' => "(GMT+05:00) Tashkent",
            'Asia/Kolkata' => "(GMT+05:30) Kolkata",
            'Asia/Kathmandu' => "(GMT+05:45) Kathmandu",
            'Asia/Yekaterinburg' => "(GMT+06:00) Ekaterinburg",
            'Asia/Almaty' => "(GMT+06:00) Almaty",
            'Asia/Dhaka' => "(GMT+06:00) Dhaka",
            'Asia/Novosibirsk' => "(GMT+07:00) Novosibirsk",
            'Asia/Bangkok' => "(GMT+07:00) Bangkok",
            'Asia/Jakarta' => "(GMT+07:00) Jakarta",
            'Asia/Krasnoyarsk' => "(GMT+08:00) Krasnoyarsk",
            'Asia/Chongqing' => "(GMT+08:00) Chongqing",
            'Asia/Hong_Kong' => "(GMT+08:00) Hong Kong",
            'Asia/Kuala_Lumpur' => "(GMT+08:00) Kuala Lumpur",
            'Australia/Perth' => "(GMT+08:00) Perth",
            'Asia/Singapore' => "(GMT+08:00) Singapore",
            'Asia/Taipei' => "(GMT+08:00) Taipei",
            'Asia/Ulaanbaatar' => "(GMT+08:00) Ulaan Bataar",
            'Asia/Urumqi' => "(GMT+08:00) Urumqi",
            'Asia/Irkutsk' => "(GMT+09:00) Irkutsk",
            'Asia/Seoul' => "(GMT+09:00) Seoul",
            'Asia/Tokyo' => "(GMT+09:00) Tokyo",
            'Australia/Adelaide' => "(GMT+09:30) Adelaide",
            'Australia/Darwin' => "(GMT+09:30) Darwin",
            'Asia/Yakutsk' => "(GMT+10:00) Yakutsk",
            'Australia/Brisbane' => "(GMT+10:00) Brisbane",
            'Australia/Canberra' => "(GMT+10:00) Canberra",
            'Pacific/Guam' => "(GMT+10:00) Guam",
            'Australia/Hobart' => "(GMT+10:00) Hobart",
            'Australia/Melbourne' => "(GMT+10:00) Melbourne",
            'Pacific/Port_Moresby' => "(GMT+10:00) Port Moresby",
            'Australia/Sydney' => "(GMT+10:00) Sydney",
            'Asia/Vladivostok' => "(GMT+11:00) Vladivostok",
            'Asia/Magadan' => "(GMT+12:00) Magadan",
            'Pacific/Auckland' => "(GMT+12:00) Auckland",
            'Pacific/Fiji' => "(GMT+12:00) Fiji",
        );

        return $timezones;
    }
}


if (!function_exists('get_date_format')) {
    function get_date_format() {
        
        $date = array();
        $date['Y-m-d'] = '2001-03-15';
        $date['d-m-Y'] = '15-03-2018';
        $date['d/m/Y'] = '15/03/2018';
        $date['m/d/Y'] = '03/15/2018';
        $date['m.d.Y'] = '03.10.2018';
        $date['j, n, Y'] = '14, 7, 2018';
        $date['F j, Y'] = 'July 15, 2018';
        $date['M j, Y'] = 'Jul 13, 2018';
        $date['j M, Y'] = '13 Jul, 2018';
        
        return $date;
    }
}


if (!function_exists('get_mail_protocol')) {
    function get_mail_protocol() {
        
        $protocol = array();
        $protocol['mail'] = 'mail';
        $protocol['sendmail'] = 'sendmail';
        $protocol['smtp'] = 'smtp';        
        
        return $protocol;
    }
}

if (!function_exists('get_smtp_crypto')) {
    function get_smtp_crypto() {
        
        $smtp_crypto = array();
        $smtp_crypto['tls'] = 'tls';
        $smtp_crypto['ssl'] = 'ssl';
        
        return $smtp_crypto;
    }
}

if (!function_exists('get_mail_type')) {
    function get_mail_type() {
        
        $mail_type = array();
        $mail_type['text'] = 'text';
        $mail_type['html'] = 'html';
        
        return $mail_type;
    }
}

if (!function_exists('get_char_set')) {
    function get_char_set() {
        
        $char_set = array();
        $char_set['utf-8'] = 'utf-8';
        $char_set['iso-8859-1'] = 'iso-8859-1';
        
        return $char_set;
    }

}

if (!function_exists('get_email_priority')) {
    function get_email_priority() {
        
        $priority = array();
        $priority['1'] = 'highest';
        $priority['3'] = 'normal';
        $priority['5'] = 'lowest';       
        
        return $priority;
    }
}

if (!function_exists('get_random_tring')) {

    function get_random_tring($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
}

if (!function_exists('get_card_bottom_text_align')) {
    function get_card_bottom_text_align() {
        
        $text_align = array();
        $text_align['center'] = 'center';
        $text_align['left'] = 'left';
        $text_align['right'] = 'right';       
        
        return $text_align;
    }
}

if (!function_exists('get_evaluation_status')) {
    function get_evaluation_status( $status = null) {
        
         $ci = & get_instance();
   
        $evaluate = array();
        $evaluate['submitted'] = $ci->lang->line('submitted');
        $evaluate['completed'] = $ci->lang->line('completed');
        $evaluate['incomplete'] = $ci->lang->line('incomplete');       
        $evaluate['resubmitted'] = $ci->lang->line('resubmitted');           
        
        if($status){
            return $evaluate[$status];
        }else{
            return $evaluate;
        }
    }
}


if (!function_exists('get_teacher_rating')) {
    function get_teacher_rating($techer_id) {
        
        $ci = & get_instance();
        $ci->db->select('R.*, S.name AS student_name');
        $ci->db->from('ratings AS R');
        $ci->db->join('students AS S', 'S.id = R.student_id', 'left');
        $ci->db->where('R.teacher_id', $techer_id);
        $ci->db->where('R.student_id', $ci->session->userdata('profile_id'));
        $ci->db->where('R.class_id', $ci->session->userdata('class_id'));
        $ci->db->where('R.section_id', $ci->session->userdata('section_id'));
        $ci->db->where('R.academic_year_id', $ci->session->academic_year_id);    
        return $ci->db->get()->row();     
    }
}


if (!function_exists('get_teacher_avg_rating')) {
    function get_teacher_avg_rating($academic_year_id, $techer_id) {
        
        $ci = & get_instance();
        $ci->db->select('SUM(R.rating) AS total_rating, COUNT(R.id) AS rating_count');
        $ci->db->from('ratings AS R');
        $ci->db->where('R.teacher_id', $techer_id);       
        $ci->db->where('R.rating_status', 'approved');       
        $ci->db->where('R.academic_year_id', $academic_year_id);       
        $rating = $ci->db->get()->row();
        if($rating->total_rating > 0 && $rating->rating_count > 0) {
            return $rating->total_rating/$rating->rating_count;
        }else{
            return '';
        }       
    }
}


if (!function_exists('get_donar_types')) {

    function get_donar_types() {
        $ci = & get_instance();
        return array(
            'individual' => $ci->lang->line('individual'),
            'organization' => $ci->lang->line('organization')
        );
    }

}


if (!function_exists('get_lesson_detail_by_lesson_id')) {
    function get_lesson_detail_by_lesson_id($lesson_id) {
        
        $ci = & get_instance();
        $ci->db->select('LD.*');
        $ci->db->from('lp_lesson_details AS LD');
        $ci->db->where('LD.lesson_id', $lesson_id); 
        $ci->db->order_by('LD.id', 'ASC'); 
        return $ci->db->get()->result();     
        
    }
}



if (!function_exists('get_topic_detail_by_topic_id')) {
    function get_topic_detail_by_topic_id($topic_id) {
        
        $ci = & get_instance();
        $ci->db->select('TD.*');
        $ci->db->from('lp_topic_details AS TD');
        $ci->db->where('TD.topic_id', $topic_id); 
        $ci->db->order_by('TD.id', 'ASC'); 
        return $ci->db->get()->result();     
        
    }
}


if (!function_exists('get_lesson_status')) {
    function get_lesson_status( $status = null) {
        
         $ci = & get_instance();
   
        $lesson = array();
        $lesson['completed'] = $ci->lang->line('completed');
        $lesson['incomplete'] = $ci->lang->line('incomplete');       
        
        if($status){
            return $lesson[$status];
        }else{
            return $lesson;
        }
    }
}



if (!function_exists('get_question_label')) {
    function get_question_label() {
        
         $ci = & get_instance();
   
        $type = array();
        $type['easy'] = $ci->lang->line('easy');
        $type['medium'] = $ci->lang->line('medium');
        $type['hard'] = $ci->lang->line('hard');
        
        return $type;
    }
}


if (!function_exists('get_question_type')) {
    function get_question_type($index = null) {
        
         $ci = & get_instance();
   
        $type = array();
        $type['single'] = $ci->lang->line('single_answer');
        $type['multi'] = $ci->lang->line('multi_answer');
        $type['blank'] = $ci->lang->line('fill_in_blank');
        $type['boolean'] = $ci->lang->line('true_false');
        
        if($index){
            return $type[$index];
        }else{
            return $type;
        }
    }
}


if (!function_exists('get_mark_type')) {
    function get_mark_type() {
        
         $ci = & get_instance();
   
        $type = array();
        $type['percentage'] = $ci->lang->line('percentage');
        $type['fixed'] = $ci->lang->line('fixed');       
        
        return $type;
    }
}



if (!function_exists('get_option_by_questoin_id')) {
    function get_option_by_questoin_id($question_id) {
        
        $ci = & get_instance();
        
        $ci->db->select('QA.*');
        $ci->db->from('exam_answers AS QA');       
        $ci->db->where('QA.question_id', $question_id);         
        $options = $ci->db->get()->result();          
        return $options;        
    }
}

if (!function_exists('get_exam_to_question')) {
    function get_exam_to_question($online_exam_id) {
        
        $ci = & get_instance();
        
        $ci->db->select('EQ.*');
        $ci->db->from('exam_to_questions AS EQ');       
        $ci->db->where('EQ.online_exam_id', $online_exam_id);         
        return $ci->db->get()->result();
    }
}

if (!function_exists('get_total_question_by_exam')) {
    function get_total_question_by_exam($online_exam_id) {
        
        $ci = & get_instance();
        
        $ci->db->select('EQ.*');
        $ci->db->from('exam_to_questions AS EQ');       
        $ci->db->where('EQ.online_exam_id', $online_exam_id);         
        return $ci->db->count_all_results();
    }
}


if (!function_exists('get_question_detail')) {
    function get_question_detail($online_exam_id, $question_id, $counter = null) {
        
        $ci = & get_instance(); 
        
        $ci->db->select('EQ.*');
        $ci->db->from('exam_questions AS EQ');       
        $ci->db->where('EQ.id', $question_id);         
        $question = $ci->db->get()->row(); 
        
        
        $ci->db->select('QA.*');
        $ci->db->from('exam_answers AS QA');       
        $ci->db->where('QA.question_id', $question_id);         
        $options = $ci->db->get()->result(); 
          
        $str = '<div class="question-container">'; 
            $str .= '<div class="row question-title">';                
                $str .= '<div class="col-md-9 col-sm-9 col-xs-9"> '. $counter.'. '.$question->question.'</div>';
                $str .= '<div class="col-md-3 col-sm-3 col-xs-3 text-right">'.$ci->lang->line('mark').': '.$question->mark.'</div>';
            $str .= '</div>';
            
            if ($question->image) {
                $str .= '<div class="row question-title">';                
                    $str .= '<div class="col-md-12 col-sm-12 col-xs-12"><img src="'. UPLOAD_PATH.'/question/'. $question->image.'" alt="" style="width: auto;" /></div>';               
                $str .= '</div>';
            }
            
            $str .= '<div class="row">'; 
            if($question->question_type == 'single'){

                foreach($options AS $obj){                       

                    $answer = $obj->is_correct ? 'checked="checked"' : '';

                    $str .= '<div class="col-md-6 col-sm-6 col-xs-12" style="display:inline-table">
                           <input id="'.$obj->id.'" type="radio" name="singleans'.$obj->id.'[]" value="1" '.$answer.' disabled="disabled"> '. $obj->option.' 
                        </div>';   
                }
            }else if($question->question_type == 'multi'){

                foreach($options AS $obj){                       

                    $answer = $obj->is_correct ? 'checked="checked"' : '';

                    $str .= '<div class="col-md-6 col-sm-6 col-xs-12" style="display:inline-table">
                           <input type="checkbox" name="ans'.$obj->id.'[]" value="1" '.$answer.' disabled="disabled"> '. $obj->option.' 
                        </div>';   
                }

            }else if($question->question_type == 'boolean'){

                foreach($options AS $obj){                       

                    $answer = $obj->is_correct ? 'checked="checked"' : '';                        
                    $str .= '<div class="col-md-6 col-sm-6 col-xs-12" style="display:inline-table">
                           <input type="radio" name="ans[]" value="1" '.$answer.' disabled="disabled"> '. $obj->option .' 
                        </div>';   
                }
            }else if($question->question_type == 'blank'){

                foreach($options AS $key=>$obj){                       

                    $answer = $obj->is_correct ? 'checked="checked"' : '';

                    $str .= '<div class="col-md-12" style="display:inline-table">
                           '. ($key+1) . '.  ' .$obj->option.' 
                            </div>';   
                }
            }

            $str .= '<div class="col-md-12 text-right"><button onclick="javascript:void(0);remove_exam_question('.$online_exam_id.', '.$question_id.' , this)" class="btn btn-danger btn-xs "><i class="fa fa-trash-o"></i> '.$ci->lang->line('remove').' : <span> '.$counter.' </span></button></div>';        
            $str .= '<div class="col-md-12"><hr/></div>';        
            $str .= '</div>';
            
        $str .= '</div>';
            

        return $str;    
    }
}


if (!function_exists('get_item_type')) {
    function get_item_type() {
        
         $ci = & get_instance();
   
        $type = array();
        $type['new'] = $ci->lang->line('new');
        $type['used'] = $ci->lang->line('used');
        
        return $type;
    }
}


if (!function_exists('get_unit_types')) {

    function get_unit_types() {
        $ci = & get_instance();
        return array(
            'unit' => $ci->lang->line('unit'),
            'kg' => $ci->lang->line('kg'),
            'piece' => $ci->lang->line('piece'),
            'other' => $ci->lang->line('other')
        );
    }

}

// END

if (!function_exists('check_saas_status')) {

    function check_saas_status($school_id, $feature = null) {

        $ci = & get_instance();
        $ci->db->select('SP.*, SS.subscription_status, SS.end_date, SS.start_date, S.school_name, S.subscription_id');
        $ci->db->from('schools AS S');
        $ci->db->join('saas_subscriptions AS SS', 'SS.id = S.subscription_id', 'left');  
        $ci->db->join('saas_plans AS SP', 'SP.id = SS.subscription_plan_id', 'left');  
        $ci->db->where('S.id', $school_id);
        $subs = $ci->db->get()->row(); 

       
        if (empty($subs)) {            
            error($ci->lang->line('permission_denied'));
            return FALSE;
           
        } else {
           
            if(!$subs->subscription_id){              
                error($ci->lang->line('not_yet_subscribed')); // not yet subscribed
                return FALSE;
            }elseif($subs->subscription_status == 'pending'){ // pending
                
                error($ci->lang->line('subscription_pending'));
                return FALSE;
                
            }elseif($subs->subscription_status == 'suspend'){ // suspended
                
                error($ci->lang->line('subscription_suspended'));
                return FALSE;
                
            }elseif($subs->subscription_status == 'expired'){ // expired
                
                error($ci->lang->line('subscription_expired'));
                return FALSE;
                
            }elseif(strtotime($subs->end_date) < time()){ // expired
               
                error($ci->lang->line('subscription_expired'));
                return FALSE;                
                
            }elseif($feature == 'auth' ){ // pass for just login                   
                
                return TRUE;
                
            }elseif($feature == 'student' ){ // for student limit                  
                               
                $ci->db->where('school_id', $school_id);       
                $total_student = $ci->db->count_all_results('students');
        
                if($total_student > $subs->student_limit ){
                    error($ci->lang->line('upgrade_your_plan'));
                    return FALSE;   
                }else{                    
                    return TRUE;
                }
                
            }elseif($feature == 'guardian' ){ // for guardian limit                  
                
                $ci->db->where('school_id', $school_id);       
                $total_guardian = $ci->db->count_all_results('guardians'); 
                
                if($total_guardian > $subs->guardian_limit ){
                    error($ci->lang->line('upgrade_your_plan'));
                    return FALSE;   
                }else{                    
                    return TRUE;
                }
                
            }elseif($feature == 'teacher' ){ // for teacher limit                  
                
                $ci->db->where('school_id', $school_id);       
                $total_teacher = $ci->db->count_all_results('teachers'); 
                
                if($total_teacher > $subs->teacher_limit ){
                    error($ci->lang->line('upgrade_your_plan'));
                    return FALSE;   
                }else{                    
                    return TRUE;
                }
                
            }elseif($feature == 'employee' ){ // for employee limit                  
                
                $ci->db->where('school_id', $school_id);       
                $total_employee = $ci->db->count_all_results('employees'); 
                
                if($total_employee > $subs->employee_limit ){
                    error($ci->lang->line('upgrade_your_plan'));
                    return FALSE;   
                }else{                    
                    return TRUE;
                }
                
            }elseif($feature != '' && !$subs->{$feature}){ // upgrade your plan   
                
                error($ci->lang->line('upgrade_your_plan'));
                return FALSE;                
                
            }else{
                
                 return TRUE;
            }            
        }

        return TRUE;       
        
    }

}


if (!function_exists('check_permission')) {

    function check_permission($action) {

        $ci = & get_instance();
        $role_id = $ci->session->userdata('role_id');
        $operation_slug = $ci->router->fetch_class();
        $module_slug = $ci->router->fetch_module();

        if ($module_slug == '') {
            $module_slug = $operation_slug;
        }

        $module_slug = 'my_' . $module_slug;

        $data = $ci->config->item($operation_slug, $module_slug);

        $result = $data[$role_id];
        if (!empty($result)) {
            $array = explode('|', $result);
            if (!$array[$action]) {
                error($ci->lang->line('permission_denied'));
                redirect('dashboard/index');
            }
        } else {
            error($ci->lang->line('permission_denied'));
             redirect('dashboard/index');
        }

        return TRUE;
    }

}

if (!function_exists('has_permission')) {

    function has_permission($action, $module_slug = null, $operation_slug = null) {

        $ci = & get_instance();
        $role_id = $ci->session->userdata('role_id');

        if ($module_slug == '') {
            $module_slug = $operation_slug;
        }

        $module_slug = 'my_' . $module_slug;

        $data = $ci->config->item($operation_slug, $module_slug);

        $result = @$data[$role_id];

        if (!empty($result)) {
            $array = explode('|', $result);
            return $array[$action];
        } else {
            return FALSE;
        }
    }

}


if (!function_exists('create_log')) {

    function create_log($activity = null) {

        $ci = & get_instance();
        $data = array();
        
        if($ci->session->userdata('role_id') == SUPER_ADMIN){
            $data['school_id'] = 0;
        }else{
            $data['school_id'] = $ci->session->userdata('school_id');            
        }
        
        if(!$data['school_id']){ return;}
        
        $data['user_id'] = logged_in_user_id();
        $data['role_id'] = logged_in_role_id(); 
        $user = get_user_by_id($data['user_id']);
        
       @$data['name'] = $user->name;
        @$data['phone'] = $user->phone;
        @$data['email'] = $user->email;
        $data['ip_address'] = $_SERVER['REMOTE_ADDR'];
        $data['user_agent'] = $_SERVER['HTTP_USER_AGENT'];
        $data['activity'] = $activity;
        $data['status'] = 1;
        $data['created_at'] = date('Y-m-d H:i:s');
        $data['created_by'] = logged_in_user_id();
        $ci->db->insert('activity_logs', $data);
    }
}



/* STRICT DATA ACCESS START*/


if (!function_exists('get_guardian_access_data')) {
    
 function get_guardian_access_data($type = NULL){
       
        
        $ci = & get_instance();
        
         if($ci->session->userdata('role_id') != GUARDIAN){
             return FALSE;
         }
        
        $school_id = $ci->session->userdata('school_id'); 
        $guardian_id = $ci->session->userdata('profile_id'); 
        $school =  $ci->db->get_where('schools', array('id'=>$school_id))->row();
        
        $ci->db->select('E.student_id, E.roll_no, E.class_id, E.section_id, C.name AS class_name, SE.name AS section');
        $ci->db->from('enrollments AS E');
        $ci->db->join('students AS S', 'S.id = E.student_id', 'left');
        $ci->db->join('classes AS C', 'C.id = E.class_id', 'left');
        $ci->db->join('sections AS SE', 'SE.id = E.section_id', 'left');
		// $ci->db->join('guardians AS G', 'G.id = S.guardian_id', 'left');
        //$ci->db->where('E.academic_year_id', $school->academic_year_id);
        $ci->db->where('S.guardian_id', $guardian_id);
        $ci->db->where('S.school_id', $school_id);
        $result = $ci->db->get()->result();   
        $data = array();
        
       if(!empty($result )){
            if($type == 'class'){

                foreach($result as $obj){
                    $data[] = $obj->class_id;
                }
                
            }elseif($type == 'section'){

                foreach($result as $obj){
                    $data[] = $obj->section_id;
                }
            
            }elseif($type == 'student'){

                foreach($result as $obj){
                    $data[] = $obj->student_id;
                }
            }elseif($type == 'subject'){

                foreach($result as $obj){
                    $data[] = $obj->class_id;
                }  
                
                // Getting subject ids by classes
                $ci->db->select('S.*');
                $ci->db->from('subjects AS S');            
                $ci->db->where_in('S.class_id', implode(',', $data)); 
                $ci->db->order_by("S.id", "ASC");
                $subjects= $ci->db->get()->result();

                foreach($subjects as $obj){
                    $data[] = $obj->teacher_id;
                } 
                
            }
       }
       
       return $data;        
   }   
}


if (!function_exists('get_teacher_access_data')) {
    
 function get_teacher_access_data($type = NULL){
       
        $ci = & get_instance();
        
        if($ci->session->userdata('role_id') != TEACHER){
            return FALSE;
        }
        
        $school_id = $ci->session->userdata('school_id'); 
        $teacher_id = $ci->session->userdata('profile_id'); 
        $school =  $ci->db->get_where('schools', array('id'=>$school_id))->row();
               
        $data = array();                 

        // checking in routine is there a teacher
        $ci->db->select('R.class_id');
        $ci->db->from('routines AS R');            
        $ci->db->where('R.teacher_id', $ci->session->userdata('profile_id')); 
        $ci->db->where('R.school_id', $school_id); 
        $ci->db->order_by("R.id", "ASC");
        $result = $ci->db->get()->result();

        foreach($result as $obj){
            $data[] = $obj->class_id;
        }

        // checking in subject is there a teacher
        $ci->db->select('S.class_id');
        $ci->db->from('subjects AS S');                
        $ci->db->where('S.teacher_id', $ci->session->userdata('profile_id')); 
        $ci->db->where('S.school_id', $school_id); 
        $ci->db->order_by("S.id", "ASC");
        $result = $ci->db->get()->result();

        foreach($result as $obj){
            $data[] = $obj->class_id;
        }


        // checking in section is there a teacher
        $ci->db->select('S.class_id');
        $ci->db->from('sections AS S');                
        $ci->db->where('S.teacher_id', $ci->session->userdata('profile_id')); 
        $ci->db->where('S.school_id', $school_id); 
        $ci->db->order_by("S.id", "ASC");
        $result = $ci->db->get()->result();

        foreach($result as $obj){
            $data[] = $obj->class_id;
        }

        // checking in class is there a teacher
        $ci->db->select('C.id AS class_id');
		
        $ci->db->from('classes AS C');                
        $ci->db->where('C.teacher_id', $ci->session->userdata('profile_id')); 
        $ci->db->where('C.school_id', $school_id); 
        $ci->db->order_by("C.id", "ASC");
        $result = $ci->db->get()->result();


        //foreach($result as $obj){
           // $data[] = $obj->class_id;
			//$data[] = $obj->teacher_id;
        //}     
        
       
       return array_unique($data);        
   }   
}


if (!function_exists('get_student_access_data')) {
    
 function get_student_access_data($type = NULL){
       
        $ci = & get_instance();
         if($ci->session->userdata('role_id') != STUDENT){
             return FALSE;
         }
        
        $school_id = $ci->session->userdata('school_id'); 
        $student_id = $ci->session->userdata('profile_id'); 
        $school =  $ci->db->get_where('schools', array('id'=>$school_id))->row();
               
        $data = array();
        
        if($type == 'student'){                

            $ci->db->select('R.*, S.name AS subject, T.name AS teacher, C.name AS class_name');
            $ci->db->from('routines AS R');
            $ci->db->join('subjects AS S', 'S.id = R.subject_id', 'left');
            $ci->db->join('teachers AS T', 'T.id = R.teacher_id', 'left');
            $ci->db->join('classes AS C', 'C.id = R.class_id', 'left');
            $ci->db->where('R.teacher_id', $ci->session->userdata('profile_id')); 
            $ci->db->order_by("R.id", "ASC");
            $result = $ci->db->get()->result();
            
            foreach($result as $obj){
                $data[] = $obj->class_id;
            }
        }elseif($type == 'subject'){
            
            $ci->db->select('S.*');
            $ci->db->from('subjects AS S');            
            $ci->db->where('S.class_id', $ci->session->userdata('class_id')); 
            $ci->db->order_by("S.id", "ASC");
            $result = $ci->db->get()->result();
            
            foreach($result as $obj){
                $data[] = $obj->teacher_id;
            }            
        }

       
       return $data;        
   }   
}

//Added by D-Ultimate
if (!function_exists('fetch_main_subjects_assignable')) {
    function fetch_main_subjects_assignable($subject_passed_id) {
        $ci = & get_instance();

        $ci->db->select('*');
        $ci->db->from('subjects');       
        $ci->db->where('school_id', $subject_passed_id);         
        $ci->db->where('has_subs', 1);         
        return $ci->db->get()->result();
    }
}

if (!function_exists('get_invoice_list_by_id')) {
function get_invoice_list_by_id($invoice_id) {
    $ci = & get_instance();

    $ci->db->select('*, IS.id AS invID');
    $ci->db->from('invoice_detail IS');
    $ci->db->join('income_heads AS IH', 'IH.id = IS.income_head_id', 'left');
    $ci->db->where('IS.invoice_id', $invoice_id);
    return $ci->db->get()->result();
    }
}

if (!function_exists('get_class_id_by_name')) {
    function get_class_id_by_name($name) {

        $ci = & get_instance();

        $ci->db->select('id');
        $ci->db->from('classes');
        $ci->db->where('name', $name);
        $query = $ci->db->get();
        if ($query->num_rows() > 0){
            return $query->row()->id;
        }else{
            return false;
        } 
    }
}

if (!function_exists('get_total_students_in_class_two')) {
    function get_total_students_in_class_two($class_id) {
        $ci = & get_instance();

        $ci->db->select('COUNT(*) AS cntr');
        $ci->db->from('enrollments');   
        $ci->db->where('class_id', $class_id);
        $result = $ci->db->get()->row();
        if (is_numeric($result->cntr)){
            return $result->cntr;
        }else{
            return "Invalid count returned, expected a number";
        } 
    }
}



// if (!function_exists('get_class_id_by_name')) {
//     function get_class_id_by_name($name) {

//         $ci = & get_instance();

//         $ci->db->select('id');
//         $ci->db->from('classes');
//         $ci->db->where('name', $name);
//         $query = $ci->db->get();
//         if ($query->num_rows() > 0){
//             $result = $query->row();
//             if (is_numeric($result->id)){
//                 return $result->id;
//             }else{
//                 return "Invalid id returned, expected a number";
//             }
//         }else{
//             return false;
//         } get_user_by_role
//     }
// }

if (!function_exists('get_class_id_by_name')) {
    function get_class_id_by_name($name) {

        $ci = & get_instance();

        $ci->db->select('id');
        $ci->db->from('classes');
        $ci->db->where('name', $name);

        return $ci->db->get()->row()->id; 
    }
}

if (!function_exists('get_total_students_in_class')) {
    function get_total_students_in_class($class_id) {
        $ci = & get_instance();

        $ci->db->select('COUNT(*) AS cntr');
        $ci->db->from('enrollments');   
        $ci->db->where('class_id', $class_id);
        return $ci->db->get()->row(); 
    }
}

//Added by VEMATECH

if (!function_exists('get_average_mark')) {

    function get_average_mark($school_id, $academic_year_id, $exam_id, $class_id, $section_id, $subject_id) {
        $ci = & get_instance();
        $ci->db->select('SUM(M.obtain_total_mark) AS average');
        $ci->db->from('marks AS M');       
        $ci->db->where('M.school_id', $school_id);
        $ci->db->where('M.academic_year_id', $academic_year_id);
        $ci->db->where('M.exam_id', $exam_id);
        $ci->db->where('M.class_id', $class_id);
        $ci->db->where('M.section_id', $section_id);
        $ci->db->where('M.subject_id', $subject_id);  
        return  $ci->db->get()->row();
     // echo $ci->db->last_query();
    }
}

/**

if (!function_exists('get_student_attendance')) {

    function get_student_attendance($student_id, $school_id, $academic_year_id, $term_id, $class_id, $section_id, $year, $month, $day) {
        $ci = & get_instance();
       	$field = 'day_' . abs($day);
		
		
        $ci->db->select('SA.' . $field);
		$ci->db->select('COUNT('. $field .') AS present');
        $ci->db->from('student_attendances AS SA');
        $ci->db->where('SA.student_id', $student_id);
        $ci->db->where('SA.academic_year_id', $academic_year_id);
		$ci->db->where('SA.term_id', $term_id);
        $ci->db->where('SA.school_id', $school_id);
        $ci->db->where('SA.class_id', $class_id);
		
       	if($section_id){
            $ci->db->where('SA.section_id', $section_id);
        }
        $ci->db->where('SA.year', $year);
        $ci->db->where('SA.month', $month);
        return @$ci->db->get()->row()->$field;
    }

}

**/
	//Added by agbolase
if (!function_exists('get_income_head')) {

    function get_income_head() {
        $ci = & get_instance();
        $ci->db->select('*');
        $ci->db->from('income_heads');            
   		$ci->db->where('head_type', income); 
       // $ci->db->order_by("id", "ASC");
        return $ci->db->get()->result();
    }

}

if (!function_exists('get_exam_result_status')) {

    function get_exam_result_status() {
        $ci = & get_instance();
        return array(
            'publish' => "Publish Result",
            'unpublish' => "Unpublish Result",
        );
    }

}

if (!function_exists('get_exam_result_term')) {
 function get_exam_result_term() {
        $ci = & get_instance();
        return array(
            '1' => "Term 1",
            '2' => "Term 2",
			'3' => "Term 3",
        );
    }
}

if (!function_exists('get_online_exam_result_type')) {
 function get_online_exam_result_type() {
        $ci = & get_instance();
        return array(
            '1' => "CA1",
            '2' => "CA2",
			'3' => "CA3",
			'4' => "CA4",
			'5' => "Exam",
        );
    }
}


if (!function_exists('get_ratings')) {

    function get_ratings() {
        $ci = & get_instance();
        return array(
            '1' => "Beyond Expectation",
            '2' => "Yet To Attain",
            '3' => "On Track",
			'4' => "Satisfactory",
			'5' => "Work In Progress",
        );
    }

}



//Added by D-Ultimate
if (!function_exists('get_state')) {

    function get_state() {
        $ci = & get_instance();
        $ci->db->select('*');
        $ci->db->from('tbl_states');            
        $ci->db->where('status', 1); 
        $ci->db->order_by("state_id", "ASC");
        return $ci->db->get()->result();
    }

}

//Added by D-Ultimate
if (!function_exists('get_lgas')) {

    function get_lgas($state_id=null) {
        $ci = & get_instance();
        $ci->db->select('*');
        $ci->db->from('tbl_states_lga'); 
        if ($state_id != null) {
            $ci->db->where('state_id', $state_id); 
        }
        
        $ci->db->order_by("lga_id", "ASC");
        return $ci->db->get()->result();
    }

}

/**
//ADDED BY VEMATECH
if (!function_exists('get_class_teacher')) {
function get_class_teacher($student_id, $school_id, $academic_year_id, $class_id, $section_id) {
    $ci = & get_instance();

	 $ci->db->select('class_id AS teachID');
	 $ci->db->from('marks M');
	  $ci->db->join('marks AS M', 'M.class_id = C.id', 'left');
    $ci->db->where('M.class_id', $class_id);
    return $ci->db->get()->result();
    }
}

**/
if (!function_exists('get_teacher_from_class')) {
    function get_teacher_from_class($class_id, $school_id) {
        $ci = & get_instance();
         $ci->db->select('T.name AS tname');
         $ci->db->from('classes AS C');
        $ci->db->join('teachers AS T', 'T.id = C.teacher_id', 'left');
        $ci->db->where('C.id', $class_id);
        $ci->db->where('C.school_id', $school_id);
        return $ci->db->get()->row();
        }
    }
	
	if (!function_exists('get_teacher_from_section')) {
    function get_teacher_from_section($section_id, $school_id) {
        $ci = & get_instance();
         $ci->db->select('teacher_id, T.name AS tname, T.t_signature AS tsignature' );
         $ci->db->from('sections AS SE');
        $ci->db->join('teachers AS T', 'T.id = SE.teacher_id', 'left');
        $ci->db->where('SE.id', $section_id);
        return $ci->db->get()->row();
        }
    }
	
	
		if (!function_exists('get_teacher_from_subject')) {
    function get_teacher_from_subject($school_id, $class_id, $section_id) {
        $ci = & get_instance();
        $ci->db->select('T.name AS tname, S.id AS subject_id');
        $ci->db->from('subjects AS S');
        $ci->db->join('teachers AS T', 'T.id = S.teacher_id', 'left');
        $ci->db->join('sections AS SE', 'SE.class_id = S.class_id', 'left');
        $ci->db->where('SE.id', $section_id);
        //$ci->db->where('S.id', $subject_id);
        $result = $ci->db->get()->row();

        if (isset($result->tname)) {
            return $result->tname;
        } else {
            return "No teacher found for this subject";
        }
    }
	
	if (!function_exists('get_teacher_photo_url')) {
    function get_teacher_photo_url($photo_name) {
        return base_url('assets/uploads/teacher-photo/' . $photo_name);
    }
}

function calculate_days_in_term($term_begin, $end_of_term_date) {
    // Convert dates to DateTime objects
    $term_begin = new DateTime($term_begin);
    $end_of_term_date = new DateTime($end_of_term_date);

    // Calculate the difference between the two dates
    $interval = $term_begin->diff($end_of_term_date);

    // Return the difference in days
    return $interval->days;
}


/**
 * Calculates the number of days between two dates excluding Saturdays and Sundays.
 *
 * @param string $start The start date in Y-m-d format.
 * @param string $end The end date in Y-m-d format.
 *
 * @return int The number of days between the two dates excluding Saturdays and Sundays.
 */
function getWorkingDays($start, $end)
{
    // Convert the start and end dates to Unix timestamps.
    $startTimestamp = strtotime($start);
    $endTimestamp = strtotime($end);

    // Initialize the total number of working days.
    $workingDays = 0;

    // Loop through each day between the start and end dates.
    for ($i = $startTimestamp; $i <= $endTimestamp; $i += 86400) {
        // If the current day is a Saturday or Sunday, skip it.
        if (date('N', $i) >= 6) {
            continue;
        }

        // Increment the number of working days.
        $workingDays++;
    }

    return $workingDays;
}
	
	
	
	
	
function getMidWorkingDays($start, $end)
{
    // Convert the start and end dates to Unix timestamps.
    $startTimestamp = strtotime($start);
    $endTimestamp = strtotime($end);

    // Initialize the total number of working days.
    $workingDays = 0;

    // Loop through each day between the start and end dates.
    for ($i = $startTimestamp; $i <= $endTimestamp; $i += 86400) {
        // If the current day is a Saturday or Sunday, skip it.
        if (date('N', $i) >= 6) {
            continue;
        }

        // Increment the number of working days.
        $midworkingDays++;
    }

    return $midworkingDays;
}
		
	
	
	
	
	
	
		}




if (!function_exists('get_sum_of_obtain_total_mark')) {

    function get_sum_of_obtain_total_mark($school_id, $academic_year_id, $class_id, $section_id = null, $student_id = null) {
        $ci = & get_instance();
        
        $select = 'SUM(M.exam_total_mark) AS exam_total_mark,
                   SUM(M.obtain_total_mark) AS obtain_total_mark';
        
        $ci->db->select($select);
        $ci->db->from('marks AS M');        
         $ci->db->where('M.school_id', $school_id);
        $ci->db->where('M.academic_year_id', $academic_year_id);
        $ci->db->where('M.class_id', $class_id);
		$ci->db->where_not_in('M.obtain_total_mark', '0');
		$ci->db->where('M.rel_subject_id', 0);
        if($section_id){
            $ci->db->where('M.section_id', $section_id);
        }
        $ci->db->where('M.student_id', $student_id);
        //$ci->db->where('M.exam_id', $exam_id);        
        return $ci->db->get()->row();  
         $ci->db->last_query();
    }
}



function get_previous_subjects_marks_academic_year($school_id, $student_id, $exam_id, $subject_id) {
    $CI =& get_instance();
    $CI->load->database();
    $CI->db->select('obtain_total_mark');
	$CI->db->where('student_id', $student_id);
    $CI->db->where('subject_id', $subject_id);
	$CI->db->where('marks.school_id', $school_id);
	$CI->db->where('exam_id =', $exam_id);
   // $CI->db->where('marks.academic_year_id', $academic_year_id);
    $CI->db->where('marks.status', 1); // Only get marks that are approved
    $query = $CI->db->get('marks');
    return $query->result();
}
	
	
function get_previous_subjects_marks_academic_year_scores($school_id, $academic_year_id, $student_id, $subject_id, $exam_id) {
    $CI =& get_instance();
    $CI->load->database();
    $CI->db->select('marks.obtain_total_mark, exams.exam_result_term');
    $CI->db->from('marks');
    $CI->db->join('exams', 'marks.exam_id = exams.id');
    $CI->db->where('marks.student_id', $student_id);
    $CI->db->where('exams.exam_result_term', 1);
    $CI->db->where('marks.subject_id', $subject_id);
    $CI->db->where('marks.school_id', $school_id);
    $CI->db->where('marks.exam_id <', $exam_id); // Filter for exams with id less than $exam_id
    $CI->db->where('marks.status', 1); // Only get marks that are approved
    $query = $CI->db->get();
    $result = $query->result();

    // Check if there are no results
    if (empty($result)) {
        echo '<td width="5%" align="center" style="font-size:10px"></td>'; // Echo an empty table cell
    } else {
        // Iterate over each result and echo the obtain_total_mark and exam_result_term
        foreach ($result as $row) {
            echo '<td width="5%" align="center" style="font-size:10px">' . @number_format($row->obtain_total_mark, 2) . '</td>';
            //echo '<td width="5%" align="center" style="font-size:10px">' . $row->exam_result_term . '</td>';
        }
    }
}



function get_previous_subjects_marks_academic_year_scores1($school_id, $academic_year_id, $student_id, $subject_id, $exam_id) {
    $CI =& get_instance();
    $CI->load->database();
    $CI->db->select('marks.obtain_total_mark, exams.exam_result_term');
    $CI->db->from('marks');
    $CI->db->join('exams', 'marks.exam_id = exams.id');
    $CI->db->where('marks.student_id', $student_id);
    $CI->db->where('exams.exam_result_term', 1);
    $CI->db->where('marks.subject_id', $subject_id);
    $CI->db->where('marks.school_id', $school_id);
    $CI->db->where('marks.exam_id <', $exam_id); // Filter for exams with id less than $exam_id
    $CI->db->where('marks.status', 1); // Only get marks that are approved
    $query = $CI->db->get();
    $result = $query->result();

   // Check if there are no results
    if (empty($result)) {
        echo '<td width="5%" align="center" style="font-size:10px"></td>'; // Echo an empty table cell
    } else {
        // Iterate over each result and echo the obtain_total_mark and exam_result_term
        foreach ($result as $row) {
            echo '<td width="5%" align="center" style="font-size:10px">' . @number_format($row->obtain_total_mark, 2) . '</td>';
            //echo '<td width="5%" align="center" style="font-size:10px">' . $row->exam_result_term . '</td>';
        }
    }
}

 


function get_previous_subjects_marks_academic_year_scores2($school_id, $academic_year_id, $student_id, $subject_id, $exam_id) {
    $CI =& get_instance();
    $CI->load->database();
    $CI->db->select('marks.obtain_total_mark, exams.exam_result_term');
    $CI->db->from('marks');
    $CI->db->join('exams', 'marks.exam_id = exams.id');
    $CI->db->where('marks.student_id', $student_id);
    $CI->db->where('exams.exam_result_term', 2);
    $CI->db->where('marks.subject_id', $subject_id);
    $CI->db->where('marks.school_id', $school_id);
    $CI->db->where('marks.exam_id <', $exam_id); // Filter for exams with id less than $exam_id
    $CI->db->where('marks.status', 1); // Only get marks that are approved
    $query = $CI->db->get();
    $result = $query->result();

    // Check if there are no results
    if (empty($result)) {
        echo '<td width="5%" align="center" style="font-size:10px"></td>'; // Echo an empty table cell
    } else {
        // Iterate over each result and echo the obtain_total_mark and exam_result_term
        foreach ($result as $row) {
            echo '<td width="5%" align="center" style="font-size:10px">' . @number_format($row->obtain_total_mark, 2) . '</td>';
            //echo '<td width="5%" align="center" style="font-size:10px">' . $row->exam_result_term . '</td>';
        }
    }
}




function get_real_subjects_marks_academic_year_scores($school_id, $student_id, $subject_id,  $exam_id) {
    $CI =& get_instance();
    $CI->load->database();

    $CI->db->select('marks.obtain_total_mark, exams.exam_result_term');
    $CI->db->from('marks');
    $CI->db->join('exams', 'marks.exam_id = exams.id');
    $CI->db->where('marks.student_id', $student_id);
    $CI->db->where('marks.subject_id', $subject_id);
    $CI->db->where('marks.school_id', $school_id);
    //$CI->db->where('marks.academic_year_id', $academic_year_id);
    $CI->db->where('marks.exam_id = ', $exam_id); // Filter for exams with id less than $exam_id
    $CI->db->where('marks.status', 1); // Only get marks that are approved
    $query = $CI->db->get();
    $result = $query->result();

    // Iterate over each result and echo the obtain_total_mark and exam_result_term
    foreach ($result as $row) {
        echo '<td width="5%" align="center" style="font-size:10px">' . @number_format($row->obtain_total_mark, 2) . '</td>';
        //echo '<td width="5%" align="center" style="font-size:10px">' . $row->exam_result_term . '</td>';
    }
}












function get_current_exam_academic_year_exam_result_term($school_id, $student_id, $exam_id) {
    $CI =& get_instance();
    $CI->load->database();

    $CI->db->select('marks.obtain_total_mark, exams.exam_result_term');
    $CI->db->from('marks');
    $CI->db->join('exams', 'marks.exam_id = exams.id');
    $CI->db->where('marks.student_id', $student_id);
    //$CI->db->where('marks.subject_id', $subject_id);
    $CI->db->where('marks.school_id', $school_id);
    
    $CI->db->where('marks.exam_id =', $exam_id); // Filter for exams with id less than $exam_id
    $CI->db->where('marks.status', 1); // Only get marks that are approved
	//$CI->db->where('marks.academic_year_id', $academic_year_id);
	$CI->db->where('exams.exam_result_status', 'publish');
	$CI->db->group_by('exams.id', 'ASC');
    $query = $CI->db->get();
    $result = $query->result();

    // Get the exam result terms
    $exam_result_terms = get_exam_result_term();

    // Iterate over each result and echo the obtain_total_mark and exam_result_term
    foreach ($result as $row) {
        $term_name = isset($exam_result_terms[$row->exam_result_term]) ? $exam_result_terms[$row->exam_result_term] : '';
        echo '<td width="95" height="100%" align="center" bgcolor="skyblue" style="font-weight:bolder;color:#039; text-transform:uppercase">' . $term_name . ' <br>' . "100%"  . '</td>';
    }
}
	










function get_previous_exam_academic_year_exam_result_term($school_id, $student_id, $exam_id) {
    $CI =& get_instance();
    $CI->load->database();

    // Get the academic_year_id associated with the provided exam_id
    $CI->db->select('academic_year_id');
    $CI->db->from('exams');
    $CI->db->where('id', $exam_id);
    $query = $CI->db->get();
    $exam_academic_year = $query->row();

    if ($exam_academic_year) {
        $academic_year_id = $exam_academic_year->academic_year_id;

        // Use the academic_year_id to filter marks
        $CI->db->select('marks.obtain_total_mark, exams.exam_result_term');
        $CI->db->from('marks');
        $CI->db->join('exams', 'marks.exam_id = exams.id');
        $CI->db->where('marks.student_id', $student_id);
        $CI->db->where('marks.school_id', $school_id);
        $CI->db->where('exams.academic_year_id', $academic_year_id); // Filter for the specific academic year
        $CI->db->where('marks.exam_id <', $exam_id); // Filter for exams with id less than $exam_id
        $CI->db->where('marks.status', 1); // Only get marks that are approved
        $CI->db->where('exams.exam_result_status', 'publish');
        $CI->db->group_by('exams.id', 'ASC');
        $query = $CI->db->get();
        $result = $query->result();

        // Get the exam result terms
        $exam_result_terms = get_exam_result_term();
    
        // Iterate over each result and echo the obtain_total_mark and exam_result_term
        foreach ($result as $row) {
            $term_name = isset($exam_result_terms[$row->exam_result_term]) ? $exam_result_terms[$row->exam_result_term] : '';
            echo '<td width="95" height="100%" align="center" bgcolor="skyblue" style="font-weight:bolder;color:#039; text-transform:uppercase">' . $term_name . ' <br>' . "100%"  . '</td>';
        }
    
    }
}

	
	function get_real_exam_academic_year_exam_result_term($school_id, $student_id, $exam_id) {
    $CI =& get_instance();
    $CI->load->database();

    $CI->db->select('marks.obtain_total_mark, exams.exam_result_term');
    $CI->db->from('marks');
    $CI->db->join('exams', 'marks.exam_id = exams.id');
    $CI->db->where('marks.student_id', $student_id);
    //$CI->db->where('marks.subject_id', $subject_id);
    $CI->db->where('marks.school_id', $school_id);
    //$CI->db->where('marks.academic_year_id', $academic_year_id);
    $CI->db->where('marks.exam_id <', $exam_id); // Filter for exams with id less than $exam_id
    $CI->db->where('marks.status', 1); // Only get marks that are approved
    $CI->db->where('exams.exam_result_status', 'publish');
    $CI->db->group_by('exams.id', 'ASC');
    $query = $CI->db->get();
    $result = $query->result();

    // Get the exam result terms
    $exam_result_terms = get_exam_result_term();

    // Iterate over each result and echo the obtain_total_mark and exam_result_term
    foreach ($result as $row) {
        $term_name = isset($exam_result_terms[$row->exam_result_term]) ? $exam_result_terms[$row->exam_result_term] : '';
        echo '<td width="95" height="100%" align="center" style="font-weight:bolder;color:#039; text-transform:uppercase">' . $term_name . ' <br>' . "100%"  . '</td>';
    }
}

 function get_previous_subjects_marks_academic_year_total($school_id, $student_id, $subject_id, $exam_id) {
    $CI =& get_instance();
    $CI->load->database();
     $CI->db->select('SUM(obtain_total_mark) as total_mark');
	 $CI->db->select('SUM(obtain_total_mark)/ SUM(exam_total_mark)*100 as percentage_total_mark');
    $CI->db->where('student_id', $student_id);
    $CI->db->where('subject_id', $subject_id);
    $CI->db->where('school_id', $school_id);
   // $CI->db->where('academic_year_id', $academic_year_id);
    $CI->db->group_start();
    $CI->db->where('exam_id <', $exam_id); // Filter for exams with id less than $exam_id
    $CI->db->or_where('exam_id', $exam_id); // Filter for exams with id equal to $exam_id
    $CI->db->group_end();
    $CI->db->where('status', 1); // Only get marks that are approved
    $query = $CI->db->get('marks');
    $result = $query->row();

    // Echo the sum of obtain_total_mark
    echo '<td width="5%" align="center" style="font-size:10px">' . @number_format($result->total_mark, 2) . '</td>';
	
	 echo '<td width="5%" align="center" style="font-size:10px">' . @number_format($result->percentage_total_mark, 2) . '</td>';
	
	 
	 //cummulative_score Grade;
	 $cummulative_score = $result->percentage_total_mark;
	if ($cummulative_score >= 95) {
        echo '<td width="5%" align="center" style="font-size:10px">A+</td>';
    } 
	elseif ($cummulative_score >= 89 && $cummulative_score < 95) {
	echo '<td width="5%" align="center" style="font-size:10px">A</td>';
	} 
	elseif ($cummulative_score >= 80 && $cummulative_score < 89) {
		echo '<td width="5%" align="center" style="font-size:10px">B+</td>';
	} 
	
	elseif ($cummulative_score >= 70 && $cummulative_score < 80) {
		echo '<td width="5%" align="center" style="font-size:10px">B</td>';
	} 
	
	elseif ($cummulative_score >= 60 && $cummulative_score < 70) {
		echo '<td width="5%" align="center" style="font-size:10px">C</td>';
	} 
	elseif ($cummulative_score >= 50 && $cummulative_score < 60) {
		 echo '<td width="5%" align="center" style="font-size:10px">D</td>';
	} 
	elseif ($cummulative_score < 50) {
		echo '<td width="5%" align="center" style="font-size:10px">E</td>';
	} 
	
	
	else {
		echo '';
	}
	
	 //cummulative_score Remarks;
	 $cummulative_score = $result->percentage_total_mark;
	if ($cummulative_score >= 95) {
        echo '<td width="5%" align="center" style="font-size:10px">OUSTANDING</td>';
    } 
	elseif ($cummulative_score >= 89 && $cummulative_score < 95) {
	echo '<td width="5%" align="center" style="font-size:10px">EXCELLENT</td>';
	} 
	elseif ($cummulative_score >= 80 && $cummulative_score < 89) {
		echo '<td width="5%" align="center" style="font-size:10px">VERY GOOD</td>';
	} 
	
	elseif ($cummulative_score >= 70 && $cummulative_score < 80) {
		echo '<td width="5%" align="center" style="font-size:10px">GOOD</td>';
	} 
	
	elseif ($cummulative_score >= 60 && $cummulative_score < 70) {
		echo '<td width="5%" align="center" style="font-size:10px">CREDIT</td>';
	} 
	elseif ($cummulative_score >= 50 && $cummulative_score < 60) {
		 echo '<td width="5%" align="center" style="font-size:10px">PASS</td>';
	} 
	elseif ($cummulative_score < 50) {
		echo '<td width="5%" align="center" style="font-size:10px">FAIL</td>';
	} 
	
	
	else {
		echo '';
	}
}







 function get_previous_subjects_marks_academic_year_total_eval($school_id, $student_id, $subject_id, $exam_id) {
    $CI =& get_instance();
    $CI->load->database();
     $CI->db->select('SUM(obtain_total_mark) as total_mark');
	 $CI->db->select('SUM(obtain_total_mark)/ SUM(exam_total_mark)*100 as percentage_total_mark');
	$CI->db->where('student_id', $student_id);
    $CI->db->where('subject_id', $subject_id);
    $CI->db->where('school_id', $school_id);
   // $CI->db->where('academic_year_id', $academic_year_id);
    $CI->db->group_start();
    $CI->db->where('exam_id <', $exam_id); // Filter for exams with id less than $exam_id
    $CI->db->or_where('exam_id', $exam_id); // Filter for exams with id equal to $exam_id
    $CI->db->group_end();
    $CI->db->where('status', 1); // Only get marks that are approved
    $query = $CI->db->get('marks');
    $result = $query->row();

    // Echo the sum of obtain_total_mark
   
    echo '<td width="5%" align="center" style="font-size:10px">' . @number_format($result->total_mark, 2) . '</td>';
	
	 echo '<td width="5%" align="center" style="font-size:10px">' . @number_format($result->percentage_total_mark, 2) . '</td>';
	
	 //cummulative_score Grade;
	 $cummulative_score = $result->percentage_total_mark;
	if ($cummulative_score >= 95) {
        echo '<td bgcolor="#E3E3E3" width="5%" align="center" style="font-size:10px">A+</td>';
    } 
	elseif ($cummulative_score >= 89 && $cummulative_score < 95) {
	echo '<td bgcolor="#E3E3E3" width="5%" align="center" style="font-size:10px">A</td>';
	} 
	elseif ($cummulative_score >= 80 && $cummulative_score < 89) {
		echo '<td bgcolor="#E3E3E3" width="5%" align="center" style="font-size:10px">B+</td>';
	} 
	
	elseif ($cummulative_score >= 70 && $cummulative_score < 80) {
		echo '<td bgcolor="#E3E3E3" width="5%" align="center" style="font-size:10px">B</td>';
	} 
	
	elseif ($cummulative_score >= 60 && $cummulative_score < 70) {
		echo '<td bgcolor="#E3E3E3" width="5%" align="center" style="font-size:10px">C</td>';
	} 
	elseif ($cummulative_score >= 50 && $cummulative_score < 60) {
		 echo '<td bgcolor="#E3E3E3" width="5%" align="center" style="font-size:10px">D</td>';
	} 
	elseif ($cummulative_score < 50) {
		echo '<td bgcolor="#E3E3E3" width="5%" align="center" style="font-size:10px">E</td>';
	} 
	
	
	else {
		echo '';
	}
	
	 //cummulative_score Remarks;
	 $cummulative_score = $result->percentage_total_mark;
	if ($cummulative_score >= 95) {
        echo '<td width="5%" align="center" style="font-size:10px">W.A.E.L</td>';
    } 
	elseif ($cummulative_score >= 89 && $cummulative_score < 95) {
	echo '<td width="5%" align="center" style="font-size:10px">W.A.E.L</td>';
	} 
	elseif ($cummulative_score >= 80 && $cummulative_score < 89) {
		echo '<td width="5%" align="center" style="font-size:10px">W.W.E.L</td>';
	} 
	
	elseif ($cummulative_score >= 70 && $cummulative_score < 80) {
		echo '<td width="5%" align="center" style="font-size:10px">W.W.E.L</td>';
	} 
	
	elseif ($cummulative_score >= 60 && $cummulative_score < 70) {
		echo '<td width="5%" align="center" style="font-size:10px">W.B.E.L</td>';
	} 
	elseif ($cummulative_score >= 50 && $cummulative_score < 60) {
		 echo '<td width="5%" align="center" style="font-size:10px">W.B.E.L</td>';
	} 
	elseif ($cummulative_score < 50) {
		echo '<td width="5%" align="center" style="font-size:10px">S.N.E.S</td>';
	} 
	
	
	else {
		echo '';
	}
}














if (!function_exists('calculateAttendanceSum')) {
    function calculateAttendanceSum($academic_year_id, $exam_id, $student_id)
    {
        // Get CodeIgniter instance
        $CI = &get_instance();

        // Load the database library
        $CI->load->database();

        // Query to calculate the total sum of "P" and "A" for each student
        $query = $CI->db->select('student_id')
            ->select('SUM(day_1 = "P") AS present_day_1')
            ->select('SUM(day_1 = "A") AS absent_day_1')
            ->select('SUM(day_2 = "P") AS present_day_2')
            ->select('SUM(day_2 = "A") AS absent_day_2')
			 ->select('SUM(day_3 = "P") AS present_day_3')
            ->select('SUM(day_3 = "A") AS absent_day_3')
			->select('SUM(day_4 = "P") AS present_day_4')
            ->select('SUM(day_4 = "A") AS absent_day_4')
			->select('SUM(day_5 = "P") AS present_day_5')
            ->select('SUM(day_5 = "A") AS absent_day_5')
			->select('SUM(day_6 = "P") AS present_day_6')
            ->select('SUM(day_6 = "A") AS absent_day_6')
			->select('SUM(day_7 = "P") AS present_day_7')
            ->select('SUM(day_7 = "A") AS absent_day_7')
			->select('SUM(day_8 = "P") AS present_day_8')
            ->select('SUM(day_8 = "A") AS absent_day_8')
			->select('SUM(day_9 = "P") AS present_day_9')
            ->select('SUM(day_9 = "A") AS absent_day_9')
			->select('SUM(day_10 = "P") AS present_day_10')
            ->select('SUM(day_10 = "A") AS absent_day_10')
			->select('SUM(day_11 = "P") AS present_day_11')
            ->select('SUM(day_11 = "A") AS absent_day_11')
			->select('SUM(day_12 = "P") AS present_day_12')
            ->select('SUM(day_12 = "A") AS absent_day_12')
			->select('SUM(day_13 = "P") AS present_day_13')
            ->select('SUM(day_13 = "A") AS absent_day_13')
			->select('SUM(day_14 = "P") AS present_day_14')
            ->select('SUM(day_14 = "A") AS absent_day_14')
			->select('SUM(day_15 = "P") AS present_day_15')
            ->select('SUM(day_15 = "A") AS absent_day_15')
			->select('SUM(day_16 = "P") AS present_day_16')
            ->select('SUM(day_16 = "A") AS absent_day_16')
			->select('SUM(day_17 = "P") AS present_day_17')
            ->select('SUM(day_17 = "A") AS absent_day_17')
			->select('SUM(day_18 = "P") AS present_day_18')
            ->select('SUM(day_18 = "A") AS absent_day_18')
			->select('SUM(day_19 = "P") AS present_day_19')
            ->select('SUM(day_19 = "A") AS absent_day_19')
			->select('SUM(day_20 = "P") AS present_day_20')
            ->select('SUM(day_20 = "A") AS absent_day_20')
			->select('SUM(day_21 = "P") AS present_day_21')
            ->select('SUM(day_21 = "A") AS absent_day_21')
			->select('SUM(day_22 = "P") AS present_day_22')
            ->select('SUM(day_22 = "A") AS absent_day_22')
			->select('SUM(day_23 = "P") AS present_day_23')
            ->select('SUM(day_23 = "A") AS absent_day_23')
			->select('SUM(day_24 = "P") AS present_day_24')
            ->select('SUM(day_24 = "A") AS absent_day_24')
			->select('SUM(day_25 = "P") AS present_day_25')
            ->select('SUM(day_25 = "A") AS absent_day_25')
			->select('SUM(day_26 = "P") AS present_day_26')
            ->select('SUM(day_26 = "A") AS absent_day_26')
			->select('SUM(day_27 = "P") AS present_day_27')
            ->select('SUM(day_27 = "A") AS absent_day_27')
			->select('SUM(day_28 = "P") AS present_day_28')
            ->select('SUM(day_28 = "A") AS absent_day_28')
			->select('SUM(day_29 = "P") AS present_day_29')
            ->select('SUM(day_29 = "A") AS absent_day_29')
			->select('SUM(day_30 = "P") AS present_day_30')
            ->select('SUM(day_30 = "A") AS absent_day_30')
			->select('SUM(day_31 = "P") AS present_day_31')
            ->select('SUM(day_31 = "A") AS absent_day_31')
            // Continue adding similar selects for each day of the month (day_3, day_4, ..., day_31)
            ->from('student_attendances')
			->join('exams', 'exams.id = student_attendances.exam_id')
            ->where('exams.academic_year_id', $academic_year_id)
			 ->where('student_attendances.exam_id', $exam_id)
			  ->where('student_attendances.student_id', $student_id)
            ->group_by('student_id')
            ->get();

        // Retrieve the results
        $results = $query->result();

        // Create an array to store attendance sums
        $attendanceSums = [];

        // Loop through the results and store the sums for each student
        foreach ($results as $result) {
            $studentId = $result->student_id;
            $attendanceSum = [
                'present' => 0,
                'absent' => 0
            ];

            for ($day = 1; $day <= 31; $day++) {
                @$attendanceSum['present'] += $result->{'present_day_' . $day}*2;//IF ATTENDANCE IS TAKING TWICE IN A DAY(*2)
                @$attendanceSum['absent'] += $result->{'absent_day_' . $day}*2; //IF ATTENDANCE IS TAKING TWICE IN A DAY (*2)

            }

            $attendanceSums[$studentId] = $attendanceSum;
        }

        return $attendanceSums;
    }
}


if (!function_exists('get_exams')) {
    function get_exams()
    {
        $CI = &get_instance();
        $CI->load->database();

        $CI->db->select('id, title');
        $query = $CI->db->get('exams');

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return array(); // Return an empty array if no exams found;
        }
    }
}







// DASH BOARD RUNNING YEAR INCOME

if (!function_exists('calculate_total_income')) {
    function calculate_total_income()
    {
        $CI = &get_instance();
        $CI->load->database();

        $query = $CI->db->select_sum('amount')
                        ->from('transactions')
                        ->join('academic_years', 'transactions.academic_year_id = academic_years.id')
                        ->where('academic_years.is_running', 1)
                        ->get();

        if ($query->num_rows() > 0) {
            return $query->row()->amount;
        }

        return 0;
    }
}



function get_class_name_by_custom_invoice_id($custom_invoice_id) {
    // Assuming you have access to the database connection
    $CI =& get_instance();
    $CI->load->database();

    $query = $CI->db->select('c.name')
        ->from('invoices i')
        ->join('classes c', 'i.class_id = c.id', 'left')
        ->where('i.custom_invoice_id', $custom_invoice_id)
        ->get();

    if ($query->num_rows() > 0) {
        $result = $query->row();
        return $result->name;
    }

    return '';
}





// application/helpers/util_helper.php

if (!function_exists('get_class_name_by_invoice_id')) {
    function get_class_name_by_invoice_id($invoice_id)
    {
        $ci =& get_instance();
        $ci->load->database();

        $ci->db->select('classes.name AS class_name');
        $ci->db->join('classes', 'invoices.class_id = classes.id', 'left');
        $ci->db->where('invoices.custom_invoice_id', $invoice_id);
        $result = $ci->db->get('invoices')->row();

        if ($result) {
            return $result->class_name;
        } else {
            return '';
        }
    }
}


if (!function_exists('get_student_class_and_section')) {
    function get_student_class_and_section($academic_year_id, $student_id)
    {
        $CI =& get_instance();
        $CI->load->database();

        $query = $CI->db->select('enrollments.class_id, enrollments.section_id, classes.name as class_name, sections.name as section_name')
                       ->from('enrollments')
                       ->join('classes', 'enrollments.class_id = classes.id')
                       ->join('sections', 'enrollments.section_id = sections.id')
                       ->where('enrollments.academic_year_id', $academic_year_id)
                       ->where('enrollments.student_id', $student_id)
                       ->where('enrollments.status', '1')
                       ->get();

        if ($query->num_rows() > 0) {
            $result = $query->row();

            // Get the total number of students in the section using a subquery
            $section_id = $result->section_id;
            $count_query = $CI->db->select('COUNT(*) as total_students')
                                  ->from('enrollments')
                                  ->where('academic_year_id', $academic_year_id)
                                  ->where('section_id', $section_id)
                                  ->where('status', '1')
                                  ->get();
            $count_result = $count_query->row();
            $total_students_in_section = $count_result->total_students;

            $classAndSection = $result->class_name . ' ' . $result->section_name;
            return "$classAndSection";
        } else {
            return "Not Enrolled";
        }
    }
}
if (!function_exists('get_student_class_and_section_all_students')) {
    function get_student_class_and_section_all_students($academic_year_id, $class_id, $section_id)
    {
        $CI =& get_instance();
        $CI->load->database();

        $query = $CI->db->select('classes.name as class_name, sections.name as section_name')
                       ->from('enrollments')
                       ->join('classes', 'enrollments.class_id = classes.id')
                       ->join('sections', 'enrollments.section_id = sections.id')
                       ->where('enrollments.academic_year_id', $academic_year_id)
                       ->where('enrollments.class_id', $class_id)
                       ->where('enrollments.section_id', $section_id)
                       ->where('enrollments.status', '1')
                       ->get();

        if ($query->num_rows() > 0) {
            $result = $query->row();

            // Count total students in this class+section
            $count_query = $CI->db->select('COUNT(*) as total_students')
                                  ->from('enrollments')
                                  ->where('academic_year_id', $academic_year_id)
                                  ->where('class_id', $class_id)
                                  ->where('section_id', $section_id)
                                  ->where('status', '1')
                                  ->get();

            $count_result = $count_query->row();
            $total_students_in_section = $count_result->total_students;

            return $result->class_name . ' ' . $result->section_name ;
        } else {
            return "No records found";
        }
    }
}



if (!function_exists('get_total_student_class_and_section')) {
    function get_total_student_class_and_section($academic_year_id, $student_id)
    {
        $CI =& get_instance();
        $CI->load->database();

        $query = $CI->db->select('enrollments.class_id, enrollments.section_id, classes.name as class_name, sections.name as section_name')
                       ->from('enrollments')
                       ->join('classes', 'enrollments.class_id = classes.id')
                       ->join('sections', 'enrollments.section_id = sections.id')
                       ->where('enrollments.academic_year_id', $academic_year_id)
                       ->where('enrollments.student_id', $student_id)
                       ->where('enrollments.status', '1')
                       ->get();

        if ($query->num_rows() > 0) {
            $result = $query->row();

            // Get the total number of students in the section using a subquery
            $section_id = $result->section_id;
            $count_query = $CI->db->select('COUNT(*) as total_students')
                                  ->from('enrollments')
                                  ->where('academic_year_id', $academic_year_id)
                                  ->where('section_id', $section_id)
                                  ->where('status', '1')
                                  ->get();
            $count_result = $count_query->row();
            $total_students_in_section = $count_result->total_students;

            $classAndSection = $result->class_name . ' ' . $result->section_name;
            return "$total_students_in_section";
        } else {
            return "Not Enrolled";
        }
    }
}

if (!function_exists('get_total_students_in_section')) {
    function get_total_students_in_section($section_id) {
        $ci = & get_instance();

        $ci->db->select('COUNT(*) AS cntr');
        $ci->db->from('enrollments');
        $ci->db->join('students', 'students.id = enrollments.student_id', 'left');
        $ci->db->where('section_id', $section_id);
        //$ci->db->where('academic_year_id', $academic_year_id);
        $ci->db->where('status_type', "regular");
        return $ci->db->get()->row()->cntr;
    }
}


function get_exam_results_details($exam_id, $student_id) {
    $CI =& get_instance();
    $CI->load->database();

    $CI->db->select('*');
    $CI->db->from('exam_results');
    $CI->db->join('exams', 'exams.id = exam_results.exam_id', 'left');
    $CI->db->where('exam_id', $exam_id);
    $CI->db->where('student_id', $student_id);

    $query = $CI->db->get();
    $result = $query->row_array();

    return $result;
}








if (!function_exists('get_exam_results_details_midterm')) {

    function get_exam_results_details_midterm($school_id, $exam_id, $class_id, $section_id, $student_id) {
        $ci = & get_instance();
       
		 $ci->db->select('SUM((M.written_obtain+M.tutorial_obtain+M.practical_obtain)) AS mid_total_obtain');
		$ci->db->select('SUM((M.written_mark+M.tutorial_mark+M.practical_mark)) AS mid_total_mark');
		 $ci->db->select('COUNT(M.id) AS total_subject');
        $ci->db->from('marks AS M');       
        $ci->db->where('M.school_id', $school_id);
       // $ci->db->where('M.academic_year_id', $academic_year_id);
        $ci->db->where('M.exam_id', $exam_id);
        $ci->db->where('M.class_id', $class_id);
        $ci->db->where('M.section_id', $section_id);
        $ci->db->where('M.student_id', $student_id);  
        return  $ci->db->get()->row();
     // echo $ci->db->last_query();
    }
}














if (!function_exists('get_student_exam_results_average')) {

    function get_student_exam_results_average($school_id, $academic_year_id, $exam_id, $class_id, $section_id = null, $student_id = null) {
        $ci = & get_instance();
      	$ci->db->select('SUM(M.obtain_total_mark) AS section_average');
		$ci->db->select('SUM(M.exam_total_mark) AS section_Maverage');
        $ci->db->from('marks AS M');       
        $ci->db->where('M.school_id', $school_id);
        $ci->db->where('M.exam_id', $exam_id);
        $ci->db->where('M.class_id', $class_id);
		$ci->db->where_not_in('M.obtain_total_mark', '0');
        if($section_id){
        $ci->db->where('M.section_id', $section_id);
        }
       $ci->db->where('M.rel_subject_id', 0);
        $ci->db->where('M.academic_year_id', $academic_year_id);
        return $ci->db->get()->row();
        
    }
	
	
	
	if (!function_exists('calculate_student_average')) {
    function calculate_student_average($school_id, $exam_id, $class_id, $section_id) {
        $CI =& get_instance();
        $CI->load->database();

        $CI->db->select('SUM(total_obtain_mark) AS total_obtain_sum, SUM(total_mark) AS total_mark_sum');
        $CI->db->from('exam_results');
        $CI->db->where('school_id', $school_id);
       // $CI->db->where('academic_year_id', $academic_year_id);
		$CI->db->where('exam_id', $exam_id);
        $CI->db->where('class_id', $class_id);
        $CI->db->where('section_id', $section_id);

        $query = $CI->db->get();
        $result = $query->row_array();

        if ($result['total_mark_sum'] > 0) {
            $student_average = ($result['total_obtain_sum'] / $result['total_mark_sum']) * 100;
            return $student_average;
        } else {
            return 0;
        }
    }
}


	if (!function_exists('calculate_student_cummulative_average')) {
    function calculate_student_cummulative_average($school_id, $class_id, $section_id) {
        $CI =& get_instance();
        $CI->load->database();

        $CI->db->select('SUM(total_obtain_mark) AS total_obtain_sum, SUM(total_mark) AS total_mark_sum');
        $CI->db->from('final_results');
        $CI->db->where('school_id', $school_id);
       // $CI->db->where('academic_year_id', $academic_year_id);
		// $CI->db->where('exam_id', $exam_id);
        $CI->db->where('class_id', $class_id);
        $CI->db->where('section_id', $section_id);

        $query = $CI->db->get();
        $result = $query->row_array();

        if ($result['total_mark_sum'] > 0) {
            $student_average = ($result['total_obtain_sum'] / $result['total_mark_sum']) * 100;
            return $student_average;
        } else {
            return 0;
        }
    }
}








if (!function_exists('get_exam_wise_markt_exam_results')) {

    function get_exam_wise_markt_exam_results($school_id, $exam_id, $class_id, $section_id = null, $student_id = null) {
        $ci = & get_instance();
        
		$ci->db->select('*');
		$ci->db->from('marks AS M');        
        //$ci->db->join('subjects AS S', 'S.id = M.subject_id', 'left'); 
	    $ci->db->where('M.school_id', $school_id);
        $ci->db->where('M.class_id', $class_id);
		$ci->db->where_not_in('M.obtain_total_mark', '0');
		
		
        //Added by D-Ultimate
        $ci->db->where('M.rel_subject_id', 0);
        if($section_id){
            $ci->db->where('M.section_id', $section_id);
        }
        $ci->db->where('M.student_id', $student_id);
        $ci->db->where('M.exam_id', $exam_id);  
		
		if(@$academic_year_id){
		$ci->db->where('M.academic_year_id', $academic_year_id);
		}		
        return $ci->db->get()->row();  
        // $ci->db->last_query();
    }
}


// GENERATING ACADEMIC YEAR DROP DOWN LIST

if (!function_exists('get_academic_years_dropdown')) {
    function get_academic_years_dropdown() {
        $CI = &get_instance();
        $CI->load->database(); // Load the database if not loaded already
        $academic_years = $CI->db->get('academic_years')->result_array();

        $options = array();
        foreach ($academic_years as $year) {
            $is_running = ($year['is_running'] == '1') ? ' (Running Year)' : '';
            $options[$year['id']] = $year['session_year'] . $is_running;
        }

        return $options;
    }
}

if (!function_exists('get_running_academic_year_name')) {
    function get_running_academic_year_name() {
        $CI = &get_instance();
        $CI->load->database(); // Load the database if not loaded already
        
        $CI->db->where('is_running', '1');
        $query = $CI->db->get('academic_years');
        
        if ($query->num_rows() > 0) {
            $row = $query->row();
            return $row->session_year;
        }
        
        return '';
    }
}

	
		
// To get the running year academic name

if (!function_exists('get_running_academic_year_name')) {
    function get_running_academic_year_name() {
        $CI = &get_instance();
        $CI->load->database(); // Load the database if not loaded already
        
        $CI->db->where('is_running', '1');
        $query = $CI->db->get('academic_years');
        
        if ($query->num_rows() > 0) {
            $row = $query->row();
            return $row->session_year;
        }
        
        return '';
    }
}



function get_exam_cummulative_details($student_id, $class_id, $section_id) {
    $CI =& get_instance();
    $CI->load->database();

    $CI->db->select('*');
    $CI->db->from('final_results');
	//$CI->db->join('exams', 'exams.id = exam_results.exam_id', 'left');
    //$CI->db->join('classes', 'classes.id = exam_results.class_id', 'left');
	//$CI->db->join('sections', 'sections.id = exam_results.section_id', 'left');
   //$CI->db->join('teachers', 'teachers.id = exam_results.teacher_id', 'left');
    //$CI->db->where('exam_id', $exam_id);
	 $CI->db->where('class_id', $class_id);
    $CI->db->where('section_id', $section_id);	 	
    $CI->db->where('student_id', $student_id); // Add this line to filter by student_id

    $query = $CI->db->get();
    $result = $query->row_array();

    return $result; // Return the result for the specific student
	
	
}












if (!function_exists('get_student_subject_marks')) {
    function get_student_subject_marks($class_id, $section_id, $exam_id) {
        $CI = &get_instance();
        $CI->load->database();

        $query = $CI->db->select('*, subjects.name')
                        ->from('marks')
                        ->join('subjects', 'subjects.id = marks.subject_id', 'left')
                        ->where('marks.class_id', $class_id)
                        ->where('marks.section_id', $section_id)
                        ->where('exam_id', $exam_id)
						 ->where_not_in('obtain_total_mark', 0)
                        // Add academic_year_id condition if needed
                        ->get();

        $result = array();

        foreach ($query->result() as $row) {
            if (!isset($result[$row->student_id])) {
                $result[$row->student_id] = array();
            }

            $result[$row->student_id][$row->subject_id] = array(
                'subject_name' => $row->name,
				 'written_obtain' => $row->written_obtain,
				 'tutorial_obtain' => $row->tutorial_obtain,
				 'viva_obtain' => $row->viva_obtain,
                'obtain_total_mark' => $row->obtain_total_mark
            );
        }

        return $result;
    }
}

}

//STUDENT COUNT PER SECTION

if (!function_exists('get_total_students_in_class_and_section_for_exam')) {
    function get_total_students_in_class_and_section_for_exam($class_id, $section_id, $exam_id)
    {
        $CI =& get_instance();
        $CI->load->database();

        $query = $CI->db->select('enrollments.class_id, enrollments.section_id, classes.name as class_name, sections.name as section_name')
            ->from('enrollments')
            ->join('classes', 'enrollments.class_id = classes.id')
            ->join('sections', 'enrollments.section_id = sections.id')
            //->where('enrollments.academic_year_id', $academic_year_id)
            ->where('enrollments.class_id', $class_id)
            ->where('enrollments.section_id', $section_id)
            ->where('enrollments.status', '1')
            ->get();

        if ($query->num_rows() > 0) {
            $result = $query->row();

            $classAndSection = $result->class_name . ' ' . $result->section_name;

            // Get the total number of students in the class and section for the given exam_id
            $count_query = $CI->db->select('COUNT(*) as total_students')
                ->from('exam_results')
               //->where('academic_year_id', $academic_year_id)
                ->where('class_id', $class_id)
                ->where('section_id', $section_id)
                ->where('exam_id', $exam_id)
                ->where('status', '1')
                ->get();
            $count_result = $count_query->row();
            $total_students_in_class_and_section_for_exam = $count_result->total_students;

            return $total_students_in_class_and_section_for_exam;
        } else {
            return "Not Enrolled";
        }
    }
}


// Function to get the list of students based on selected academic year, class, and section
function get_students_by_filter($academic_year_id, $class_id, $section_id, $guardian_user_id) {
    $CI =& get_instance();
    $CI->load->model('student_model'); // Load the appropriate model for students
    
    // Call a function in the model to fetch the students
    $students = $CI->student_model->get_students_by_filter($academic_year_id, $class_id, $section_id, $guardian_user_id);
    
    return $students;
}


// application/helpers/custom_helper.php

if (!function_exists('get_students_by_guardian_id')) {
    function get_students_by_guardian_id($guardian_id) {
        // Load the necessary model if not already loaded
        $CI = &get_instance();
        $CI->load->model('your_students_model'); // Replace 'your_students_model' with the actual model name

        // Retrieve the list of students based on guardian_id
        $students = $CI->your_students_model->get_students_by_guardian_id($guardian_id); // Replace with your model method

        return $students;
    }
}



//GETTING CBT EXAM SCORES FOR MARKS

if (!function_exists('getTotalObtainMark')) {
    function getTotalObtainMark($exam_id, $subject_id, $student_id, $class_id, $section_id, $academic_year_id) {
        $CI = &get_instance();
        $CI->load->database(); // Load the database library

 $query = $CI->db->select('total_obtain_mark')
                        ->from('exam_taken_exams')
                        ->join('exams', 'exams.id = exam_taken_exams.title', 'left')
                        //->join('exam_online_exams', 'exam_online_exams.title = exams.id', 'left')
                        ->where('exams.id', $exam_id)
                        ->where('exam_taken_exams.subject_id', $subject_id)
                        ->where('exam_taken_exams.student_id', $student_id)
                        ->where('exam_taken_exams.class_id', $class_id)
                        ->where('exam_taken_exams.section_id', $section_id)
                        ->where('exams.academic_year_id', $academic_year_id)
                         ->where('exam_taken_exams.exam_type', "1")
                        ->get();

        if ($query->num_rows() > 0) {
            $row = $query->row();
            return $row->total_obtain_mark;
        } else {
            return ''; // You can change this to handle no results
        }
    }
}


if (!function_exists('getTotalObtainMarkca2')) {
    function getTotalObtainMarkca2($exam_id, $subject_id, $student_id, $class_id, $section_id, $academic_year_id) {
        $CI = &get_instance();
        $CI->load->database(); // Load the database library

        $query = $CI->db->select('total_obtain_mark')
                        ->from('exam_taken_exams')
                        ->join('exams', 'exams.id = exam_taken_exams.title', 'left')
                        //->join('exam_online_exams', 'exam_online_exams.title = exams.id', 'left')
                        ->where('exams.id', $exam_id)
                        ->where('exam_taken_exams.subject_id', $subject_id)
                        ->where('exam_taken_exams.student_id', $student_id)
                        ->where('exam_taken_exams.class_id', $class_id)
                        ->where('exam_taken_exams.section_id', $section_id)
                        ->where('exams.academic_year_id', $academic_year_id)
                         ->where('exam_taken_exams.exam_type', "2")
                        ->get();

        if ($query->num_rows() > 0) {
            $row = $query->row();
            return $row->total_obtain_mark;
        } else {
            return ''; // You can change this to handle no results
        }
    }
}

 

if (!function_exists('getTotalObtainMarkca3')) {
    function getTotalObtainMarkca3($exam_id, $subject_id, $student_id, $class_id, $section_id, $academic_year_id) {
        $CI = &get_instance();
        $CI->load->database(); // Load the database library

       $query = $CI->db->select('total_obtain_mark')
                        ->from('exam_taken_exams')
                        ->join('exams', 'exams.id = exam_taken_exams.title', 'left')
                        //->join('exam_online_exams', 'exam_online_exams.title = exams.id', 'left')
                        ->where('exams.id', $exam_id)
                        ->where('exam_taken_exams.subject_id', $subject_id)
                        ->where('exam_taken_exams.student_id', $student_id)
                        ->where('exam_taken_exams.class_id', $class_id)
                        ->where('exam_taken_exams.section_id', $section_id)
                        ->where('exams.academic_year_id', $academic_year_id)
                         ->where('exam_taken_exams.exam_type', "3")
                        ->get();

        if ($query->num_rows() > 0) {
            $row = $query->row();
            return $row->total_obtain_mark;
        } else {
            return ''; // You can change this to handle no results
        }
    }
}






if (!function_exists('getTotalObtainMarkca4')) {
    function getTotalObtainMarkca4($exam_id, $subject_id, $student_id, $class_id, $section_id, $academic_year_id) {
        $CI = &get_instance();
        $CI->load->database(); // Load the database library

       $query = $CI->db->select('total_obtain_mark')
                        ->from('exam_taken_exams')
                        ->join('exams', 'exams.id = exam_taken_exams.title', 'left')
                        //->join('exam_online_exams', 'exam_online_exams.title = exams.id', 'left')
                        ->where('exams.id', $exam_id)
                        ->where('exam_taken_exams.subject_id', $subject_id)
                        ->where('exam_taken_exams.student_id', $student_id)
                        ->where('exam_taken_exams.class_id', $class_id)
                        ->where('exam_taken_exams.section_id', $section_id)
                        ->where('exams.academic_year_id', $academic_year_id)
                         ->where('exam_taken_exams.exam_type', "4")
                        ->get();

        if ($query->num_rows() > 0) {
            $row = $query->row();
            return $row->total_obtain_mark;
        } else {
            return ''; // You can change this to handle no results
        }
    }
}


if (!function_exists('getTotalObtainMark_exam')) {
    function getTotalObtainMark_exam($exam_id, $subject_id, $student_id, $class_id, $section_id, $academic_year_id) {
        $CI = &get_instance();
        $CI->load->database(); // Load the database library

       $query = $CI->db->select('total_obtain_mark')
                        ->from('exam_taken_exams')
                        ->join('exams', 'exams.id = exam_taken_exams.title', 'left')
                        //->join('exam_online_exams', 'exam_online_exams.title = exams.id', 'left')
                        ->where('exams.id', $exam_id)
                        ->where('exam_taken_exams.subject_id', $subject_id)
                        ->where('exam_taken_exams.student_id', $student_id)
                        ->where('exam_taken_exams.class_id', $class_id)
                        ->where('exam_taken_exams.section_id', $section_id)
                        ->where('exams.academic_year_id', $academic_year_id)
                         ->where('exam_taken_exams.exam_type', "5")
                        ->get();

        if ($query->num_rows() > 0) {
            $row = $query->row();
            return $row->total_obtain_mark;
        } else {
            return ''; // You can change this to handle no results
        }
    }
}







if (!function_exists('get_student_marks')) {
    function get_student_marks($student_id, $exam_id, $class_id, $section_id)
    {
        // Load the database library if not already loaded
        $CI =& get_instance();
        $CI->load->database();

        $CI->db->select('*');
        $CI->db->where('student_id', $student_id);
        $CI->db->where('exam_id', $exam_id);
        $CI->db->where('class_id', $class_id);
        $CI->db->where('section_id', $section_id);
        $query = $CI->db->get('marks');

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return array(); // Return an empty array if no records found
        }
    }
}




//Added by D-Ultimate
if (!function_exists('get_stateexam')) {

    function get_stateexam() {
        $ci = & get_instance();
        $ci->db->select('*');
        $ci->db->from('academic_years');            
        $ci->db->where('status', 1); 
        $ci->db->order_by("id", "DESC");
        return $ci->db->get()->result();
    }

}

//FUNCTION RO SELECT EXAM TILTE FROM A DROP DOWN LIST

if (!function_exists('get_exam_titles_dropdown')) {
    /**
     * Get exam titles from the 'exams' table and generate a dropdown list.
     *
     * @param string $selectedTitle The title to be selected in the dropdown (optional).
     * @return string Dropdown list HTML.
     */
    function get_exam_titles_dropdown($selectedTitle = '') {
        $CI = &get_instance();
        $CI->load->database();

        // Replace 'your_table_prefix_' with your actual table prefix if applicable.
        $table_name = $CI->db->dbprefix('exams');
        
        $query = $CI->db->select('id, title')->get($table_name);

        if ($query->num_rows() > 0) {
            $dropdown = '<select name="exam_title" id="exam_title">';
            $dropdown .= '<option value="">Select Title</option>';
            foreach ($query->result() as $row) {
                $selected = ($selectedTitle == $row->title) ? 'selected' : '';
                $dropdown .= '<option value="' . $row->id . '" ' . $selected . '>' . $row->title . '</option>';
            }
            $dropdown .= '</select>';
            return $dropdown;
        } else {
            return '<select name="exam_title" id="exam_title"><option value="">No Titles Found</option></select>';
        }
    }
} 




if (!function_exists('get_assignments_by_class')) {
    /**
     * Get Assignments by Class ID
     *
     * @param int $class_id
     * @param int $academic_year_id
     * @param int $school_id
     * @return array
     */
    function get_assignments_by_class($class_id, $academic_year_id, $school_id) {
        $CI =& get_instance();
        $CI->db->select('A.id, A.title, A.submission_date');
        $CI->db->from('assignments AS A');
        $CI->db->where('A.class_id', $class_id);
        $CI->db->where('A.academic_year_id', $academic_year_id);
        $CI->db->where('A.school_id', $school_id);
        $CI->db->where('A.status', 1); // Only active assignments
        $CI->db->order_by('A.submission_date', 'DESC');
        
        $query = $CI->db->get();
        return $query->result_array();
    }
}




/*STRICT DATA ACCESS END*/