<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ai03f_model extends CI_Model {

    private $device_ip   = "192.168.1.150"; // Replace with your Ai03-F device IP
    private $device_port = 5005;

    /**
     * Generic JSON-RPC request to Ai03-F
     */
    private function send_request($method, $params = [], $request_id = 1) {
        $url = "http://{$this->device_ip}:{$this->device_port}/action";

        $payload = [
            "id"     => $request_id,
            "method" => $method,
            "params" => $params
        ];

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

        $response = curl_exec($ch);

        if (curl_errno($ch)) {
            log_message('error', 'Ai03-F API error: ' . curl_error($ch));
            return false;
        }

        curl_close($ch);

        return json_decode($response, true);
    }

    /**
     * Get current device config
     */
    public function get_device_config() {
        return $this->send_request("get_device_config");
    }

    /**
     * Push new device config
     */
    public function set_device_config($config) {
        return $this->send_request("set_device_config", $config);
    }

    /**
     * Example: reboot device
     */
    public function reboot_device() {
        return $this->send_request("device_reboot");
    }
}
