<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Student_Model extends MY_Model {
    
    function __construct() {
        parent::__construct();
    }
    
    public function get_student_list($school_id = null, $class_id = null, $section_id = null, $academic_year_id = null, $status_type = null){
        
        $this->db->select('S.*, E.roll_no, E.class_id, E.section_id, U.username, U.role_id,  C.name AS class_name, SE.name AS section');
        $this->db->from('enrollments AS E');
        $this->db->join('students AS S', 'S.id = E.student_id', 'left');
        $this->db->join('users AS U', 'U.id = S.user_id', 'left');
        $this->db->join('classes AS C', 'C.id = E.class_id', 'left');
        $this->db->join('sections AS SE', 'SE.id = E.section_id', 'left');
        $this->db->where('E.academic_year_id', $academic_year_id);       
        $this->db->where('E.class_id', $class_id);
        
        if ($section_id) {
            $this->db->where('E.section_id', $section_id);
        }
        
        if ($this->session->userdata('role_id') == TEACHER) {
            $this->db->where('SE.teacher_id', $this->session->userdata('profile_id'));
        }
        if ($status_type) {
            $this->db->where('S.status_type', $status_type);
        }
        
        $this->db->where('S.school_id', $school_id);
       
        return $this->db->get()->result();
    }    
    
    
    // Get the running academic year (is_running = 1)
    public function get_running_academic_year($school_id = null) {
        $this->db->from('academic_years');
        $this->db->where('is_running', 1);
        if ($school_id) {
            $this->db->where('school_id', $school_id);
        }
        $query = $this->db->get();
        return $query->row(); // returns a single row (object)
    }

    // Get exams for a given academic year
    public function get_exams_by_year($academic_year_id, $school_id = null) {
        $this->db->from('exams');
        $this->db->where('academic_year_id', $academic_year_id);
        if ($school_id) {
            $this->db->where('school_id', $school_id);
        }
        $query = $this->db->get();
        return $query->result(); // returns an array of exams
    }

    public function get_latest_exam_by_year($academic_year_id, $school_id = null) {
        $this->db->from('exams');
        $this->db->where('academic_year_id', $academic_year_id);
        if ($school_id) {
            $this->db->where('school_id', $school_id);
        }
        $this->db->order_by('id', 'DESC'); // highest id = latest
        $this->db->limit(1);
        $query = $this->db->get();
        return $query->row(); // single exam object
    }

    public function get_student_attendance_list($school_id, $academic_year_id, $class_id, $section_id = null){
         
        $this->db->select('E.roll_no,  S.id, S.name');
        $this->db->from('enrollments AS E');        
        $this->db->join('students AS S', 'S.id = E.student_id', 'left');
        $this->db->where('E.academic_year_id', $academic_year_id);       
        $this->db->where('E.class_id', $class_id);     
        if ($section_id) {
            $this->db->where('E.section_id', $section_id); 
        }
        $this->db->where('S.school_id', $school_id);        
        if ($this->session->userdata('role_id') == GUARDIAN) {
            $this->db->where('S.guardian_id', $this->session->userdata('profile_id'));
        }
        return $this->db->get()->result();    
    } 


    /* ==========================================================
     * AI03-f INTEGRATION
     * ========================================================== */
    
    private function call_ai03f_api($endpoint, $payload = [], $method = 'POST') {
        $ch = curl_init();
    
        curl_setopt($ch, CURLOPT_URL, $endpoint);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    
        if ($method === 'POST') {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
        }
    
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Authorization: Bearer ' . $this->config->item('ai03f_api_key')
        ]);
    
        $response = curl_exec($ch);
    
        if (curl_errno($ch)) {
            log_message('error', 'cURL error: ' . curl_error($ch));
            return false;
        }
    
        curl_close($ch);
    
        return json_decode($response, true);
    }

    // Example: dump AI03-f config
    public function get_ai03f_config_dump() {
        $endpoint = $this->config->item('ai03f_base_url') . '/v1/config/dump';
        return $this->call_ai03f_api($endpoint, [], 'GET');
    }

    // Example: fetch logs from AI03-f
    public function get_ai03f_logs($limit = 50) {
        $endpoint = $this->config->item('ai03f_base_url') . '/v1/logs?limit=' . intval($limit);
        return $this->call_ai03f_api($endpoint, [], 'GET');
    }

}

