<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/* * *****************Marksheet.php**********************************
 * @product name    : Global Multi School Management System Express
 * @type            : Class
 * @class name      : Marksheet
 * @description     : Manage exam mark sheet.  
 * @author          : Codetroopers Team 	
 * @url             : https://themeforest.net/user/codetroopers      
 * @support         : yousuf361@gmail.com	
 * @copyright       : Codetroopers Team	 	
 * ********************************************************** */


class Marksheet extends MY_Controller {

    public $data = array();

    /** @var Marksheet_Model */
    public $mark;

    function __construct() {
        parent::__construct();
        $this->load->model('Marksheet_Model', 'mark', true);
        
        // need to check school subscription status
        if($this->session->userdata('role_id') != SUPER_ADMIN){                 
            if(!check_saas_status($this->session->userdata('school_id'), 'is_enable_exam_mark')){                        
              redirect('dashboard/index');
            }
        }
    }
    
    /*****************Function index**********************************
    * @type            : Function
    * @function name   : index
    * @description     : Load "Mark sheet" user interface                 
    *                    with data filter option
    * @param           : null
    * @return          : null 
    * ********************************************************** */
   public function index()
{
    check_permission(VIEW);

    if ($_POST) {

        // --- CASE 1: Student Logged In ---
        if ($this->session->userdata('role_id') == STUDENT) {
            $student = get_user_by_role(
                $this->session->userdata('role_id'),
                $this->session->userdata('id')
            );

            $school_id  = $student->school_id;
            $class_id   = $student->class_id;
            $section_id = $student->section_id;
            $students   = [$student]; // single student
            $academic_year_id = $this->input->post('academic_year_id') ?: get_academic_year_id($school_id);

        } else {
            // --- CASE 2: Admin/Teacher ---
            $school_id  = $this->input->post('school_id');
            $class_id   = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
            $student_id = $this->input->post('student_id');
            $academic_year_id = $this->input->post('academic_year_id');

            // Load school
            $school = $this->mark->get_school_by_id($school_id);

            // If academic year not selected, use current
            if (!$academic_year_id) {
                $academic_year_id = @$school->academic_year_id;
            }

            if ($student_id && $student_id !== 'all') {
                // Single student
                $student  = $this->mark->get_single('students', ['id' => $student_id]);
                $students = [get_user_by_role(STUDENT, @$student->user_id)];
            } else {
                // All students in class/section for selected year
                $students = $this->mark->get_student_list(
                    $school_id,
                    $class_id,
                    $section_id,
                    $academic_year_id
                );
            }
        }

        // --- Exam details ---
        $exam_id = $this->input->post('exam_id');
        $exam    = $this->mark->get_single('exams', ['id' => $exam_id]);

        // --- Ensure school info is available ---
        if (!isset($school)) {
            $school = $this->mark->get_school_by_id($school_id);
        }

        if (!$academic_year_id) {
            error($this->lang->line('set_academic_year_for_school'));
            redirect('exam/marksheet/index');
        }

        // --- Gather results ---
        $all_results = [];

        foreach ($students as $stu) {
            if (!$stu) continue;

            $student_id = $stu->id;

            // Fetch subjects and scores for the given year
            $subjects = $this->mark->get_subject_list(
                $school_id, $exam_id, $class_id, $section_id, $student_id, $academic_year_id
            );

            $subjects_sub = $this->mark->get_subject_list_with_sub(
                $school_id, $exam_id, $class_id, $section_id, $student_id, $academic_year_id
            );

            $subjects_with_comment = $this->mark->get_subject_list_with_comment(
                $school_id, $exam_id, $class_id, $section_id, $student_id, $academic_year_id
            );

            $all_results[] = [
                'student'               => $stu,
                'subjects'              => $subjects,
                'subjects_sub'          => $subjects_sub,
                'subjects_with_comment' => $subjects_with_comment,
            ];
        }

        // --- Data for the view ---
        $this->data['grades']           = $this->mark->get_list('grades', ['status' => 1, 'school_id' => $school_id], '', '', '', 'id', 'ASC');
        $this->data['school']           = $school;
        $this->data['exam']             = $exam;
        $this->data['school_id']        = $school_id;
        $this->data['exam_id']          = $exam_id;
        $this->data['class_id']         = $class_id;
        $this->data['section_id']       = $section_id;
        $this->data['academic_year_id'] = $academic_year_id;
        $this->data['all_results']      = $all_results;

        // --- Log activity ---
        $class = $this->mark->get_single('classes', ['id' => $class_id]);
        if ($class) {
            create_log('Viewed mark sheet for class: ' . $class->name . ' (Academic Year: ' . $academic_year_id . ')');
        }
    }

    // --- Load dropdown data ---
    $condition = ['status' => 1];
    if ($this->session->userdata('role_id') != SUPER_ADMIN) {
        $condition['school_id'] = $this->session->userdata('school_id');
        $school = $this->mark->get_school_by_id($condition['school_id']);

        $this->data['academic_years'] = $this->mark->get_list('academic_years', ['school_id' => $condition['school_id']], '', '', '', 'id', 'ASC');
        $this->data['classes']        = $this->mark->get_list('classes', $condition, '', '', '', 'id', 'ASC');

        if ($school) {
            $this->data['exams'] = $this->mark->get_list('exams', ['school_id' => $school->id], '', '', '', 'id', 'ASC');
        }
    }

    // --- Render view ---
    $this->layout->title($this->lang->line('manage_mark_sheet') . ' | ' . SMS);
    $this->layout->view('mark_sheet/index', $this->data);
}

	
	
	
	
	 /*****************Function marksheetall**********************************
 * @type            : Function
 * @function name   : marksheetall
 * @description     : Load "Mark sheet" interface                 
 *                    and display results for all students in a loop
 * @param           : null
 * @return          : null 
 * ********************************************************** */
public function marksheetall()
{
    check_permission(VIEW);

    if ($_POST) {

        // --- CASE 1: Student Logged In ---
        if ($this->session->userdata('role_id') == STUDENT) {
            $student = get_user_by_role(
                $this->session->userdata('role_id'),
                $this->session->userdata('id')
            );

            $school_id  = $student->school_id;
            $class_id   = $student->class_id;
            $section_id = $student->section_id;
            $students   = [$student]; // single student
            $academic_year_id = $this->input->post('academic_year_id') ?: get_academic_year_id($school_id);

        } else {
            // --- CASE 2: Admin/Teacher ---
            $school_id  = $this->input->post('school_id');
            $class_id   = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
            $student_id = $this->input->post('student_id');
            $academic_year_id = $this->input->post('academic_year_id');

            // Load school
            $school = $this->mark->get_school_by_id($school_id);

            // If academic year not selected, use current
            if (!$academic_year_id) {
                $academic_year_id = @$school->academic_year_id;
            }

            if ($student_id && $student_id !== 'all') {
                // Single student
                $student  = $this->mark->get_single('students', ['id' => $student_id]);
                $students = [get_user_by_role(STUDENT, @$student->user_id)];
            } else {
                // All students in class/section for selected year
                $students = $this->mark->get_student_list(
                    $school_id,
                    $class_id,
                    $section_id,
                    $academic_year_id
                );
            }
        }

        // --- Exam details ---
        $exam_id = $this->input->post('exam_id');
        $exam    = $this->mark->get_single('exams', ['id' => $exam_id]);

        // --- Ensure school info is available ---
        if (!isset($school)) {
            $school = $this->mark->get_school_by_id($school_id);
        }

        if (!$academic_year_id) {
            error($this->lang->line('set_academic_year_for_school'));
            redirect('exam/marksheet/marksheetall');
        }

        // --- Gather results ---
        $all_results = [];

        foreach ($students as $stu) {
            if (!$stu) continue;

            $student_id = $stu->id;

            // Fetch subjects and scores for the given year
            $subjects = $this->mark->get_subject_list(
                $school_id, $exam_id, $class_id, $section_id, $student_id, $academic_year_id
            );

            $subjects_sub = $this->mark->get_subject_list_with_sub(
                $school_id, $exam_id, $class_id, $section_id, $student_id, $academic_year_id
            );

            $subjects_with_comment = $this->mark->get_subject_list_with_comment(
                $school_id, $exam_id, $class_id, $section_id, $student_id, $academic_year_id
            );

            $all_results[] = [
                'student'               => $stu,
                'subjects'              => $subjects,
                'subjects_sub'          => $subjects_sub,
                'subjects_with_comment' => $subjects_with_comment,
            ];
        }

        // --- Data for the view ---
        $this->data['grades']           = $this->mark->get_list('grades', ['status' => 1, 'school_id' => $school_id], '', '', '', 'id', 'ASC');
        $this->data['school']           = $school;
        $this->data['exam']             = $exam;
        $this->data['school_id']        = $school_id;
        $this->data['exam_id']          = $exam_id;
        $this->data['class_id']         = $class_id;
        $this->data['section_id']       = $section_id;
        $this->data['academic_year_id'] = $academic_year_id;
        $this->data['all_results']      = $all_results;

        // --- Log activity ---
        $class = $this->mark->get_single('classes', ['id' => $class_id]);
        if ($class) {
            create_log('Viewed mark sheet for class: ' . $class->name . ' (Academic Year: ' . $academic_year_id . ')');
        }
    }

    // --- Load dropdown data ---
    $condition = ['status' => 1];
    if ($this->session->userdata('role_id') != SUPER_ADMIN) {
        $condition['school_id'] = $this->session->userdata('school_id');
        $school = $this->mark->get_school_by_id($condition['school_id']);

        $this->data['academic_years'] = $this->mark->get_list('academic_years', ['school_id' => $condition['school_id']], '', '', '', 'id', 'ASC');
        $this->data['classes']        = $this->mark->get_list('classes', $condition, '', '', '', 'id', 'ASC');

        if ($school) {
            $this->data['exams'] = $this->mark->get_list('exams', ['school_id' => $school->id], '', '', '', 'id', 'ASC');
        }
    }

    // --- Render view ---
    $this->layout->title($this->lang->line('manage_mark_sheet') . ' | ' . SMS);
    $this->layout->view('mark_sheet/marksheetall', $this->data);
}

	
	
	
	
	
	
	
	/*****************Function index**********************************
    * @type            : Function
    * @function name   : index
    * @description     : Load "Mark sheet" user interface                 
    *                    with data filter option
    * @param           : null
    * @return          : null 
    * ********************************************************** */
    public function midtermexam() {

        check_permission(VIEW);

        if ($_POST) {

            if($this->session->userdata('role_id') == STUDENT){
                
                $student = get_user_by_role($this->session->userdata('role_id'), $this->session->userdata('id'));
                
                $school_id = $student->school_id;
                $class_id = $student->class_id;
                $section_id = $student->section_id;
                $student_id = $student->id;
                
            }else{
                
                $school_id = $this->input->post('school_id');
                $class_id = $this->input->post('class_id');
                $section_id = $this->input->post('section_id');
                $student_id = $this->input->post('student_id');
                
                $student = $this->mark->get_single('students', array('id'=>$student_id));
                $student = get_user_by_role(STUDENT, @$student->user_id);
            }
            
            $exam_id = $this->input->post('exam_id');
            $exam = $this->mark->get_single('exams', array('id'=>$exam_id));
            
            $school = $this->mark->get_school_by_id($school_id);
            
            if(!$school->academic_year_id){
                error($this->lang->line('set_academic_year_for_school'));
                redirect('exam/marksheet/midtermexam');
            }
            
            $this->data['subjects'] = $this->mark->get_subject_list($school_id, $exam_id, $class_id, $section_id, $student_id, $school->academic_year_id);
            $this->data['grades'] = $this->mark->get_list('grades', array('status' => 1, 'school_id'=>$school_id), '', '', '', 'id', 'ASC');

            $this->data['school'] = $school;
            $this->data['exam'] = $exam;
            $this->data['student'] = $student;
            $this->data['school_id'] = $school_id;
            $this->data['exam_id'] = $exam_id;
            $this->data['class_id'] = $class_id;
            $this->data['section_id'] = $section_id;
            $this->data['student_id'] = $student_id;
            $this->data['academic_year_id'] = $school->academic_year_id;
            
            $class = $this->mark->get_single('classes', array('id'=>$class_id));
            create_log('Has been filter exam mark sheet for class: '. $class->name);
     
		
		$this->data['subjects_sub'] = $this->mark->get_subject_list_with_sub($school_id, $exam_id, $class_id, $section_id, $student_id, $school->academic_year_id);
		
		
		
            $this->data['grades'] = $this->mark->get_list('grades', array('status' => 1, 'school_id'=>$school_id), '', '', '', 'id', 'ASC');

            $this->data['school'] = $school;
            $this->data['exam'] = $exam;
            $this->data['student'] = $student;
            $this->data['school_id'] = $school_id;
            $this->data['exam_id'] = $exam_id;
            $this->data['class_id'] = $class_id;
            $this->data['section_id'] = $section_id;
            $this->data['student_id'] = $student_id;
            $this->data['academic_year_id'] = $school->academic_year_id;
            
            $class = $this->mark->get_single('classes', array('id'=>$class_id));
            create_log('Has been filter exam mark sheet for class: '. $class->name);
			
			$this->data['subjects_with_comment'] = $this->mark->get_subject_list_with_comment($school_id, $exam_id, $class_id, $section_id, $student_id, $school->academic_year_id);
            $this->data['grades'] = $this->mark->get_list('grades', array('status' => 1, 'school_id'=>$school_id), '', '', '', 'id', 'ASC');

            $this->data['school'] = $school;
            $this->data['exam'] = $exam;
            $this->data['student'] = $student;
            $this->data['school_id'] = $school_id;
            $this->data['exam_id'] = $exam_id;
            $this->data['class_id'] = $class_id;
            $this->data['section_id'] = $section_id;
            $this->data['student_id'] = $student_id;
            $this->data['academic_year_id'] = $school->academic_year_id;
            
            $class = $this->mark->get_single('classes', array('id'=>$class_id));
            create_log('Has been filter exam mark sheet for class: '. $class->name);
            
            
        }
        
       
        $condition = array();
        $condition['status'] = 1;        
        if($this->session->userdata('role_id') != SUPER_ADMIN){ 
            
            $condition['school_id'] = $this->session->userdata('school_id');
            $school = $this->mark->get_school_by_id($condition['school_id']);
            $this->data['academic_years'] = $this->mark->get_list('academic_years', $condition, '', '', '', 'id', 'ASC');
            
            $this->data['classes'] = $this->mark->get_list('classes', $condition, '','', '', 'id', 'ASC');
            
            $condition['academic_year_id'] = $school->academic_year_id;
            $this->data['exams'] = $this->mark->get_list('exams', $condition, '', '', '', 'id', 'ASC');
        }        

        $this->layout->title( $this->lang->line('manage_mark_sheet') . ' | ' . SMS);
        $this->layout->view('mark_sheet/midtermexam', $this->data);
    }
	
	
	
	
	
	
	 /*****************Function Cummulative**********************************
    * @type            : Function
    * @function name   : index
    * @description     : Load "Cummulative Markshhet" user interface                 
    *                    with data filter option
    * @param           : null
    * @return          : null 
    * ********************************************************** */
    public function cummulative() {

        check_permission(VIEW);

        if ($_POST) {

            if($this->session->userdata('role_id') == STUDENT){
                
                $student = get_user_by_role($this->session->userdata('role_id'), $this->session->userdata('id'));
                
                $school_id = $student->school_id;
                $class_id = $student->class_id;
                $section_id = $student->section_id;
                $student_id = $student->id;
                
            }else{
                
                $school_id = $this->input->post('school_id');
                $class_id = $this->input->post('class_id');
                $section_id = $this->input->post('section_id');
                $student_id = $this->input->post('student_id');
                
                $student = $this->mark->get_single('students', array('id'=>$student_id));
                $student = get_user_by_role(STUDENT, @$student->user_id);
            }
            
            $exam_id = $this->input->post('exam_id');
            $exam = $this->mark->get_single('exams', array('id'=>$exam_id));
            
            $school = $this->mark->get_school_by_id($school_id);
            
            if(!$school->academic_year_id){
                error($this->lang->line('set_academic_year_for_school'));
                redirect('exam/marksheet/index');
            }
            
            $this->data['subjects'] = $this->mark->get_subject_list($school_id, $exam_id, $class_id, $section_id, $student_id, $school->academic_year_id);
            $this->data['grades'] = $this->mark->get_list('grades', array('status' => 1, 'school_id'=>$school_id), '', '', '', 'id', 'ASC');

            $this->data['school'] = $school;
            $this->data['exam'] = $exam;
            $this->data['student'] = $student;
            $this->data['school_id'] = $school_id;
            $this->data['exam_id'] = $exam_id;
            $this->data['class_id'] = $class_id;
            $this->data['section_id'] = $section_id;
            $this->data['student_id'] = $student_id;
            $this->data['academic_year_id'] = $school->academic_year_id;
            
            $class = $this->mark->get_single('classes', array('id'=>$class_id));
            create_log('Has been filter exam mark sheet for class: '. $class->name);
        
			$this->data['subjects_sub'] = $this->mark->get_subject_list_with_sub($school_id, $exam_id, $class_id, $section_id, $student_id, $school->academic_year_id);
		
            $this->data['grades'] = $this->mark->get_list('grades', array('status' => 1, 'school_id'=>$school_id), '', '', '', 'id', 'ASC');

            $this->data['school'] = $school;
            $this->data['exam'] = $exam;
            $this->data['student'] = $student;
            $this->data['school_id'] = $school_id;
            $this->data['exam_id'] = $exam_id;
            $this->data['class_id'] = $class_id;
            $this->data['section_id'] = $section_id;
            $this->data['student_id'] = $student_id;
            $this->data['academic_year_id'] = $school->academic_year_id;
            
            $class = $this->mark->get_single('classes', array('id'=>$class_id));
            create_log('Has been filter exam mark sheet for class: '. $class->name);
			
			$this->data['subjects_with_comment'] = $this->mark->get_subject_list_with_comment($school_id, $exam_id, $class_id, $section_id, $student_id, $school->academic_year_id);
            $this->data['grades'] = $this->mark->get_list('grades', array('status' => 1, 'school_id'=>$school_id), '', '', '', 'id', 'ASC');

            $this->data['school'] = $school;
            $this->data['exam'] = $exam;
            $this->data['student'] = $student;
            $this->data['school_id'] = $school_id;
            $this->data['exam_id'] = $exam_id;
            $this->data['class_id'] = $class_id;
            $this->data['section_id'] = $section_id;
            $this->data['student_id'] = $student_id;
            $this->data['academic_year_id'] = $school->academic_year_id;
            
            $class = $this->mark->get_single('classes', array('id'=>$class_id));
            create_log('Has been filter exam mark sheet for class: '. $class->name);
            
            
        }
        
       $condition = array();
        $condition['status'] = 1;        
        if($this->session->userdata('role_id') != SUPER_ADMIN){ 
            
            $condition['school_id'] = $this->session->userdata('school_id');
            $school = $this->mark->get_school_by_id($condition['school_id']);
            $this->data['academic_years'] = $this->mark->get_list('academic_years', $condition, '', '', '', 'id', 'ASC');
            
            $this->data['classes'] = $this->mark->get_list('classes', $condition, '','', '', 'id', 'ASC');
            
            $condition['academic_year_id'] = $school->academic_year_id;
            $this->data['exams'] = $this->mark->get_list('exams', $condition, '', '', '', 'id', 'ASC');
        }        

        $this->layout->title( 'CUMMULATIVE RESULT' . ' | ' . SMS);
        $this->layout->view('mark_sheet/cummulative', $this->data);
    }
	


}