<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Marksheet_Model extends MY_Model {
    
    function __construct() {
        parent::__construct();
    }
    
    
     public function get_exam_result($school_id, $exam_id, $academic_year_id, $class_id, $section_id, $student_id){
        $this->db->select('ER.*, G.name AS grade');
        $this->db->from('exam_results AS ER');        
        $this->db->join('grades AS G', 'G.id = ER.grade_id', 'left');
        $this->db->where('ER.academic_year_id', $academic_year_id);
        $this->db->where('ER.school_id', $school_id);
        $this->db->where('ER.class_id', $class_id);
        $this->db->where('ER.section_id', $section_id);
        $this->db->where('ER.student_id', $student_id);
        return $this->db->get()->row();   
        //echo $this->db->last_query();   
    }
    
    public function get_subject_list($school_id, $exam_id, $class_id, $section_id, $student_id)//$academic_year_id)
    {
        $this->db->select('M.*,S.name AS subject, G.point, G.name');
        $this->db->from('marks AS M');        
        $this->db->join('subjects AS S', 'S.id = M.subject_id', 'left');
        $this->db->join('grades AS G', 'G.id = M.grade_id', 'left');
        
        //$this->db->where('M.academic_year_id', $academic_year_id); 
        $this->db->where('M.class_id', $class_id);
        $this->db->where('M.section_id', $section_id);
        $this->db->where('M.student_id', $student_id);
        $this->db->where('M.exam_id', $exam_id);
        $this->db->where('M.school_id', $school_id);
		$this->db->where('S.relation_id', '0');
		$this->db->where_not_in('M.obtain_total_mark', '0');
       
        return $this->db->get()->result();     
    }
	
	
	
	
	 public function get_subject_list_for_remark($school_id, $exam_id, $class_id, $section_id, $student_id,$academic_year_id)
    {
        $this->db->select('M.*,S.name AS subject, G.point, G.name');
        $this->db->from('marks AS M');        
        $this->db->join('subjects AS S', 'S.id = M.subject_id', 'left');
        $this->db->join('grades AS G', 'G.id = M.grade_id', 'left');
        
       // $this->db->where('M.academic_year_id', $academic_year_id); 
        $this->db->where('M.class_id', $class_id);
        $this->db->where('M.section_id', $section_id);
        $this->db->where('M.student_id', $student_id);
        $this->db->where('M.exam_id', $exam_id);
        $this->db->where('M.school_id', $school_id);
		$this->db->where('S.relation_id', '0');
		$this->db->where_not_in('M.remark', '');
       
        return $this->db->get()->result();     
    }
	
	
	 public function get_subject_list_with_sub($school_id, $exam_id, $class_id, $section_id, $student_id)
    {
        $this->db->select('M.*,S.name AS subject, G.point, G.name');
        $this->db->from('marks AS M');        
        $this->db->join('subjects AS S', 'S.id = M.subject_id', 'left');
        $this->db->join('grades AS G', 'G.id = M.grade_id', 'left');
        
        //$this->db->where('M.academic_year_id', $academic_year_id); 
        $this->db->where('M.class_id', $class_id);
        $this->db->where('M.section_id', $section_id);
        $this->db->where('M.student_id', $student_id);
        $this->db->where('M.exam_id', $exam_id);
        $this->db->where('M.school_id', $school_id);
		$this->db->where('S.relation_id', '0');
		$this->db->where_not_in('M.obtain_total_mark', '0' || 'M.remark', '' || 'M.rating', '');
       
        return $this->db->get()->result();     
    }
	
	
	 public function get_subject_list_with_subk($school_id, $exam_id, $class_id, $section_id, $student_id)
    {
        $this->db->select('M.*,S.name AS subject, G.point, G.name');
        $this->db->from('marks AS M');        
        $this->db->join('subjects AS S', 'S.id = M.subject_id', 'left');
        $this->db->join('grades AS G', 'G.id = M.grade_id', 'left');
        
        //$this->db->where('M.academic_year_id', $academic_year_id); 
        $this->db->where('M.class_id', $class_id);
        $this->db->where('M.section_id', $section_id);
        $this->db->where('M.student_id', $student_id);
        $this->db->where('M.exam_id', $exam_id);
        $this->db->where('M.school_id', $school_id);
		$this->db->where('S.relation_id', 'M.subject_id');
		$this->db->where_not_in('M.obtain_total_mark', '0' || 'M.remark', '' || 'M.rating', '');
       
        return $this->db->get()->result();     
    }
	
	
	 public function get_subject_list_with_comment($school_id, $exam_id, $class_id, $section_id, $student_id)
    {
        $this->db->select('M.*,S.name AS subject, G.point, G.name');
        $this->db->from('marks AS M');        
        $this->db->join('subjects AS S', 'S.id = M.subject_id', 'left');
        $this->db->join('grades AS G', 'G.id = M.grade_id', 'left');
        
       // $this->db->where('M.academic_year_id', $academic_year_id); 
        $this->db->where('M.class_id', $class_id);
        $this->db->where('M.section_id', $section_id);
        $this->db->where('M.student_id', $student_id);
        $this->db->where('M.exam_id', $exam_id);
        $this->db->where('M.school_id', $school_id);
		$this->db->where('S.relation_id', '0');
		$this->db->where_not_in('M.remark', '');
       
        return $this->db->get()->result();     
    }
	
	
	
	public function get_student_list($school_id, $class_id, $section_id = null){
         
        $this->db->select('E.roll_no,  S.id, S.name');
        $this->db->from('enrollments AS E');        
        $this->db->join('students AS S', 'S.id = E.student_id', 'left');
       // $this->db->where('E.academic_year_id', $academic_year_id);       
        $this->db->where('E.class_id', $class_id); 
        if($section_id){
            $this->db->where('E.section_id', $section_id); 
        }
        $this->db->where('E.school_id', $school_id);       
        $this->db->where('S.status_type', 'regular');       
        return $this->db->get()->result();    
    } 
    
    
    public function get_student_report($school_id, $class_id, $section_id){
     /**   
        $group_by_sql = '';
        $group_by_field = '';
        $sql_plus = '';
        
       if($group_by && $group_by == 'gender'){           
           $group_by_sql .= " GROUP BY C.name ORDER BY C.id ASC";
           $group_by_field .= ", C.name AS group_by_field";
           
       }elseif($group_by && $group_by == 'vehicle'){           
           $group_by_sql .= " GROUP BY C.name ORDER BY C.id ASC";
           $group_by_field .= ", C.name AS group_by_field";
           $sql_plus .= " AND S.is_transport_member = '1'";
       
	   
	    
       }elseif($group_by && $group_by == 'library'){           
           $group_by_sql .= " GROUP BY C.name ORDER BY C.id ASC";
           $group_by_field .= ", C.name AS group_by_field";
           $sql_plus .= " AND S.is_library_member = '1'";
           
       }elseif($group_by && $group_by == 'hostel'){           
           $group_by_sql .= " GROUP BY C.name ORDER BY C.id ASC";
           $group_by_field .= ", C.name AS group_by_field";
           $sql_plus .= " AND S.is_hostel_member = '1'";
           
       }elseif($group_by && $group_by == 'class'){           
           $group_by_sql .= " GROUP BY C.name ORDER BY C.id ASC";
           $group_by_field .= ", C.name AS group_by_field";
       } 
         **/ 
		 
        $sql = "SELECT S.id, COUNT(S.id) AS total, C.id as class_id, E.academic_year_id, AY.session_year $group_by_field 
                FROM students AS S 
                LEFT JOIN enrollments AS E ON E.student_id = S.id 
                LEFT JOIN classes AS C ON C.id = E.class_id 
                LEFT JOIN academic_years AS AY ON AY.id = E.academic_year_id 
                WHERE S.status = 1 ";
             
       if($academic_year_id){
           $sql_plus .= " AND E.academic_year_id = '$academic_year_id'";
       }
       if($school_id){
           $sql_plus .= " AND E.school_id = '$school_id'";
       }
	   if($class_id){
           $sql_plus .= " AND E.class_id = '$class_id'";
       }
       
       $sql .= $sql_plus;
       $sql .= $group_by_sql;
        
       return $this->db->query($sql)->result();
    }
    
    public function get_student_by_gender($school_id, $group_by, $class_id, $section_id, $gender){
        
        $extra = '';
        if($group_by == 'vehicle'){
            $extra = "AND S.is_transport_member = '1'"; 
        }
        if($group_by == 'library'){
            $extra = "AND S.is_library_member = '1'"; 
        }
        if($group_by == 'hostel'){
            $extra = "AND S.is_hostel_member = '1'"; 
        }
        
        $sql = "SELECT COUNT(S.id) AS total
                FROM exam_results 
                WHERE class_id = '$class_id'
				AND E.section_id = '$section_id' 
				AND E.school_id = '$school_id'                
                $extra
                AND E.academic_year_id = '$academic_year_id'";
         return $this->db->query($sql)->row()->total;
    }
  
}