<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Guardian.php**********************************
 * @product name    : Global Multi School Management System Express
 * @type            : Class
 * @class name      : Guardian
 * @description     : Manage guardian information.  
 * @author          : Codetroopers Team 	
 * @url             : https://themeforest.net/user/codetroopers      
 * @support         : yousuf361@gmail.com	
 * @copyright       : Codetroopers Team	 	
 * ********************************************************** */

class Guardian extends MY_Controller
{

    public $data = array();

    function __construct()
    {
        parent::__construct();
        $this->load->model('Guardian_Model', 'guardian', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Guardian List" user interface                 
     *                     
     * @param           : null
     * @return          : null 
     * ********************************************************** */
    public function index($school_id = null)
    {

        check_permission(VIEW);

        $this->data['guardians'] = $this->guardian->get_guardian_list($school_id);

        $this->data['roles'] = $this->guardian->get_list('roles', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['filter_school_id'] = $school_id;
        $this->data['schools'] = $this->schools;

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('manage_guardian') . ' | ' . SMS);
        $this->layout->view('guardian/index', $this->data);
    }


    /*****************Function add**********************************
     * @type            : Function
     * @function name   : add
     * @description     : Load "Add new Guardian" user interface                 
     *                    and process to store "Guardian" into database 
     * @param           : null
     * @return          : null 
     * ********************************************************** */
    public function add()
    {

        check_permission(ADD);

        if ($_POST) {


            // need to check school subscription status
            if ($this->session->userdata('role_id') != SUPER_ADMIN) {
                if (!check_saas_status($this->session->userdata('school_id'), 'guardian')) {
                    redirect('dashboard/index');
                }
            }

            $this->_prepare_guardian_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_guardian_data();

                $insert_id = $this->guardian->insert('guardians', $data);
                if ($insert_id) {

                    create_log('Has been added a Guardian : ' . $data['name']);
                    success($this->lang->line('insert_success'));
                    redirect('guardian/index/' . $data['school_id']);
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('guardian/add');
                }
            } else {
                error($this->lang->line('insert_failed'));
                $this->data['post'] = $_POST;
            }
        }

        $this->data['guardians'] = $this->guardian->get_guardian_list();
        $this->data['roles'] = $this->guardian->get_list('roles', array('status' => 1), '', '', '', 'id', 'ASC');

        $this->data['schools'] = $this->schools;

        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('add') . ' | ' . SMS);
        $this->layout->view('guardian/index', $this->data);
    }


    public function process_upload()
    {

        $condition = array();
        $condition['status'] = 1;
        $condition['school_id'] = $this->session->userdata('school_id');
        // Process uploaded CSV file
        $this->data['grades'] = $this->guardian->get_list('salary_grades', $condition, '', '', '', 'id', 'ASC');
        $this->data['departments'] = $this->guardian->get_list('departments', $condition, '', '', '', 'id', 'ASC');

        $this->data['roles'] = $this->guardian->get_list('roles', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['schools'] = $this->schools;
        $this->data['filter_school_id'] = $this->session->userdata('school_id');
        $this->data['schools'] = $this->schools;
        // Process uploaded CSV file
        if (isset($_FILES['csv_file']['name'])) {


            $config['upload_path'] = "assets/uploads/";
            $config['allowed_types'] = 'csv';
            $config['max_size'] = 1024; // Set an appropriate file size limit

            $this->load->library('upload', $config);

            if ($this->upload->do_upload('csv_file')) {

                $file_data = $this->upload->data();
                $file_path = $file_data['full_path'];

                // Process CSV data
                $csv_data = array_map('str_getcsv', file($file_path));

                // foreach ($csv_data as $row) {
                //     $teacher_data = array(
                //         'name' => $row[0],
                //         'national_id' => $row[1],
                //         // ... (other fields)
                //     );

                //     // Insert data into the database
                //     $this->db->insert('teachers', $teacher_data);
                // }

                // Delete uploaded CSV file after processing
                unlink($file_path);

                $this->data['upload'] = TRUE;
                $this->data['csv_data'] = $csv_data;
                $this->layout->title("Confirm Upload");
                $this->layout->view('guardian/confirmGuardianUpload', $this->data);
            } else {
                echo $this->upload->display_errors();
            }
        }
    }


    public function process_profiles2()
    {
        $guardian_profiles = $this->input->post('guardian_profiles');
        $school_id = $this->input->post('school_id');

        // print_r($guardian_profiles);

        if (!empty($guardian_profiles)) {
            foreach ($guardian_profiles as $profile) {
                print_r($profile);

                $t = [];
                $profile["school_id"] = $school_id;
                $profile["role_id"] = 3;
                $t["school_id"] = $school_id;
                $t["name"] = $profile['name'];
                $t["phone"] = $profile['phone'];
                $t["profession"] = $profile['profession'];
                $t["religion"] = $profile['religion'];
                $t["present_address"] = $profile['present_address'];
                $t["permanent_address"] = $profile['permanent_address'];
                $t["national_id"] = $profile['national_id'];
                $t["email"] = $profile['email'];

                $t["other_info"] = $profile['other_info'];
                // $photo = $profile['photo'];



                if ($this->input->post('id')) {
                    $t['modified_at'] = date('Y-m-d H:i:s');
                    $t['modified_by'] = logged_in_user_id();
                } else {
                    $t['created_at'] = date('Y-m-d H:i:s');
                    $t['created_by'] = logged_in_user_id();
                    $t['status'] = 1;
                    // create user 
                    try {
                        //code...
                        $t['user_id'] = $this->guardian->create_user_by_data($profile);
                    } catch (\Throwable $th) {
                        error($this->lang->line('insert_failed'));
                        redirect('guardian/index/' . $school_id);
                    }
                }

                if (isset($_FILES['photo']['name'])) {
                    $t['photo'] = $this->_upload_photo();
                }

                if (isset($_FILES['mother_photo']['name'])) {
                    $t['mother_photo'] = $this->_upload_photo();
                }

                if (isset($_FILES['father_photo']['name'])) {
                    $t['father_photo'] = $this->_upload_photo();
                }


                print_r($t);
                $insert_id = $this->guardian->insert('guardians', $t);
                if ($insert_id) {
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('guardian/index/' . $school_id);
                }
            }
            success($this->lang->line('insert_success'));
            redirect('teacher/index/' . $school_id);

            // redirect('teacher/index/' . $data['school_id']);

        }
        //     echo "All profiles submitted and processed successfully!";
        // } else {
        //     echo "No profiles submitted.";
        // }
    }
    /*****************Function edit**********************************
     * @type            : Function
     * @function name   : edit
     * @description     : Load Update "Guardian" user interface                 
     *                    with populate "Guardian" value 
     *                    and process to update "Guardian" into database    
     * @param           : $id integer value
     * @return          : null 
     * ********************************************************** */
    public function edit($id = null)
    {

        check_permission(EDIT);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('guardian/index');
        }

        if ($_POST) {
            $this->_prepare_guardian_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_guardian_data();
                $updated = $this->guardian->update('guardians', $data, array('id' => $this->input->post('id')));

                if ($updated) {

                    create_log('Has been updated a Guardian : ' . $data['name']);
                    success($this->lang->line('update_success'));
                    redirect('guardian/index/' . $data['school_id']);
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('guardian/edit/' . $this->input->post('id'));
                }
            } else {
                error($this->lang->line('update_failed'));
                $this->data['guardian'] = $this->guardian->get_single_guardian($this->input->post('id'));
            }
        }

        if ($id) {
            $this->data['guardian'] = $this->guardian->get_single_guardian($id);

            if (!$this->data['guardian']) {
                redirect('guardian/index');
            }
        }

        $this->data['guardians'] = $this->guardian->get_guardian_list($this->data['guardian']->school_id);
        $this->data['roles'] = $this->guardian->get_list('roles', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['school_id'] = $this->data['guardian']->school_id;

        $this->data['filter_school_id'] = $this->data['guardian']->school_id;
        $this->data['schools'] = $this->schools;

        $this->data['edit'] = TRUE;
        $this->layout->title($this->lang->line('edit') . ' | ' . SMS);
        $this->layout->view('guardian/index', $this->data);
    }




    /*****************Function get_single_guardian**********************************
     * @type            : Function
     * @function name   : get_single_guardian
     * @description     : "Load single guardian information" from database                  
     *                    to the user interface   
     * @param           : null
     * @return          : null 
     * ********************************************************** */
    public function get_single_guardian()
    {

        $guardian_id = $this->input->post('guardian_id');

        $this->data['guardian'] = $this->guardian->get_single_guardian($guardian_id);
        $school = $this->guardian->get_school_by_id($this->data['guardian']->school_id);
        $this->data['students'] = $this->guardian->get_student_list($guardian_id, $school->academic_year_id);
        $this->data['invoices'] = $this->guardian->get_invoice_list($this->data['guardian']->school_id, $guardian_id);

        echo $this->load->view('get-single-guardian', $this->data);
    }

    /*****************Function _prepare_guardian_validation**********************************
     * @type            : Function
     * @function name   : _prepare_guardian_validation
     * @description     : Process "Guardian" user input data validation                 
     *                       
     * @param           : null
     * @return          : null 
     * ********************************************************** */
    private function _prepare_guardian_validation()
    {
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');

        if (!$this->input->post('id')) {
            $this->form_validation->set_rules('username', $this->lang->line('username'), 'trim|required|callback_username');
            $this->form_validation->set_rules('password', $this->lang->line('password'), 'trim|required|min_length[5]|max_length[30]');
        }

        $this->form_validation->set_rules('email', $this->lang->line('email'), 'trim|valid_email');
        $this->form_validation->set_rules('school_id', $this->lang->line('school_name'), 'trim|required');
        $this->form_validation->set_rules('role_id', $this->lang->line('role'), 'trim|required');
        $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required');
        $this->form_validation->set_rules('phone', $this->lang->line('phone'), 'trim|required');
        $this->form_validation->set_rules('profession', $this->lang->line('profession'), 'trim');
        $this->form_validation->set_rules('present_address', $this->lang->line('present_address'), 'trim');
        $this->form_validation->set_rules('permanent_address', $this->lang->line('permanent_address'), 'trim');
        $this->form_validation->set_rules('religion', $this->lang->line('religion'), 'trim');
        $this->form_validation->set_rules('other_info', $this->lang->line('other_info'), 'trim');

        $this->form_validation->set_rules('photo', $this->lang->line('photo'), 'trim|callback_photo');
    }


    /*****************Function username**********************************
     * @type            : Function
     * @function name   : username
     * @description     : Unique check for "Guardian username" data/value                  
     *                       
     * @param           : null
     * @return          : boolean true/false 
     * ********************************************************** */
    public function username()
    {
        if ($this->input->post('id') == '') {
            $username = $this->guardian->duplicate_check($this->input->post('username'));
            if ($username) {
                $this->form_validation->set_message('username', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else if ($this->input->post('id') != '') {
            $username = $this->guardian->duplicate_check($this->input->post('username'), $this->input->post('id'));
            if ($username) {
                $this->form_validation->set_message('username', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            return TRUE;
        }
    }


    /*****************Function photo**********************************
     * @type            : Function
     * @function name   : photo
     * @description     : validate photo                  
     *                       
     * @param           : null
     * @return          : boolean true/false 
     * ********************************************************** */
    public function photo()
    {
        if ($_FILES['photo']['name']) {

            list($width, $height) = getimagesize($_FILES['photo']['tmp_name']);
            if ((!empty($width)) && $width > 120 || $height > 130) {
                $this->form_validation->set_message('photo', $this->lang->line('please_check_image_dimension'));
                return FALSE;
            }

            $name = $_FILES['photo']['name'];
            $ext = pathinfo($name, PATHINFO_EXTENSION);
            if ($ext == 'jpg' || $ext == 'jpeg' || $ext == 'png' || $ext == 'gif') {
                return TRUE;
            } else {
                $this->form_validation->set_message('photo', $this->lang->line('select_valid_file_format'));
                return FALSE;
            }
        }
    }




    /*****************Function father_photo**********************************
     * @type            : Function
     * @function name   : father_photo
     * @description     : validate student father_photo               
     *                       
     * @param           : null
     * @return          : boolean true/false 
     * ********************************************************** */
    public function father_photo()
    {
        if ($_FILES['father_photo']['name']) {

            list($width, $height) = getimagesize($_FILES['father_photo']['tmp_name']);
            if ((!empty($width)) && $width > 120 || $height > 130) {
                $this->form_validation->set_message('father_photo', $this->lang->line('please_check_image_dimension'));
                return FALSE;
            }

            $name = $_FILES['father_photo']['name'];
            $ext = pathinfo($name, PATHINFO_EXTENSION);
            if ($ext == 'jpg' || $ext == 'jpeg' || $ext == 'png' || $ext == 'gif') {
                return TRUE;
            } else {
                $this->form_validation->set_message('father_photo', $this->lang->line('select_valid_file_format'));
                return FALSE;
            }
        }
    }

    /*****************Function mother_photo**********************************
     * @type            : Function
     * @function name   : mother_photo
     * @description     : validate student mother_photo               
     *                       
     * @param           : null
     * @return          : boolean true/false 
     * ********************************************************** */
    public function mother_photo()
    {
        if ($_FILES['mother_photo']['name']) {

            list($width, $height) = getimagesize($_FILES['mother_photo']['tmp_name']);
            if ((!empty($width)) && $width > 120 || $height > 130) {
                $this->form_validation->set_message('mother_photo', $this->lang->line('please_check_image_dimension'));
                return FALSE;
            }

            $name = $_FILES['mother_photo']['name'];
            $ext = pathinfo($name, PATHINFO_EXTENSION);
            if ($ext == 'jpg' || $ext == 'jpeg' || $ext == 'png' || $ext == 'gif') {
                return TRUE;
            } else {
                $this->form_validation->set_message('mother_photo', $this->lang->line('select_valid_file_format'));
                return FALSE;
            }
        }
    }












    /*****************Function _get_posted_guardian_data**********************************
     * @type            : Function
     * @function name   : _get_posted_guardian_data
     * @description     : Prepare "Guardian" user input data to save into database                  
     *                       
     * @param           : null
     * @return          : $data array(); value 
     * ********************************************************** */
    private function _get_posted_guardian_data()
    {

        $items = array();

        $items[] = 'school_id';
        $items[] = 'national_id';
        $items[] = 'name';
        $items[] = 'phone';
        $items[] = 'email';
        $items[] = 'profession';
        $items[] = 'present_address';
        $items[] = 'permanent_address';
        $items[] = 'religion';
        $items[] = 'other_info';

        $data = elements($items, $_POST);

        if ($this->input->post('id')) {
            $data['modified_at'] = date('Y-m-d H:i:s');
            $data['modified_by'] = logged_in_user_id();
        } else {
            $data['created_at'] = date('Y-m-d H:i:s');
            $data['created_by'] = logged_in_user_id();
            $data['status'] = 1;
            // create user 
            $data['user_id'] = $this->guardian->create_user();
        }

        if ($_FILES['photo']['name']) {
            $data['photo'] = $this->_upload_photo();
        }

        if ($_FILES['father_photo']['name']) {
            $data['father_photo'] = $this->_upload_father_photo();
        }
        if ($_FILES['mother_photo']['name']) {
            $data['mother_photo'] = $this->_upload_mother_photo();
        }
        return $data;
    }



    /*****************Function _upload_photo**********************************
     * @type            : Function
     * @function name   : _upload_photo
     * @description     : Process to upload "Guardian" photo in the server                  
     *                    and return photo name    
     * @param           : null
     * @return          : $return_photo string value 
     * ********************************************************** */
    private function _upload_photo()
    {

        $prev_photo = $this->input->post('prev_photo');
        $photo = $_FILES['photo']['name'];
        $photo_type = $_FILES['photo']['type'];
        $return_photo = '';
        if ($photo != "") {
            if (
                $photo_type == 'image/jpeg' || $photo_type == 'image/pjpeg' ||
                $photo_type == 'image/jpg' || $photo_type == 'image/png' ||
                $photo_type == 'image/x-png' || $photo_type == 'image/gif'
            ) {

                $destination = 'assets/uploads/guardian-photo/';

                $file_type = explode(".", $photo);
                $extension = strtolower($file_type[count($file_type) - 1]);
                $photo_path = 'photo-' . time() . '-sms.' . $extension;

                move_uploaded_file($_FILES['photo']['tmp_name'], $destination . $photo_path);

                // need to unlink previous photo
                if ($prev_photo != "") {
                    if (file_exists($destination . $prev_photo)) {
                        @unlink($destination . $prev_photo);
                    }
                }

                $return_photo = $photo_path;
            }
        } else {
            $return_photo = $prev_photo;
        }

        return $return_photo;
    }




    /*****************Function _upload_father_photo**********************************
     * @type            : Function
     * @function name   : _upload_father_photo
     * @description     : process to upload student profile photo in the server                  
     *                     and return photo file name  
     * @param           : null
     * @return          : $return_father_photo string value 
     * ********************************************************** */
    private function _upload_father_photo()
    {

        $prev_father_photo = $this->input->post('prev_father_photo');
        $father_photo = $_FILES['father_photo']['name'];
        $father_photo_type = $_FILES['father_photo']['type'];
        $return_father_photo = '';
        if ($father_photo != "") {
            if (
                $father_photo_type == 'image/jpeg' || $father_photo_type == 'image/pjpeg' ||
                $father_photo_type == 'image/jpg' || $father_photo_type == 'image/png' ||
                $father_photo_type == 'image/x-png' || $father_photo_type == 'image/gif'
            ) {

                $destination = 'assets/uploads/father-photo/';

                $file_type = explode(".", $father_photo);
                $extension = strtolower($file_type[count($file_type) - 1]);
                $father_photo_path = 'photo-' . time() . '-sms.' . $extension;

                move_uploaded_file($_FILES['father_photo']['tmp_name'], $destination . $father_photo_path);

                // need to unlink previous father_photo
                if ($prev_father_photo != "") {
                    if (file_exists($destination . $prev_father_photo)) {
                        @unlink($destination . $prev_father_photo);
                    }
                }

                $return_father_photo = $father_photo_path;
            }
        } else {
            $return_father_photo = $prev_father_photo;
        }

        return $return_father_photo;
    }




    /*****************Function _upload_mother_photo**********************************
     * @type            : Function
     * @function name   : _upload_mother_photo
     * @description     : process to upload mother profile photo in the server                  
     *                     and return photo file name  
     * @param           : null
     * @return          : $return_mother_photo string value 
     * ********************************************************** */
    private function _upload_mother_photo()
    {

        $prev_mother_photo = $this->input->post('prev_mother_photo');
        $mother_photo = $_FILES['mother_photo']['name'];
        $mother_photo_type = $_FILES['mother_photo']['type'];
        $return_mother_photo = '';
        if ($mother_photo != "") {
            if (
                $mother_photo_type == 'image/jpeg' || $mother_photo_type == 'image/pjpeg' ||
                $mother_photo_type == 'image/jpg' || $mother_photo_type == 'image/png' ||
                $mother_photo_type == 'image/x-png' || $mother_photo_type == 'image/gif'
            ) {

                $destination = 'assets/uploads/mother-photo/';

                $file_type = explode(".", $mother_photo);
                $extension = strtolower($file_type[count($file_type) - 1]);
                $mother_photo_path = 'photo-' . time() . '-sms.' . $extension;

                move_uploaded_file($_FILES['mother_photo']['tmp_name'], $destination . $mother_photo_path);

                // need to unlink previous mother_photo
                if ($prev_mother_photo != "") {
                    if (file_exists($destination . $prev_mother_photo)) {
                        @unlink($destination . $prev_mother_photo);
                    }
                }

                $return_mother_photo = $mother_photo_path;
            }
        } else {
            $return_mother_photo = $prev_mother_photo;
        }

        return $return_mother_photo;
    }














    /*****************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "Guardian" data from database                  
     *                    and unlink guardian photo from server   
     * @param           : $id integer value
     * @return          : null 
     * ********************************************************** */
    public function delete($id = null)
    {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('guardian/index');
        }


        $guardian = $this->guardian->get_single('guardians', array('id' => $id));
        $students = $this->guardian->get_list('students', array('guardian_id' => $id), '', '', '', 'id', 'ASC');

        if (!empty($students)) {

            error($this->lang->line('delete_student_of_this_guardian'));
            redirect('guardian/index/' . $guardian->school_id);
        }

        if ($this->guardian->delete('guardians', array('id' => $id))) {

            // delete guardian login data
            $this->guardian->delete('users', array('id' => $guardian->user_id));

            // delete guardian resume and photo
            $destination = 'assets/uploads/';
            if (file_exists($destination . '/guardian-photo/' . $guardian->photo)) {
                @unlink($destination . '/guardian-photo/' . $guardian->photo);
            }

            create_log('Has been deleted a Guardian : ' . $guardian->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }

        redirect('guardian/index/' . $guardian->school_id);
    }

    /*****************Function due**********************************
     * @type            : Function
     * @function name   : due
     * @description     : Load "Due Invoice List" user interface                 
     *                        
     * @param           : null
     * @return          : null 
     * ***********************************************************/
    public function invoice()
    {

        if (GUARDIAN != logged_in_role_id()) {
            error($this->lang->line('unexpected_error'));
            redirect('dashboard/index');
        }

        $this->data['invoices'] = $this->guardian->get_invoice_list($this->session->userdata('school_id'), $this->session->userdata('profile_id'));

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('invoice') . ' | ' . SMS);
        $this->layout->view('invoice/invoice', $this->data);
    }


    /*****************Function view**********************************
     * @type            : Function
     * @function name   : view
     * @description     : Load "Guardian view" user interface                 
     *                     
     * @param           : null
     * @return          : null 
     * ********************************************************** */
    public function view($id = null)
    {

        check_permission(VIEW);

        $this->data['guardian'] = $this->guardian->get_single_guardian($id);
        $school = $this->guardian->get_school_by_id($this->data['guardian']->school_id);
        $this->data['students'] = $this->guardian->get_student_list($id, $school->academic_year_id);
        $this->data['invoices'] = $this->guardian->get_invoice_list($this->data['guardian']->school_id, $id);


        $this->data['guardians'] = $this->guardian->get_guardian_list($this->data['guardian']->school_id);
        $this->data['roles'] = $this->guardian->get_list('roles', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['filter_school_id'] = $this->data['guardian']->school_id;
        $this->data['schools'] = $this->schools;

        $this->data['detail'] = TRUE;
        $this->layout->title($this->lang->line('manage_guardian') . ' | ' . SMS);
        $this->layout->view('guardian/index', $this->data);
    }
}
